<?php

#################################################################################
#    PHP-RESIDENCE
#    Copyright (C) 2001-2004 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#################################################################################

$pag = "creaprezzi.php";
$titolo = "Crea prezzi php-residence";

include("./dati/dati_connessione.php");
include("./includes/funzioni_$PHPR_DB_TYPE.php");
$numconnessione = connetti_db($PHPR_DB_NAME,$PHPR_DB_HOST,$PHPR_DB_PORT,$PHPR_DB_USER,$PHPR_DB_PASS,$PHPR_LOAD_EXT);
include("./includes/funzioni.php");
include("./includes/sett_gio.php");


$id_utente = controlla_login($numconnessione,$PHPR_TAB_PRE,$id_sessione,$nome_utente_phpr,$password_phpr,$anno);
if ($id_utente and $id_utente == 1) {


if ($tema[$id_utente] and $tema[$id_utente] != "base" and @is_dir("./includes/themes/".$tema[$id_utente])) include("./includes/themes/".$tema[$id_utente]."/head.php");
else include("./includes/head.php");




/*
STRUTTURA TABELLA NOMI TARIFFE

COSTI AGGIUNTIVI
tipo_ca(varchar2)		u-s			1  unico - settimanale
				f-p-t-c-r		2  fisso - percentuale su tariffa - percentuale su totale - percentuale su caparra - percentuale su resto caparra
associasett_ca(varchar1)	s-n			1  NULL o vuoto se costo unico, associa a specifiche settimane della prenotazione: si-no
numsett_ca(varchar20)		t-m-c-n-s-g,		1  tutte - tutte meno una - chiedere - x settimane no e y si - x settimane si e y no - solo giorni della settimana selezionati
				;p-u;;x,y;x,y;1-7,...	2- niente se 1=t ; prima-ultima se 1=m ; ...
moltiplica_ca(varchar1)		1-c-p-t			1  moltiplica per: 1 - chiedere - persone - persnone totali
periodipermessi_ca(text)	t-u-p			NULL o vuoto se periodi tutti permessi, altrimenti: tutta la prenotazione dentro i periodi - anche un solo periodo - solo periodi permessi
				idperiodo-idperiodo,...	
variazione_ca(varchar10)	s-n			1 modifica con costo della prenotazione il costo percentuale: si-no
				s-n			2 modifica numero settimane con prenotazione: si-no
				s-n			3 modifica numero con cui moltiplicare con prenotazione: si-no
				s-n			4 modifica in periodi permessi con prenotazione: si-no
				s-n			5 togli/aggiungi il costo se modificando una prenotazione cambia una tariffa associata: si-no
				s-n			6 togli il costo se modificando una prenotazione si passa ad una tariffa incompatibile: si-no
mostra_ca(varchar1)		s-n			1 mostra costo quando si inserisce prenotazione: si-no
letto_ca(varchar1)		s-n			1 considera come letto aggiuntivo: si-no
numlimite_ca(integer)		numero			NULL o vuoto o zero se non ci sono limiti al numero di costi nello stesso periodo
tariffe(varchar40)		s-p-i			1 NULL o vuoto se costo non associato alla tariffa e non incompatibile, altrimenti: associare sempre - solo se possibile - incompatibile
				s-<x->x-=x		per qualsiasi numero di settimane - meno di x - più di x - per x settimane
*/




$Euro = nome_valuta();
$stile_data = stile_data();

$numcaselle = 8;
$tableperiodi = $PHPR_TAB_PRE."periodi".$anno;
$tablenometariffe = $PHPR_TAB_PRE."ntariffe".$anno;
$tableanni = $PHPR_TAB_PRE."anni";
$tablepersonalizza = $PHPR_TAB_PRE."personalizza";

$tipo_periodi = esegui_query("select * from $tableanni where idanni = $anno");
$tipo_periodi = risul_query($tipo_periodi,0,tipo_periodi);


if ($importa_tariffa) {
if ($tariffa_a == $tariffa_da) $errore = "SI";
if (substr($tariffa_a,0,7) != "tariffa" or controlla_num_pos(substr($tariffa_a,7)) != "SI") $errore = "SI";
if (substr($tariffa_da,0,7) != "tariffa" or controlla_num_pos(substr($tariffa_da,7)) != "SI") $errore = "SI";
$importa_arrotond = formatta_soldi($importa_arrotond);
if (!$importa_arrotond) $importa_arrotond = 1;
if (controlla_num($importa_percent) == "NO" or $importa_percent < -99) $errore = "SI";
if ($errore != "SI") {
$mostra_form_iniziale = "NO";
$prezzi_da = esegui_query("select idperiodi,$tariffa_da from $tableperiodi where $tariffa_da is not NULL");
$num_prezzi_da = numlin_query($prezzi_da);
settype($importa_percent,"double");
settype($importa_arrotond,"double");
for ($num1 = 0 ; $num1 < $num_prezzi_da ; $num1++) {
$id_periodo = risul_query($prezzi_da,$num1,idperiodi);
$prezzo_a = (double) risul_query($prezzi_da,$num1,$tariffa_da);
$perc = (double) (($prezzo_a / 100.0) * $importa_percent);
if ($perc) {
$perc = (round(($perc / $importa_arrotond),0) * $importa_arrotond);
$prezzo_a = $prezzo_a + $perc;
} # fine if ($perc)
esegui_query("update $tableperiodi set $tariffa_a = '$prezzo_a' where idperiodi = '$id_periodo'");
} # fine for $num1
echo mex("I prezzi della tariffa selezionata sono stati importati",$pag).".<br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"OK\"><br>
</form>";
} # fine if ($errore != "SI")
} # fine if ($importa_tariffa)


# Inserisco la caparra
if ($modificacaparra) {
if (substr($tipotariffa,0,7) != "tariffa" or controlla_num_pos(substr($tipotariffa,7)) != "SI") $tipotariffa = "tariffa1";
$tabelle_lock = array("$tablenometariffe");
$tabelle_lock = lock_tabelle($tabelle_lock);
$caparra_arrotond = formatta_soldi($caparra_arrotond);
if (!$caparra_arrotond) { $caparra_arrotond = 1; }
if (!$caparra_percent) { echo mex("Si deve inserire la percentuale",$pag)."."; }
else {
esegui_query("update $tablenometariffe set $tipotariffa = '".addslashes($caparra_percent)."' where idntariffe = 2");
esegui_query("update $tablenometariffe set $tipotariffa = '".addslashes($caparra_arrotond)."' where idntariffe = 3");
echo mex("La caparra è stata modificata",$pag).".";
} # fine else if (!$caparra_percent)
unlock_tabelle($tabelle_lock);
echo "
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"OK\"><br>
</form>";
} # fine if ($modificacaparra)

else {



# Inserisco i costi aggiuntivi
if ($inseriscicosti) {
if ($avanti) $passo++;
if ($avanti and $tipo_ca != "s" and $passo == 4) $passo++;
if ($indietro) $passo--;
if ($indietro and $tipo_ca != "s" and $passo == 4) $passo--;
if ($passo > 1) {
$mostra_form_iniziale = "NO";
$tabelle_lock = array("$tablenometariffe");
$altre_tab_lock = array("$tableperiodi");
$tabelle_lock = lock_tabelle($tabelle_lock,$altre_tab_lock);

if (defined("C_MASSIMO_NUM_COSTI_AGG") and C_MASSIMO_NUM_COSTI_AGG != 0) {
$num_costi_agg_esistenti = esegui_query("select idntariffe from $tablenometariffe where idntariffe > 4");
$num_costi_agg_esistenti = numlin_query($num_costi_agg_esistenti);
if ($num_costi_agg_esistenti >= C_MASSIMO_NUM_COSTI_AGG) $errore = "SI";
} # fine if (defined("C_MASSIMO_NUM_COSTI_AGG") and C_MASSIMO_NUM_COSTI_AGG != 0)

if (get_magic_quotes_gpc()) $nomecostoagg = stripslashes($nomecostoagg);
$nomecostoagg = str_replace("#?&","",$nomecostoagg);
$nomecostoagg = str_replace("#@&","",$nomecostoagg);
if (!$nomecostoagg) {
$messaggio_errore = mex("Si deve inserire il nome del costo aggiuntivo",$pag).".<br>";
$errore = "SI";
} # fine if (!$nomecostoagg)
if ($tipo_ca != "u" and $tipo_ca != "s") $errore = "SI";
if ($errore != "SI") {
$esiste_costo = esegui_query("select idntariffe from $tablenometariffe where nomecostoagg = '$nomecostoagg' and tipo_ca $LIKE '".$tipo_ca."_'");
if (numlin_query($esiste_costo) > 0) {
$messaggio_errore = mex("Costi aggiuntivo già esistente",$pag).".<br>";
$errore = "SI";
} # fine if (numlin_query($esiste_costo) > 0)
} # fine if ($errore != "SI")

echo "<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"inseriscicosti\" value=\"SI\">
<input type=\"hidden\" name=\"nomecostoagg\" value=\"$nomecostoagg\">
<input type=\"hidden\" name=\"tipo_ca\" value=\"$tipo_ca\">";

if ($passo >= 3) {
if ($tipo_valore_ca != "f" and $tipo_valore_ca != "p") $errore = "SI";
$valore_f_ca = formatta_soldi($valore_f_ca);
$valore_p_ca = formatta_soldi($valore_p_ca);
$arrotonda_ca = formatta_soldi($arrotonda_ca);
if ($tipo_valore_ca == "f" and ($valore_f_ca == "" or controlla_soldi($valore_f_ca) == "NO")) $errore = "SI";
if ($tipo_valore_ca == "p" and ($valore_p_ca == "" or controlla_soldi($valore_p_ca) == "NO" or $arrotonda_ca == "" or controlla_soldi($arrotonda_ca,"SI") == "NO")) $errore = "SI";
if ($tipo_valore_ca == "p" and $tipo_percentuale != "tariffa" and $tipo_percentuale != "totale" and $tipo_percentuale != "caparra" and $tipo_percentuale != "resto") $errore = "SI";
if ($tipo_valore_ca == "p" and $tipo_ca == "s" and $tipo_percentuale != "tariffa") $errore = "SI";
echo "<input type=\"hidden\" name=\"tipo_valore_ca\" value=\"$tipo_valore_ca\">
<input type=\"hidden\" name=\"valore_f_ca\" value=\"$valore_f_ca\">
<input type=\"hidden\" name=\"tipo_percentuale\" value=\"$tipo_percentuale\">
<input type=\"hidden\" name=\"valore_p_ca\" value=\"$valore_p_ca\">
<input type=\"hidden\" name=\"arrotonda_ca\" value=\"$arrotonda_ca\">";
} # fine if ($passo >= 3)

if ($passo >= 4) {
if ($associa_tariffe != "n" and $associa_tariffe != "s" and $associa_tariffe != "p") $errore = "SI";
if ($tipo_ca != "s" and $associasett != "") $errore = "SI";
if ($tipo_ca == "s" and $associasett == "") $errore = "SI";
if ($tipo_valore_ca == "p" and $associasett == "n") $errore = "SI";
if ($associasett != "" and $associasett != "n" and $associasett != "s") $errore = "SI";
echo "<input type=\"hidden\" name=\"associa_tariffe\" value=\"$associa_tariffe\">
<input type=\"hidden\" name=\"associasett\" value=\"$associasett\">";
$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
if ($associa_tariffe != "n") {
#if ($tipo_valore_ca == "p" and $tipo_percentuale == "totale" and ${"sel".$tariffa} == "s") {
#$costo_agg_totale_presente = esegui_query("select * from $tablenometariffe  where idntariffe > 4 and $tariffa != '' and tipo_ca $LIKE '_q' ");
#if (numlin_query($costo_agg_totale_presente) > 0) $errore = "SI";
#} # fine if ($tipo_valore_ca == "p" and $tipo_percentuale == "totale")
if (${"sel".$tariffa} != "" and ${"sel".$tariffa} != "s") $errore = "SI";
} # fine if ($associa_tariffe != "n")
echo "<input type=\"hidden\" name=\"sel$tariffa\" value=\"".${"sel".$tariffa}."\">";
if (${"minmax".$tariffa} != "" and ${"minmax".$tariffa} != "min" and ${"minmax".$tariffa} != "max" and ${"minmax".$tariffa} != "eq") $errore = "SI";
if (${"valminmax".$tariffa} and (controlla_num_pos(${"valminmax".$tariffa}) == "NO" or ${"valminmax".$tariffa} == 0)) $errore = "SI";
if (${"sel".$tariffa} and ${"minmax".$tariffa} and !${"valminmax".$tariffa}) $errore = "SI";
echo "<input type=\"hidden\" name=\"minmax$tariffa\" value=\"".${"minmax".$tariffa}."\">
<input type=\"hidden\" name=\"valminmax$tariffa\" value=\"".${"valminmax".$tariffa}."\">";
} # fine for $numtariffa
} # fine if ($passo >= 4)

if ($passo >= 5) {
echo "<input type=\"hidden\" name=\"numsett_ca\" value=\"$numsett_ca\">
<input type=\"hidden\" name=\"pos_menouna\" value=\"$pos_menouna\">
<input type=\"hidden\" name=\"val1_prime_si\" value=\"$val1_prime_si\">
<input type=\"hidden\" name=\"val2_prime_si\" value=\"$val2_prime_si\">
<input type=\"hidden\" name=\"val1_prime_no\" value=\"$val1_prime_no\">
<input type=\"hidden\" name=\"val2_prime_no\" value=\"$val2_prime_no\">
<input type=\"hidden\" name=\"lun_sel\" value=\"$lun_sel\">
<input type=\"hidden\" name=\"mar_sel\" value=\"$mar_sel\">
<input type=\"hidden\" name=\"mer_sel\" value=\"$mer_sel\">
<input type=\"hidden\" name=\"gio_sel\" value=\"$gio_sel\">
<input type=\"hidden\" name=\"ven_sel\" value=\"$ven_sel\">
<input type=\"hidden\" name=\"sab_sel\" value=\"$sab_sel\">
<input type=\"hidden\" name=\"dom_sel\" value=\"$dom_sel\">";
if ($tipo_ca == "s") {
if ($numsett_ca != "t" and $numsett_ca != "m" and $numsett_ca != "c" and $numsett_ca != "s" and $numsett_ca != "n" and $numsett_ca != "g") $errore = "SI";
if ($tipo_periodi != "g" and $numsett_ca == "g") $errore = "SI";
if ($pos_menouna != "" and $tipo_valore_ca != "p" and $associasett != "s") $errore = "SI";
if (($pos_menouna != "p" and $pos_menouna != "u") and ($tipo_valore_ca == "p" or $associasett == "s")) $errore = "SI";
if ($associa_tariffe != "n" and $numsett_ca == "c") $errore = "SI";
if ($associasett != "s" and ($numsett_ca == "s" or $numsett_ca == "n" or $numsett_ca == "g")) $errore = "SI";
if ($numsett_ca == "s") {
if (controlla_num_pos($val1_prime_si) == "NO" or $val1_prime_si ==  0) $errore = "SI";
if (controlla_num_pos($val2_prime_si) == "NO" or $val2_prime_si ==  0) $errore = "SI";
} # fine if ($numsett_ca == "s")
if ($numsett_ca == "n") {
if (controlla_num_pos($val1_prime_no) == "NO" or $val1_prime_no ==  0) $errore = "SI";
if (controlla_num_pos($val2_prime_no) == "NO" or $val2_prime_no ==  0) $errore = "SI";
} # fine if ($numsett_ca == "n")
if ($lun_sel != "" and $lun_sel != "s") $errore = "SI";
if ($mar_sel != "" and $mar_sel != "s") $errore = "SI";
if ($mer_sel != "" and $mer_sel != "s") $errore = "SI";
if ($gio_sel != "" and $gio_sel != "s") $errore = "SI";
if ($ven_sel != "" and $ven_sel != "s") $errore = "SI";
if ($sab_sel != "" and $sab_sel != "s") $errore = "SI";
if ($dom_sel != "" and $dom_sel != "s") $errore = "SI";
} # fine if ($tipo_ca == "s")
else if ($numsett_ca != "") $errore = "SI";
} # fine if ($passo >= 5)

if ($passo >= 6) {
echo "<input type=\"hidden\" name=\"moltiplica_ca\" value=\"$moltiplica_ca\">";
if ($moltiplica_ca != "1" and $moltiplica_ca != "c" and $moltiplica_ca != "p" and $moltiplica_ca != "t") $errore = "SI";
if ($associa_tariffe != "n" and $moltiplica_ca == "c") $errore = "SI";
} # fine if ($passo >= 6)

if ($passo >= 7) {
echo "<input type=\"hidden\" name=\"periodi_permessi\" value=\"$periodi_permessi\">
<input type=\"hidden\" name=\"num_periodi_permessi_sel\" value=\"$num_periodi_permessi_sel\">
<input type=\"hidden\" name=\"tipo_pp\" value=\"$tipo_pp\">";
for ($num1 = 1 ; $num1 <= $num_periodi_permessi_sel ; $num1++) {
echo "<input type=\"hidden\" name=\"pp_dal$num1\" value=\"".${"pp_dal".$num1}."\">
<input type=\"hidden\" name=\"pp_al$num1\" value=\"".${"pp_al".$num1}."\">";
} # fine for $num1
if ($periodi_permessi != "tutti" and $periodi_permessi != "sel") $errore = "SI";
if ($periodi_permessi == "sel") {
if (controlla_num_pos($num_periodi_permessi_sel) == "NO" or $num_periodi_permessi_sel == 0) $errore = "SI";
else {
$file_date_int = implode("",file("./dati/selectperiodi$anno.1.php"));
$ultima_data = 0;
for ($num1 = 1 ; $num1 <= $num_periodi_permessi_sel ; $num1++) {
if (str_replace("\\\"".${"pp_dal".$num1}."\\\">","",$file_date_int) == $file_date_int) $errore = "SI";
if (str_replace("\\\"".${"pp_al".$num1}."\\\">","",$file_date_int) == $file_date_int) $errore = "SI";
$nuova_ultima_data = str_replace("-","",${"pp_dal".$num1});
if ($nuova_ultima_data <= $ultima_data) $errore = "SI";
else $ultima_data = $nuova_ultima_data;
$nuova_ultima_data = str_replace("-","",${"pp_al".$num1});
if ($nuova_ultima_data <= $ultima_data) $errore = "SI";
else $ultima_data = $nuova_ultima_data;
} # fine for $num1
} # fine else if (controlla_num_pos($num_periodi_permessi_sel) == "NO" or...
} # fine if ($periodi_permessi == "sel")
if ($tipo_pp != "t" and $tipo_pp != "u" and $tipo_pp != "p") $errore = "SI";
if ($tipo_ca != "s" and $tipo_pp == "p") $errore = "SI";
} # fine if ($passo >= 7)

if ($passo >= 8) {
$tariffe_incompatibili = "NO";
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
if (${"incomp_".$tariffa} != "" and ${"incomp_".$tariffa} != "i") $errore = "SI";
if ((${"sel".$tariffa} == "s" and $associa_tariffe != "n") and ${"incomp_".$tariffa} != "") $errore = "SI";
if (${"incomp_".$tariffa} == "i") {
$tariffe_incompatibili = "SI";
echo "<input type=\"hidden\" name=\"incomp_$tariffa\" value=\"".${"incomp_".$tariffa}."\">";
} # fine if (${"incomp_".$tariffa} == "i")
} # fine for $numtariffa
} # fine if ($passo >= 8)

if ($passo >= 9) {
if ($mantenere_percentuale != "s" or $tipo_valore_ca != "p") $mantenere_percentuale = "n";
if (($mantenere_percentuale == "n" and $tipo_valore_ca == "p") and ($tipo_ca == "s" and $numsett_ca != "c")) $mantenere_numsett = "n";
if ($mantenere_numsett != "s" or ($tipo_ca != "s" or $numsett_ca == "c")) $mantenere_numsett = "n";
if (($mantenere_percentuale == "n" and $tipo_valore_ca == "p") and ($moltiplica_ca != "c" and $moltiplica_ca != "1")) $mantenere_moltiplica = "n";
if ($mantenere_moltiplica != "s" or $moltiplica_ca == "c") $mantenere_moltiplica = "n";
if ($mantenere_periodip != "s" or $periodi_permessi == "tutti") $mantenere_periodip = "n";
if ($mantenere_tariffea != "s" or $associa_tariffe == "n") $mantenere_tariffea = "n";
if ($mantenere_tariffei != "s" or $tariffe_incompatibili != "SI") $mantenere_tariffei = "n";
echo "<input type=\"hidden\" name=\"mantenere_percentuale\" value=\"$mantenere_percentuale\">
<input type=\"hidden\" name=\"mantenere_numsett\" value=\"$mantenere_numsett\">
<input type=\"hidden\" name=\"mantenere_moltiplica\" value=\"$mantenere_moltiplica\">
<input type=\"hidden\" name=\"mantenere_periodip\" value=\"$mantenere_periodip\">
<input type=\"hidden\" name=\"mantenere_tariffea\" value=\"$mantenere_tariffea\">
<input type=\"hidden\" name=\"mantenere_tariffei\" value=\"$mantenere_tariffei\">
<input type=\"hidden\" name=\"mostra_ca\" value=\"$mostra_ca\">
<input type=\"hidden\" name=\"letto_ca\" value=\"$letto_ca\">
<input type=\"hidden\" name=\"limite_ca\" value=\"$limite_ca\">
<input type=\"hidden\" name=\"numlimite_ca\" value=\"$numlimite_ca\">";
if ($associa_tariffe != "n" and $mostra_ca != "n") $errore = "SI";
if ($associa_tariffe == "n" and $mostra_ca != "s" and $mostra_ca != "n") $errore = "SI";
if ($letto_ca != "n" and $letto_ca != "s" and ($moltiplica_ca != "p" and $moltiplica_ca != "t" and ($tipo_valore_ca != "p" or $tipo_percentuale == "tariffa"))) $errore = "SI";
if ($letto_ca != "n" and ($moltiplica_ca == "p" or $moltiplica_ca == "t" or ($tipo_valore_ca == "p" and $tipo_percentuale != "tariffa"))) $errore = "SI";
if ($limite_ca != "n" and $limite_ca != "s" and ($tipo_ca != "s" or $associasett == "s" or ($numsett_ca == "t" and ($periodi_permessi == "tutti" or $tipo_pp != "pp")))) $errore = "SI";
if ($limite_ca != "" and ($tipo_ca == "s" and $associasett != "s" and ($numsett_ca != "t" or ($periodi_permessi != "tutti" and $tipo_pp == "pp")))) $errore = "SI";
if ($limite_ca == "s" and (controlla_num_pos($numlimite_ca) == "NO" or $numlimite_ca == 0)) $errore = "SI";
} # fine if ($passo >= 9)

if ($passo >= 10) $errore = "SI";

if ($errore != "SI") {

# Preprocesso di alcuni passi

if ($passo == 7) {
unset($lista_tariffe_p7);
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
$nometariffa = risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa $nometariffa";
if (${"sel".$tariffa} != "s" or $associa_tariffe == "n") {
if (${"incomp_".$tariffa} == "i") $checked = " checked";
else $checked = "";
$lista_tariffe_p7 .= "<input type=\"checkbox\" name=\"incomp_$tariffa\" value=\"i\"$checked>$nometariffa_vedi
</td></tr><tr><td></td><td>";
} # fine if (${"sel".$tariffa} != "s" or $associa_tariffe == "n")
} # fine for $numtariffa
if (!$lista_tariffe_p7) {
if ($indietro) $passo--;
else $passo++;
} # fine if (!$lista_tariffe_p7)
} # fine if ($passo == 7)

# Processo dei passi

if ($passo == 2) {
echo "<table><tr><td>".mex("Valore del costo",$pag).":</td><td>";
if (!$tipo_valore_ca) $tipo_valore_ca = "f";
if ($tipo_valore_ca == "f") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"tipo_valore_ca\" value=\"f\"$checked> ".mex("fisso di",$pag)."
<input type=\"text\" name=\"valore_f_ca\" value=\"$valore_f_ca\" size=\"12\">$Euro</td></tr>
<tr><td></td><td>";
if ($tipo_valore_ca == "p") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"tipo_valore_ca\" value=\"p\"$checked> ".mex("percentuale su",$pag)."
<select name=\"tipo_percentuale\">";
if ($tipo_percentuale == "tariffa") $selected = " selected";
else $selected = "";
echo "<option value=\"tariffa\"$selected>".mex("la tariffa",$pag)."</option>";
if ($tipo_ca != "s") {
if ($tipo_percentuale == "totale") $selected = " selected";
else $selected = "";
echo "<option value=\"totale\"$selected>".mex("il prezzo totale",$pag)."</option>";
if ($tipo_percentuale == "caparra") $selected = " selected";
else $selected = "";
echo "<option value=\"caparra\"$selected>".mex("la caparra",$pag)."</option>";
if ($tipo_percentuale == "resto") $selected = " selected";
else $selected = "";
echo "<option value=\"resto\"$selected>".mex("totale meno caparra",$pag)."</option>";
} # fine if ($tipo_ca != "s")
echo "</select> ".mex("del",$pag)."
<input type=\"text\" name=\"valore_p_ca\" value=\"$valore_p_ca\" size=\"4\">% ".mex("arrotondato a",$pag)."
<input type=\"text\" name=\"arrotonda_ca\" value=\"$arrotonda_ca\" size=\"6\">$Euro</td></tr>
</table><br>";
} # fine if ($passo == 2)

if ($passo == 3) {
echo mex("Assegnare automaticamente con le tariffe selezionate",$pag)."? ";
echo "<br><table><tr><td width=\"10\"></td><td>";
if (!$associa_tariffe) $associa_tariffe = "n";
if ($associa_tariffe == "n") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"associa_tariffe\" value=\"n\"$checked> ".mex("No",$pag)." ";
if ($associa_tariffe == "p") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"associa_tariffe\" value=\"p\"$checked> ".mex("Se possibile",$pag)." ";
if ($associa_tariffe == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"associa_tariffe\" value=\"s\"$checked> ".mex("Sempre",$pag)." ";
echo "</td></tr></table>
<table><tr><td></td><td>".mex("Tariffe",$pag).":</td><td>";
$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
#if ($tipo_valore_ca == "p" and $tipo_percentuale == "totale") {
#$costo_agg_totale_presente = esegui_query("select * from $tablenometariffe  where idntariffe > 4 and $tariffa != '' and tipo_ca $LIKE '_q' ");
#if (numlin_query($costo_agg_totale_presente) > 0) $mostra_tariffa_corrente = "NO";
#else $mostra_tariffa_corrente = "SI";
#} # fine if ($tipo_valore_ca == "p" and $tipo_percentuale == "totale")
#else $mostra_tariffa_corrente = "SI";
#if ($mostra_tariffa_corrente == "SI") {
$nometariffa = risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa $nometariffa";
if (${"sel".$tariffa} == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"sel$tariffa\" value=\"s\"$checked>$nometariffa_vedi";
echo " (<select name=\"minmax$tariffa\">";
if (!${"minmax".$tariffa}) $selected = " selected";
else $selected = "";
echo "<option value=\"\"$selected>----</option>";
if (${"minmax".$tariffa} == "min") $selected = " selected";
else $selected = "";
echo "<option value=\"min\"$selected>".mex("minimo",$pag)."</option>";
if (${"minmax".$tariffa} == "max") $selected = " selected";
else $selected = "";
echo "<option value=\"max\"$selected>".mex("massimo",$pag)."</option>";
if (${"minmax".$tariffa} == "eq") $selected = " selected";
else $selected = "";
echo "<option value=\"eq\"$selected>".mex("esattamente",$pag)."</option>
</select>
<input type=\"text\" name=\"valminmax$tariffa\" value=\"".${"valminmax".$tariffa}."\" size=\"3\">
".mex("$parola_settimane",$pag).")";
echo "</td></tr>
<tr><td></td><td></td><td>";
#} # fine if ($mostra_tariffa_corrente == "SI")
} # fine for $numtariffa
echo "</td></tr></table><br>";
if ($tipo_ca == "s") {
echo mex("Associare a specifi$sillaba_che $parola_settimane della prenotazione",$pag)."?";
echo " <select name=\"associasett\">";
if ($tipo_valore_ca != "p") {
if ($associasett == "n") $selected = " selected";
else $selected = "";
echo "<option value=\"n\"$selected>".mex("NO",$pag)."</option>";
} # fine if ($tipo_valore_ca != "p")
if ($associasett == "s") $selected = " selected";
else $selected = "";
echo "<option value=\"s\"$selected>".mex("SI",$pag)."</option>
</select><br><br>";
} # fine if ($tipo_ca == "s")
} # fine if ($passo == 3)

if ($passo == 4) {
echo mex("$parola_Le $parola_settimane a cui applicare il costo",$pag).":<br>
<table><tr><td width=\"20\"></td><td>";
if (!$numsett_ca) $numsett_ca = "t";
if ($numsett_ca == "t") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"t\"$checked> ".mex("Tutt$lettera_e",$pag)."</td></tr>
<tr><td></td><td>";
if ($numsett_ca == "m") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"m\"$checked> ".mex("Tutt$lettera_e meno",$pag);
if ($tipo_valore_ca == "p" or $associasett == "s") {
echo " <select name=\"pos_menouna\">";
if ($pos_menouna == "p") $selected = " selected";
else $selected = "";
echo "<option value=\"p\"$selected>".mex("$parola_la prim$lettera_a",$pag)."</option>";
if ($pos_menouna == "u") $selected = " selected";
else $selected = "";
echo "<option value=\"u\"$selected>".mex("l'ultim$lettera_a",$pag)."</option>";
echo "</select></td></tr>";
} # fine if ($tipo_valore_ca == "p" or $associasett == "s")
else echo " ".mex("un$lettera_a",$pag)."</td></tr>";
echo "<tr><td></td><td>";
if ($associa_tariffe == "n") {
if ($numsett_ca == "c") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"c\"$checked> ".mex("Chiedere",$pag)."</td></tr>
<tr><td></td><td>";
} # fine if ($associa_tariffe == "n")
if ($associasett == "s") {
if ($numsett_ca == "s") $checked = " checked";
else $checked = "";
if (!$val1_prime_si) $val1_prime_si = "1";
if (!$val2_prime_si) $val2_prime_si = "1";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"s\"$checked>
 <input type=\"text\" name=\"val1_prime_si\" value=\"$val1_prime_si\" size=\"3\"> ".mex("$parola_settimane sì",$pag)." ".mex("e",$pag)."
 <input type=\"text\" name=\"val2_prime_si\" value=\"$val2_prime_si\" size=\"3\"> ".mex("$parola_settimane no",$pag)."</td></tr>
<tr><td></td><td>";
if ($numsett_ca == "n") $checked = " checked";
else $checked = "";
if (!$val1_prime_no) $val1_prime_no = "1";
if (!$val2_prime_no) $val2_prime_no = "1";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"n\"$checked>
 <input type=\"text\" name=\"val1_prime_no\" value=\"$val1_prime_no\" size=\"3\"> ".mex("$parola_settimane no",$pag)." ".mex("e",$pag)."
 <input type=\"text\" name=\"val2_prime_no\" value=\"$val2_prime_no\" size=\"3\"> ".mex("$parola_settimane sì",$pag)."</td></tr>
<tr><td></td><td>";
if ($tipo_periodi == "g") {
if ($numsett_ca == "g") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"numsett_ca\" value=\"g\"$checked> ".mex("Giorni della settimana selezionati",$pag).":<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if ($lun_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"lun_sel\" value=\"s\"$checked>".mex("Lunedì",$pag)."&nbsp;&nbsp;&nbsp;";
if ($mar_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"mar_sel\" value=\"s\"$checked>".mex("Martedì",$pag)."<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if ($mer_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"mer_sel\" value=\"s\"$checked>".mex("Mercoledì",$pag)."&nbsp;&nbsp;&nbsp;";
if ($gio_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"gio_sel\" value=\"s\"$checked>".mex("Giovedì",$pag)."<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if ($ven_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"ven_sel\" value=\"s\"$checked>".mex("Venerdì",$pag)."&nbsp;&nbsp;&nbsp;";
if ($sab_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"sab_sel\" value=\"s\"$checked>".mex("Sabato",$pag)."<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if ($dom_sel == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"dom_sel\" value=\"s\"$checked>".mex("Domenica",$pag)."</td></tr>";
} # fine if ($tipo_periodi == "g")
} # fine if ($associasett == "s")
echo "</table><br>";
} # fine if ($passo == 4)

if ($passo == 5) {
echo mex("Moltiplicare il costo per",$pag).":<br>
<table><tr><td width=\"20\"></td><td>";
if (!$moltiplica_ca) $moltiplica_ca = "1";
if ($moltiplica_ca == "1") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"moltiplica_ca\" value=\"1\"$checked> ".mex("Uno",$pag)."</td></tr>
<tr><td></td><td>";
if ($associa_tariffe == "n") {
if ($moltiplica_ca == "c") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"moltiplica_ca\" value=\"c\"$checked> ".mex("Chiedere",$pag)."</td></tr>
<tr><td></td><td>";
} # fine if ($associa_tariffe == "n")
if ($moltiplica_ca == "p") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"moltiplica_ca\" value=\"p\"$checked> ".mex("Numero di persone",$pag)." (".mex("escluse quelle dei costi con letti aggiuntivi",$pag).")</td></tr>
<tr><td></td><td>";
if ($moltiplica_ca == "t") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"moltiplica_ca\" value=\"t\"$checked> ".mex("Numero di persone totale",$pag)."</td></tr>
</table><br>";
} # fine if ($passo == 5)

if ($passo == 6) {
echo mex("Periodi in cui è permesso inserire il costo",$pag).":<br>
<table><tr><td width=\"20\"></td><td>";
if (!$periodi_permessi) $periodi_permessi = "tutti";
if ($periodi_permessi == "tutti") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"periodi_permessi\" value=\"tutti\"$checked> ".mex("In tutti",$pag)."</td></tr>
<tr><td></td><td>";
if ($periodi_permessi == "sel") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"periodi_permessi\" value=\"sel\"$checked> ".mex("Solo nei periodi selezionati",$pag).":</td><td>";
if (!$num_periodi_permessi_sel) $num_periodi_permessi_sel = 1;
if ($aggiungi_periodo_permesso) $num_periodi_permessi_sel++;
if ($elimina_periodo_permesso) $num_periodi_permessi_sel--;
for ($num1 = 1 ; $num1 <= $num_periodi_permessi_sel ; $num1++) {
if ($num1 > 1) echo "<tr><td></td><td></td><td>";
echo mex("dal",$pag)." ";
mostra_menu_date("./dati/selectperiodi$anno.1.php","pp_dal$num1",${"pp_dal".$num1},"","",$id_utente,$tema);
echo " ".mex("al",$pag)." ";
mostra_menu_date("./dati/selectperiodi$anno.1.php","pp_al$num1",${"pp_al".$num1},"","",$id_utente,$tema);
if ($num1 == $num_periodi_permessi_sel) {
if ($num1 > 1) echo "</td><td><input class=\"sbutton\" type=\"submit\" name=\"elimina_periodo_permesso\" value=\"".mex("Elimina un periodo",$pag)."\"></td></tr><tr><td></td><td></td><td>";
echo "</td><td><input class=\"sbutton\" type=\"submit\" name=\"aggiungi_periodo_permesso\" value=\"".mex("Aggiungi un periodo",$pag)."\">";
} # fine if ($num1 == $num_periodi_permessi_sel)
echo "</td></tr>";
} # fine for $num1
echo "<input type=\"hidden\" name=\"num_periodi_permessi_sel\" value=\"$num_periodi_permessi_sel\">
</table>
<table><tr><td width=\"50\"></td><td>";
if (!$tipo_pp) $tipo_pp = "t";
if ($tipo_pp == "t") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"tipo_pp\" value=\"t\"$checked> ".mex("se tutt$lettera_e $parola_le $parola_settimane della prenotazione sono all'interno dei periodi selezionati",$pag)."</td></tr>
<tr><td></td><td>";
if ($tipo_pp == "u") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"tipo_pp\" value=\"u\"$checked> ".mex("se anche un$lettera_a2 sol$lettera_a $parola_settimana della prenotazione è all'interno dei periodi selezionati",$pag)."</td></tr>";
if ($tipo_ca == "s") {
echo "<tr><td></td><td>";
if ($tipo_pp == "p") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"tipo_pp\" value=\"p\"$checked> ".mex("applicare il costo solo in $parola_settimane permess$lettera_e all'interno della prenotazione",$pag)."</td></tr>";
} # fine if ($tipo_ca == "s")
echo "</table><br>";
} # fine if ($passo == 6)

if ($passo == 7) {
if ($lista_tariffe_p7) {
echo mex("Tariffe incompatibili con il costo",$pag).":<br>
<table><tr><td height=2></td></tr><tr><td width=\"10\"></td><td>
$lista_tariffe_p7
</td></tr></table><br>";
} # fine if ($lista_tariffe_p7)
} # fine if ($passo == 7)

if ($passo == 8) {
if ($tipo_valore_ca == "p" or ($tipo_ca == "s" and $numsett_ca != "c") or $moltiplica_ca != "c" or $periodi_permessi != "tutti" or $associa_tariffe != "n" or $tariffe_incompatibili == "SI") {
echo mex("Caratteristiche del costo da mantenere quando si modifica una prenotazione",$pag).":
<table>";
if ($tipo_valore_ca == "p") {
if (!$mantenere_percentuale) $mantenere_percentuale = "s";
if ($mantenere_percentuale == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\"></td><td colspan=2><input type=\"checkbox\" name=\"mantenere_percentuale\" value=\"s\"$checked>
".mex("Valore percentuale",$pag);
if ($tipo_ca == "s" and $associasett == "s") echo " ".mex("e settimane associate",$pag);
if (($tipo_ca == "s" and $numsett_ca != "c") or ($moltiplica_ca != "c" and $moltiplica_ca != "1")) echo ", ".mex("se selezionato mantenere anche:",$pag);
echo "</td></tr>";
} # fine if ($tipo_valore_ca == "p")
if ($tipo_ca == "s" and $numsett_ca != "c") {
if (!$mantenere_numsett) $mantenere_numsett = "s";
if ($mantenere_numsett == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\"></td>";
if ($tipo_valore_ca == "p") echo "<td width=\"50\"></td>";
echo "<td><input type=\"checkbox\" name=\"mantenere_numsett\" value=\"s\"$checked>
".mex("Assegnazione $parola_settimane",$pag)."</td></tr>";
} # fine if ($tipo_ca == "s" and $numsett_ca != "c")
if ($moltiplica_ca != "c") {
if (!$mantenere_moltiplica) $mantenere_moltiplica = "s";
if ($mantenere_moltiplica == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\">";
if ($tipo_valore_ca == "p" and $moltiplica_ca != "1") echo "<td width=\"50\"></td>";
echo "</td><td colspan=2><input type=\"checkbox\" name=\"mantenere_moltiplica\" value=\"s\"$checked>
".mex("Numero per cui viene moltiplicato",$pag)."</td></tr>";
} # fine if ($moltiplica_ca != "c")
if ($periodi_permessi != "tutti") {
if (!$mantenere_periodip) $mantenere_periodip = "s";
if ($mantenere_periodip == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\"></td><td colspan=2><input type=\"checkbox\" name=\"mantenere_periodip\" value=\"s\"$checked>
".mex("Periodi permessi",$pag)."</td></tr>";
} # fine if ($periodi_permessi != "tutti")
if ($associa_tariffe != "n") {
if (!$mantenere_tariffea) $mantenere_tariffea = "s";
if ($mantenere_tariffea == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\"></td><td colspan=2><input type=\"checkbox\" name=\"mantenere_tariffea\" value=\"s\"$checked>
".mex("Associazione alle tariffe",$pag)."</td></tr>";
} # fine if ($associa_tariffe != "n")
if ($tariffe_incompatibili == "SI") {
if (!$mantenere_tariffei) $mantenere_tariffei = "s";
if ($mantenere_tariffei == "s") $checked = " checked";
else $checked = "";
echo "<tr><td width=\"30\"></td><td colspan=2><input type=\"checkbox\" name=\"mantenere_tariffei\" value=\"s\"$checked>
".mex("Tariffe incompatibili",$pag)."</td></tr>";
} # fine if ($tariffe_incompatibili == "SI")
echo "</table><br>";
} # fine if ($tipo_valore_ca == "p" or $tipo_ca == "s" or $moltiplica_ca != "c" or $periodi_permessi != "tutti" or...
if ($associa_tariffe == "n") {
echo mex("Mostrare nella pagina di inserimento delle prenotazioni",$pag)."?
 <select name=\"mostra_ca\">";
if ($mostra_ca == "s") $selected = " selected";
else $selected = "";
echo "<option value=\"s\"$selected>".mex("SI",$pag)."</option>";
if ($mostra_ca == "n") $selected = " selected";
else $selected = "";
echo "<option value=\"n\"$selected>".mex("NO",$pag)."</option>
</select><br><br>";
} # fine if ($associa_tariffe == "n")
else echo "<input type=\"hidden\" name=\"mostra_ca\" value=\"n\">";
if ($moltiplica_ca != "p" and $moltiplica_ca != "t" and ($tipo_valore_ca != "p" or $tipo_percentuale == "tariffa")) {
echo mex("Considerare il costo come letto/i aggiuntivo/i",$pag)."?
 <select name=\"letto_ca\">";
if ($letto_ca == "n") $selected = " selected";
else $selected = "";
echo "<option value=\"n\"$selected>".mex("NO",$pag)."</option>";
if ($letto_ca == "s") $selected = " selected";
else $selected = "";
echo "<option value=\"s\"$selected>".mex("SI",$pag)."</option>
</select><br><br>";
} # fine if ($moltiplica_ca != "p" and...
else echo "<input type=\"hidden\" name=\"letto_ca\" value=\"n\">";
if ($tipo_ca != "s" or $associasett == "s" or ($numsett_ca == "t" and ($periodi_permessi == "tutti" or $tipo_pp != "pp"))) {
echo "<table><tr><td valign=\"top\">".mex("Limitarne il numero che è possibile avere contemporaneamente in uno stesso periodo",$pag)."?</td>
<td width=\"110\">";
if (!$limite_ca) $limite_ca = "n";
if (!$numlimite_ca) $numlimite_ca = "1";
if ($limite_ca == "n") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"limite_ca\" value=\"n\"$checked> ".mex("No",$pag)."<br>";
if ($limite_ca == "s") $checked = " checked";
else $checked = "";
echo "<input type=\"radio\" name=\"limite_ca\" value=\"s\"$checked> ".mex("Si",$pag).":
<input type=\"text\" name=\"numlimite_ca\" value=\"$numlimite_ca\" size=\"4\">
</td></tr></table><br>";
} # fine if ($tipo_ca != "s" or...
} # fine if ($passo == 8)

if ($passo == 9) {
$idntariffe = esegui_query("select numlimite_ca from $tablenometariffe where idntariffe = 1");
$idntariffe = risul_query($idntariffe,0,0);
if ($tipo_valore_ca == "p" and $tipo_percentuale == "totale") $tipo_valore_ca = "t";
if ($tipo_valore_ca == "p" and $tipo_percentuale == "caparra") $tipo_valore_ca = "c";
if ($tipo_valore_ca == "p" and $tipo_percentuale == "resto") $tipo_valore_ca = "r";
if ($tipo_valore_ca == "f") $valore_ca = $valore_f_ca;
else $valore_ca = $valore_p_ca;
$valore_ca = formatta_soldi($valore_ca);
$nomecostoagg = addslashes($nomecostoagg);
$variazione_ca = $mantenere_percentuale.$mantenere_numsett.$mantenere_moltiplica.$mantenere_periodip.$mantenere_tariffea.$mantenere_tariffei;
esegui_query("insert into $tablenometariffe (idntariffe,nomecostoagg,tipo_ca,valore_ca,moltiplica_ca,variazione_ca,mostra_ca,letto_ca) values ('$idntariffe','$nomecostoagg','$tipo_ca$tipo_valore_ca','$valore_ca','$moltiplica_ca','$variazione_ca','$mostra_ca','$letto_ca')");
if ($tipo_valore_ca != "f") {
$arrotonda_ca = formatta_soldi($arrotonda_ca);
esegui_query("update $tablenometariffe set arrotonda_ca = '$arrotonda_ca' where idntariffe = '$idntariffe'");
} # fine if ($tipo_valore_ca != "f")
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
unset($valtariffa);
if ($associa_tariffe != "n") {
if (${"sel".$tariffa} == "s") {
$valtariffa = "s";
if (${"minmax".$tariffa} != "") {
if (${"minmax".$tariffa} == "min") $valtariffa = ">";
if (${"minmax".$tariffa} == "max") $valtariffa = "<";
if (${"minmax".$tariffa} == "eq") $valtariffa = "=";
$valtariffa .= ${"valminmax".$tariffa};
} # fine if (${"minmax".$tariffa} != "")
$valtariffa = $associa_tariffe.$valtariffa;
} # fine if (${"sel".$tariffa} == "s")
} # fine if ($associa_tariffe != "n")
if (${"incomp_".$tariffa} == "i") $valtariffa = "i";
if ($valtariffa) esegui_query("update $tablenometariffe set $tariffa = '$valtariffa' where idntariffe = '$idntariffe'");
} # fine for $numtariffa
if ($tipo_ca == "s") {
esegui_query("update $tablenometariffe set associasett_ca = '$associasett' where idntariffe = '$idntariffe'");
$valnumsett_ca = $numsett_ca;
if ($numsett_ca == "m" and $pos_menouna != "") $valnumsett_ca .= $pos_menouna;
if ($numsett_ca == "s") $valnumsett_ca .= $val1_prime_si.",".$val2_prime_si;
if ($numsett_ca == "n") $valnumsett_ca .= $val1_prime_no.",".$val2_prime_no;
if ($numsett_ca == "g") {
$giorni_sel = "";
if ($lun_sel == "s") $giorni_sel .= ",1";
if ($mar_sel == "s") $giorni_sel .= ",2";
if ($mer_sel == "s") $giorni_sel .= ",3";
if ($gio_sel == "s") $giorni_sel .= ",4";
if ($ven_sel == "s") $giorni_sel .= ",5";
if ($sab_sel == "s") $giorni_sel .= ",6";
if ($dom_sel == "s") $giorni_sel .= ",7";
if ($giorni_sel) $giorni_sel = substr($giorni_sel,1);
$valnumsett_ca .= $giorni_sel;
} # fine if ($numsett_ca == "g")
esegui_query("update $tablenometariffe set numsett_ca = '$valnumsett_ca' where idntariffe = '$idntariffe'");
} # fine if ($tipo_ca == "s")
if ($periodi_permessi == "sel") {
$periodipermessi_ca = "";
for ($num1 = 1 ; $num1 <= $num_periodi_permessi_sel ; $num1++) {
$idinizioperiodo = esegui_query("select idperiodi from $tableperiodi where datainizio = '".${"pp_dal".$num1}."' ");
$idinizioperiodo = risul_query($idinizioperiodo,0,idperiodi);
$idfineperiodo = esegui_query("select idperiodi from $tableperiodi where datafine = '".${"pp_al".$num1}."' ");
$idfineperiodo = risul_query($idfineperiodo,0,idperiodi);
$periodipermessi_ca .= ",".$idinizioperiodo."-".$idfineperiodo;
} # fine for $num1
$periodipermessi_ca = $tipo_pp.substr($periodipermessi_ca,1);
esegui_query("update $tablenometariffe set periodipermessi_ca = '$periodipermessi_ca' where idntariffe = '$idntariffe'");
} # fine if ($periodi_permessi == "sel")
if ($limite_ca == "s") esegui_query("update $tablenometariffe set numlimite_ca = '$numlimite_ca' where idntariffe = '$idntariffe'");
$idntariffe++;
esegui_query("update $tablenometariffe set numlimite_ca = '$idntariffe' where idntariffe = 1");
echo "</form>
".mex("Il costo aggiuntivo",$pag)." \"".stripslashes($nomecostoagg)."\" ".mex("è stato inserito",$pag).".<br><br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"OK\"><br>
</form>";
} # fine if ($passo == 9)

} # fine if ($errore != "SI")
else {
if ($messaggio_errore) echo $messaggio_errore;
else echo mex("Errore nei valori inseriti",$pag).".<br>";
} # fine else if ($errore != "SI")

if ($passo != 9 or $errore == "SI") {
echo "<input type=\"hidden\" name=\"passo\" value=\"$passo\">
<input class=\"sbutton\" type=\"submit\" name=\"indietro\" value=\"< ".mex("indietro",$pag)."\">";
if ($errore != "SI") echo "<input class=\"sbutton\" type=\"submit\" name=\"avanti\" value=\"".mex("avanti",$pag)." >\">";
echo "<br></form>";
} # fine if ($passo != 9 or $errore == "SI")

unlock_tabelle($tabelle_lock);
} # fine if ($passo > 1)
} # fine if ($inseriscicosti)



if ($inserisci_settimanalmente) {
if (substr($tipotariffa,0,7) != "tariffa" or controlla_num_pos(substr($tipotariffa,7)) != "SI") $tipotariffa = "tariffa1";
$num_tariffa = substr($tipotariffa,7);
$inizioperiodo = addslashes($inizioperiodosett1);
$fineperiodo = addslashes($fineperiodosett1);
$idinizioperiodo = esegui_query("select idperiodi from $tableperiodi where datainizio = '$inizioperiodo' ");
$num_idinizioperiodo = numlin_query($idinizioperiodo);
if ($num_idinizioperiodo == 0) { $idinizioperiodo = 10000; }
else { $idinizioperiodo = risul_query($idinizioperiodo,0,idperiodi); }
$inizioperiodo = $idinizioperiodo;
$idfineperiodo = esegui_query("select idperiodi from $tableperiodi where datafine = '$fineperiodo' ");
$num_idfineperiodo = numlin_query($idfineperiodo);
if ($num_idfineperiodo == 0) { $idfineperiodo = -1; }
else { $idfineperiodo = risul_query($idfineperiodo,0,idperiodi); }
$fineperiodo = $idfineperiodo ;
if ($idfineperiodo < $idinizioperiodo) {
$inserire_prezzi = "NO";
echo mex("Le date sono sbagliate",$pag).". <br>";
} # fine if ($idfineperiodo < $idinizioperiodo)
$prezzoperiodo1domlun = formatta_soldi($prezzoperiodo1domlun);
if (controlla_soldi($prezzoperiodo1domlun) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1lunmar = formatta_soldi($prezzoperiodo1lunmar);
if (controlla_soldi($prezzoperiodo1lunmar) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1marmer = formatta_soldi($prezzoperiodo1marmer);
if (controlla_soldi($prezzoperiodo1marmer) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1mergio = formatta_soldi($prezzoperiodo1mergio);
if (controlla_soldi($prezzoperiodo1mergio) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1gioven = formatta_soldi($prezzoperiodo1gioven);
if (controlla_soldi($prezzoperiodo1gioven) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1vensab = formatta_soldi($prezzoperiodo1vensab);
if (controlla_soldi($prezzoperiodo1vensab) == "NO") $soldi_sbagliati = "SI";
$prezzoperiodo1sabdom = formatta_soldi($prezzoperiodo1sabdom);
if (controlla_soldi($prezzoperiodo1sabdom) == "NO") $soldi_sbagliati = "SI";
if ($soldi_sbagliati == "SI") {
$inserire_prezzi = "NO";
echo mex("Il formato dei soldi è sbagliato",$pag).". <br>";
} # fine if ($soldi_sbagliati == "SI")

if ($inserire_prezzi != "NO") {
$tabelle_lock = array("$tableperiodi");
$tabelle_lock = lock_tabelle($tabelle_lock);
for ($num1 = $inizioperiodo ; $num1 < $fineperiodo ; $num1++) {
if ($prezzoperiodo1domlun) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1domlun' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1lunmar) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1lunmar' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1marmer) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1marmer' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1mergio) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1mergio' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1gioven) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1gioven' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1vensab) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1vensab' where idperiodi = '$num1' ");
$num1++;
if ($prezzoperiodo1sabdom) esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo1sabdom' where idperiodi = '$num1' ");
} # fine for $num1
unlock_tabelle($tabelle_lock);
$inizioperiodosett1_f = formatta_data($inizioperiodosett1,$stile_data);
$fineperiodosett1_f = formatta_data($fineperiodosett1,$stile_data);
echo mex("I prezzi per le settimane dal",$pag)." <b>$inizioperiodosett1_f</b> ".mex("al",$pag)." <b>$fineperiodosett1_f</b> ".mex("della <b>tariffa",$pag)."$num_tariffa</b> ".mex("sono stati inseriti",$pag).". <br>";
} # fine if ($inserire_prezzi != "NO")

echo "
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"tariffa_selected$num_tariffa\" value=\" selected\">
<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"OK\"><br>
</form>";
} # fine if ($inserisci_settimanalmente)

else {


# Inserisco i prezzi (della form da-a)

if ($inserisci or $modifica) {
$tabelle_lock = array("$tablenometariffe","$tableperiodi","$tablepersonalizza");
$tabelle_lock = lock_tabelle($tabelle_lock);
$inserire = "SI";
$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);

# Controllo se i campi inseriti sono già presenti
$tipotariffa_vedi = mex("tariffa",$pag).substr($tipotariffa,7);
if (substr($tipotariffa,0,7) != "tariffa" or controlla_num_pos(substr($tipotariffa,7)) != "SI") $tipotariffa = "tariffa1";
if ($nometariffa) {
$nometariffa = stripslashes($nometariffa);
$vecchionometariffa = esegui_query("select * from $tablenometariffe where idntariffe = 1 and $tipotariffa != ''");
$esistenometariffa = numlin_query($vecchionometariffa) ;
if ($esistenometariffa > 0) {
if ($inserisci) {
echo mex("Il soprannome della",$pag)." $tipotariffa_vedi ".mex("già esiste, usa il tasto \"modifica i prezzi già inseriti\" per cambiarlo o non metterlo per inserire prezzi per nuovi periodi",$pag).".<br>";
$inserire = "NO";
} # fine if ($inserisci)
} # fine if ($esistenometariffa > 0)
for ($num1 = 1 ; $num1 <= $numero_tariffe ; $num1 = $num1 + 1) {
$tariffa_controlla = "tariffa".$num1;
if ($tariffa_controlla != $tipotariffa) {
$nome_tariffa_controlla = risul_query($rigatariffe,0,$tariffa_controlla);
if ($nome_tariffa_controlla == $nometariffa) {
echo mex("Il soprannome",$pag)." $nometariffa ".mex("già esiste, ne devi usare un'altro",$pag).".<br>";
$inserire = "NO";
} # fine if ($nome_tariffa_controlla == $nometariffa)
} # fine if ($tariffa_controlla != $tipotariffa)
} # fine for $num1
} # fine if ($nometariffa)
$ultime_sel_ins_prezzi = $anno;
for ($numperiodo = 1 ; $numperiodo <= $numcaselle ; $numperiodo = $numperiodo + 1) {
$prezzoperiodo = "prezzoperiodo" . $numperiodo;
$ultime_sel_ins_prezzi .= ",".${"inizioperiodo".$numperiodo}.",".${"fineperiodo".$numperiodo};
if ($$prezzoperiodo) {
$$prezzoperiodo = formatta_soldi($$prezzoperiodo);
$inizioperiodo = "inizioperiodo" . $numperiodo;
$inizioperiodo = addslashes($$inizioperiodo);
$fineperiodo = "fineperiodo" . $numperiodo;
$fineperiodo = addslashes($$fineperiodo);
$idinizioperiodo = esegui_query("select idperiodi from $tableperiodi where datainizio = '$inizioperiodo' ");
$num_idinizioperiodo = numlin_query($idinizioperiodo);
if ($num_idinizioperiodo != 0) {
$idinizioperiodo = risul_query($idinizioperiodo,0,idperiodi);
} # fine if ($num_idinizioperiodo != 0)
else { $idinizioperiodo = 9999999; }
$idfineperiodo = esegui_query("select idperiodi from $tableperiodi where datafine = '$fineperiodo' ");
$num_idfineperiodo = numlin_query($idfineperiodo);
if ($num_idfineperiodo != 0) {
$idfineperiodo = risul_query($idfineperiodo,0,idperiodi);
} # fine if ($num_idfineperiodo != 0)
else { $idfineperiodo = -9999999; }
$IDinizioperiodo[$numperiodo] = $idinizioperiodo;
$IDfineperiodo[$numperiodo] = $idfineperiodo;
if ($idfineperiodo < $idinizioperiodo) {
$inserire = "NO";
echo mex("Le date del periodo numero",$pag)." $numperiodo ".mex("sono sbagliate",$pag).". <br>";
} # fine if ($idfineperiodo < $idinizioperiodo)
else {
for ( ; $idfineperiodo >= $idinizioperiodo ; $idinizioperiodo = $idinizioperiodo + 1) {
if ($inserirepp[$idinizioperiodo] == "SI") {
echo mex("Il periodo",$pag)." $numperiodo ".mex("si sovrappone ad un periodo precedente",$pag).". <br>";
$inserire = "NO";
} # fine if (inserirepp[$idinizioperiodo] == "SI")
else {
$inserirepp[$idinizioperiodo] = "SI";
$vecchioprezzoperiodo = esegui_query("select $tipotariffa from $tableperiodi where idperiodi = '$idinizioperiodo' and $tipotariffa != ''");
$esisteprezzoperiodo = numlin_query($vecchioprezzoperiodo);
if ($esisteprezzoperiodo > 0 and $inserisci) {
echo mex("Un prezzo nel periodo numero",$pag)." $numperiodo ".mex("esiste già, usa il tasto \"modifica i prezzi già inseriti\" per cambiarlo",$pag).". <br>";
$inserire = "NO";
} # fine if ($esisteprezzoperiodo > 0 and $inserisci)
} # fine else if (inserirepp[$idinizioperiodo] == "SI")
} # fine for $idinizioperiodo
if (controlla_soldi($$prezzoperiodo) == "NO") {
echo mex("Il prezzo del periodo numero",$pag)." $numperiodo ".mex("è sbagliato",$pag).". <br>";
$inserire = "NO";
} # fine if (controlla_soldi($$prezzoperiodo) == "NO")
} # fine else if ($idfineperiodo < $idinizioperiodo)
} # fine if ($prezzoperiodo)
} # fine for $numperiodo

# Inserisco i nuovi dati
if ($inserire == "SI") {
esegui_query("update $tablepersonalizza set valpersonalizza = '$ultime_sel_ins_prezzi' where idpersonalizza = 'ultime_sel_ins_prezzi' and idutente = '$id_utente' ");
if ($nometariffa) {
$nometariffa = addslashes($nometariffa);
esegui_query("update $tablenometariffe set $tipotariffa = '$nometariffa' where idntariffe = 1 ");
echo mex("Il soprannome della",$pag)." $tipotariffa_vedi ".mex("è stato cambiato",$pag).".<br>";
} # fine if ($nometariffa)
for ( $numperiodo = 1; $numperiodo <= $numcaselle; $numperiodo = $numperiodo + 1) {
$prezzoperiodo = "prezzoperiodo" . $numperiodo;
$prezzoperiodo = $$prezzoperiodo;
if ($prezzoperiodo) {
$idinizioperiodo = $IDinizioperiodo[$numperiodo];
$idfineperiodo = $IDfineperiodo[$numperiodo];
for ( ; $idfineperiodo >= $idinizioperiodo; $idinizioperiodo = $idinizioperiodo + 1) {
esegui_query("update $tableperiodi set $tipotariffa = '$prezzoperiodo' where idperiodi = '$idinizioperiodo' ");
} # fine for $idinizioperiodo
echo mex("Il prezzo del periodo",$pag)." $numperiodo ".mex("è stato inserito",$pag)."!<br>";
} # fine if ($$prezzoperiodo)
} # fine for $numperiodo
} # fine if ($inserire == "SI")
else {
echo mex("Nessun dato è stato inserito",$pag).".<br>";
} # fine else if ($inserire == "SI")
unlock_tabelle($tabelle_lock);
echo "
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php?anno=$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"OK\"><br>
</form>";
} # fine if ($inserisci or $modifica)



else {




if ($mostra_form_iniziale != "NO") {


echo "<center><font size=+2>".mex("Inserisci i prezzi per l'anno",$pag)." $anno</font>";

# Questa è la form con da-a

echo "<br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php?anno=$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<hr width=\"95%\">";
if ($tipo_periodi == "g") echo mex("Inserzione per giorni",$pag)."<br><br>";

echo mex("Prezzi della",$pag)." 
<select name=\"tipotariffa\">";
$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
$nometariffa = risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa ($nometariffa)";
if ($tariffa == "tariffa1") $selected = " selected";
else $selected = "";
echo "<option value=\"$tariffa\"$selected>$nometariffa_vedi</option>";
} # fine for $numtariffa
echo "</select> ".mex("soprannominata",$pag)."
<input type=\"text\" name=\"nometariffa\">
<br> ";

$ultime_sel_ins_prezzi = esegui_query("select valpersonalizza from $tablepersonalizza where idpersonalizza = 'ultime_sel_ins_prezzi' and idutente = '$id_utente'");
$ultime_sel_ins_prezzi = explode(",",risul_query($ultime_sel_ins_prezzi,0,valpersonalizza));
$date_selected = "";
for ($numperiodo = 1 ; $numperiodo <= $numcaselle ; $numperiodo = $numperiodo + 1) {
$inizioperiodo = "inizioperiodo" . $numperiodo;
$fineperiodo = "fineperiodo" . $numperiodo;
$prezzoperiodo = "prezzoperiodo" . $numperiodo;
echo " $numperiodo. ".mex("Dal",$pag)." ";
if ($ultime_sel_ins_prezzi[0] == $anno) $date_selected = $ultime_sel_ins_prezzi[(($numperiodo * 2) - 1)];
mostra_menu_date("./dati/selectperiodi$anno.$id_utente.php","$inizioperiodo",$date_selected,"","",$id_utente,$tema);
echo " ".mex("al",$pag)." ";
if ($ultime_sel_ins_prezzi[0] == $anno) $date_selected = $ultime_sel_ins_prezzi[($numperiodo * 2)];
mostra_menu_date("./dati/selectperiodi$anno.$id_utente.php","$fineperiodo",$date_selected,"","",$id_utente,$tema);
echo " :  <input type=\"text\" name=\"$prezzoperiodo\" size=\"15\">$Euro<br>";
} # fine for $numperiodo

echo "<table><tr><td height=\"2\"></td></tr></table>
<input class=\"sbutton\" type=\"submit\" name=\"inserisci\" value=\"".mex("inserisci i nuovi prezzi",$pag)."\">
<input class=\"sbutton\" type=\"submit\" name=\"modifica\" value=\"".mex("modifica i prezzi già inseriti",$pag)."\">
<hr width=\"95%\">
</form>";


if ($tipo_periodi == "g") {
echo mex("Inserzione per settimane",$pag)."<br><br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">";

for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
$nometariffa=risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa ($nometariffa)";
$tariffa_selected = tariffa_selected . $numtariffa;
$tariffa_selected = $$tariffa_selected;
$select_nomi_tariffe .= "
<option value=\"$tariffa\"$tariffa_selected>$nometariffa_vedi</option>";
if ($d_nome_tariffa == $tariffa) $d_nome_tariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine for $numtariffa
echo mex("Prezzi della",$pag)." 
<select name=\"tipotariffa\">
$select_nomi_tariffe
</select><br><br> ";

$file_date = file("dati/selectperiodi$anno.$id_utente.php");
$num_linee_file_date = count($file_date);
for ($num1 = 0 ; $num1 < $num_linee_file_date ; $num1++) {
if (substr($file_date[$num1],0,7) == "<option") {
$mese_data = substr($file_date[$num1],21,2);
$giorno_data = substr($file_date[$num1],24,2);
$anno_data = substr($file_date[$num1],16,4);
#if ($mese_data == "Jan") $mese_data = 1;
#if ($mese_data == "Feb") $mese_data = 2;
#if ($mese_data == "Mar") $mese_data = 3;
#if ($mese_data == "Apr") $mese_data = 4;
#if ($mese_data == "May") $mese_data = 5;
#if ($mese_data == "Jun") $mese_data = 6;
#if ($mese_data == "Jul") $mese_data = 7;
#if ($mese_data == "Aug") $mese_data = 8;
#if ($mese_data == "Sep") $mese_data = 9;
#if ($mese_data == "Oct") $mese_data = 10;
#if ($mese_data == "Nov") $mese_data = 11;
#if ($mese_data == "Dec") $mese_data = 12;
if (date("w", mktime(0,0,0,$mese_data,$giorno_data,$anno_data)) == 0) {
$file_date[$num1]= str_replace("\\","",$file_date[$num1]);
$option_domeniche .= $file_date[$num1];
} # fine if (date("w", mktime(0,0,0,$mese_data,$giorno_data,$anno_data)) == 0)
} # fine if (substr($file_date[$num1],0,7) == "<option")
} # fine for $num1

echo mex("Settimane dal",$pag)."
 <select name=\"inizioperiodosett1\">$option_domeniche</select>
".mex("al",$pag)." <select name=\"fineperiodosett1\">$option_domeniche</select>
: ".mex("Dom/Lun",$pag).": <input type=\"text\" name=\"prezzoperiodo1domlun\" size=\"15\">$Euro;<br>
".mex("Lun/Mar",$pag).": <input type=\"text\" name=\"prezzoperiodo1lunmar\" size=\"15\">$Euro;
".mex("Mar/Mer",$pag).": <input type=\"text\" name=\"prezzoperiodo1marmer\" size=\"15\">$Euro;
".mex("Mer/Gio",$pag).": <input type=\"text\" name=\"prezzoperiodo1mergio\" size=\"15\">$Euro;<br>
".mex("Gio/Ven",$pag).": <input type=\"text\" name=\"prezzoperiodo1gioven\" size=\"15\">$Euro;
".mex("Ven/Sab",$pag).": <input type=\"text\" name=\"prezzoperiodo1vensab\" size=\"15\">$Euro;
".mex("Sab/Dom",$pag).": <input type=\"text\" name=\"prezzoperiodo1sabdom\" size=\"15\">$Euro;<br>";

echo "<table><tr><td height=\"2\"></td></tr></table>
<input class=\"sbutton\" type=\"submit\" name=\"inserisci_settimanalmente\" value=\"".mex("inserisci o modifica i prezzi",$pag)."\">
</form>
<hr width=\"95%\">";
} # fine if ($tipo_periodi == "g")


echo "<table><tr><td heigth=6></td></tr></table>
</center><form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
".mex("Importa i prezzi della",$pag)." ";
$select_nomi_tariffe = "";
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
$nometariffa = risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa ($nometariffa)";
$select_nomi_tariffe .= "<option value=\"$tariffa\">$nometariffa_vedi</option>";
} # fine for $numtariffa
echo "<select name=\"tariffa_a\">
$select_nomi_tariffe
</select> ".mex("dalla",$pag)." <select name=\"tariffa_da\">
$select_nomi_tariffe
</select> ".mex("aggiungendo il",$pag)."
 <input type=\"text\" name=\"importa_percent\" size=\"3\" maxlength=\"3\" value=\"0\">% 
".mex("arrotondato a",$pag)."
<input type=\"text\" name=\"importa_arrotond\" value=\"1\" size=\"5\">
<input class=\"sbutton\" type=\"submit\" name=\"importa_tariffa\" value=\"".mex("importa",$pag)."\">
</form><table><tr><td heigth=6></td></tr></table>
<hr width=\"95%\">";


# form per i costi aggiuntivi e per la caparra.
if (defined("C_MASSIMO_NUM_COSTI_AGG") and C_MASSIMO_NUM_COSTI_AGG != 0) {
$num_costi_agg_esistenti = esegui_query("select idntariffe from $tablenometariffe where idntariffe > 4");
$num_costi_agg_esistenti = numlin_query($num_costi_agg_esistenti);
if ($num_costi_agg_esistenti >= C_MASSIMO_NUM_COSTI_AGG) $aggiungi_costi_aggiuntivi = "NO";
} # fine if (defined("C_MASSIMO_NUM_COSTI_AGG") and C_MASSIMO_NUM_COSTI_AGG != 0)
if ($aggiungi_costi_aggiuntivi != "NO") {
echo "
<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"passo\" value=\"1\">
<input type=\"hidden\" name=\"avanti\" value=\"SI\">
<center>".mex("Costi aggiuntivi",$pag)."<br><br></center>
".mex("Nome del nuovo costo aggiuntivo",$pag).":
<input type=\"text\" name=\"nomecostoagg\" size=\"24\" value=\"$nomecostoagg\">.<br>
".mex("Tipo di costo aggiuntivo",$pag).":
<select name=\"tipo_ca\">";
if ($tipo_ca == "u") $selected = " selected";
else $selected = "";
echo "<option value=\"u\"$selected>".mex("unico",$pag)."</option>";
if ($tipo_ca == "s") $selected = " selected";
else $selected = "";
echo "<option value=\"s\"$selected>".mex("$parola_settimanale",$pag)."</option>
</select>.<br>
<br><center>
<input class=\"sbutton\" type=\"submit\" name=\"inseriscicosti\" value=\"".mex("Procedi nell'inserimento del nuovo costo aggiuntivo",$pag)."\">
<hr width=\"95%\">
</form>";
} # fine if ($aggiungi_costi_aggiuntivi != "NO")

echo "<form accept-charset=\"utf-8\" method=\"post\" action=\"creaprezzi.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
".mex("Caparra",$pag)."</center><br>"
.mex("La caparra normale per la",$pag)."
 <select name=\"tipotariffa\">";
$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
$tariffa = "tariffa".$numtariffa;
$nometariffa=risul_query($rigatariffe,0,$tariffa);
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
else $nometariffa_vedi = mex("tariffa",$pag)."$numtariffa ($nometariffa)";
if ($tariffa == "tariffa1") $selected = " selected";
else $selected = "";
echo "<option value=\"$tariffa\"$selected>$nometariffa_vedi</option>";
} # fine for $numtariffa
echo "</select> ".mex("è del",$pag)." 
<input type=\"text\" name=\"caparra_percent\" size=\"2\" maxlength=\"2\">% 
".mex("arrotondata a",$pag)."
<input type=\"text\" name=\"caparra_arrotond\" value=\"10\" size=\"5\">.<br>
<table><tr><td height=\"2\"></td></tr></table><center>
<input class=\"sbutton\" type=\"submit\" name=\"modificacaparra\" value=\"".mex("Inserisci o modifica la caparra",$pag)."\">
<hr width=\"95%\">
</form>

<br><form accept-charset=\"utf-8\" method=\"post\" action=\"visualizza_tabelle.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"tipo_tabella\" value=\"periodi\">
<input class=\"sbutton\" type=\"submit\" name=\"visualizza\" value=\"".mex("Vedi i prezzi già inseriti",$pag)."\">
</form>

<form accept-charset=\"utf-8\" method=\"post\" action=\"inizio.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"indietro\" value=\"".mex("Torna al menù principale",$pag)."\">
</form></center>";



} # fine if ($mostra_form_iniziale != "NO")

} # fine else if ($inserisci or $modifica)

} # fine else if ($inserisci_settimanalmente)

} # fine else if ($modificacaparra)



if ($tema[$id_utente] and $tema[$id_utente] != "base" and @is_dir("./includes/themes/".$tema[$id_utente])) include("./includes/themes/".$tema[$id_utente]."/foot.php");
else include("./includes/foot.php");


} # fine if ($id_utente and $id_utente == 1)




?>