<?php

##################################################################################
#    PHP-RESIDENCE
#    Copyright (C) 2001-2006 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################




function crea_nuovo_anno ($anno,$PHPR_TAB_PRE,$DATETIME,$tipo_periodi,$giorno_ini_fine,$mese_ini,$mese_fine,$importa_anno_prec,$silenzio,$pag) {


$tableanni = $PHPR_TAB_PRE."anni";
$tableprivilegi = $PHPR_TAB_PRE."privilegi";
$tabletransazioni = $PHPR_TAB_PRE."transazioni";
$tabletransazioniweb = $PHPR_TAB_PRE."transazioniweb";
$tablepersonalizza =$PHPR_TAB_PRE."personalizza";
$tablemessaggi =$PHPR_TAB_PRE."messaggi";

$filelock = fopen("./dati/anni.lock","w+");
flock($filelock,2);
$anno_esistente = esegui_query("select * from $tableanni where idanni = $anno");
if (numlin_query($anno_esistente) == 0) {

if (C_CAMBIA_TIPO_PERIODI == "NO") {
$tipo_periodi_esistenti = esegui_query("select * from $tableanni order by idanni desc");
if (numlin_query($tipo_periodi_esistenti) != 0) $tipo_periodi = risul_query($tipo_periodi_esistenti,0,tipo_periodi);
} # fine if (C_CAMBIA_TIPO_PERIODI == "NO")
if ($tipo_periodi != "g") $tipo_periodi = "s";

// creo la tabella con periodi settimanali e prezzi e la tabella con i nomi delle tariffe
$tableperiodi = $PHPR_TAB_PRE."periodi".$anno;
$tablenometariffe = $PHPR_TAB_PRE."ntariffe".$anno;
if ($importa_anno_prec == "SI") {
$anno_prec = $anno - 1;
$tablenometariffe_prec = $PHPR_TAB_PRE."ntariffe".$anno_prec;
$num_tariffe_tab = esegui_query("select nomecostoagg from $tablenometariffe_prec where idntariffe = 1");
$num_tariffe_tab = risul_query($num_tariffe_tab,0,nomecostoagg);
} # fine if ($importa_anno_prec == "SI")
else $num_tariffe_tab = 8;
$query = "create table $tableperiodi (idperiodi integer primary key, datainizio date not null, datafine date";
$query2 = "create table $tablenometariffe (idntariffe integer, nomecostoagg varchar(40), tipo_ca varchar(2), valore_ca float8, arrotonda_ca float4, associasett_ca varchar(1), numsett_ca varchar(20), moltiplica_ca varchar(1), periodipermessi_ca text, variazione_ca varchar(10), mostra_ca varchar(1), letto_ca varchar(1), numlimite_ca integer";
for ($num1 = 1 ; $num1 <= $num_tariffe_tab ; $num1++) {
$nome_nuova_tariffa = "tariffa" . $num1;
$query .= ", $nome_nuova_tariffa float8";
$query2 .= ", $nome_nuova_tariffa varchar(40)";
} # fine for $num1
esegui_query($query.")");
esegui_query($query2.")");

# Creo la tabella delle prernotazioni
$tableprenotazioni = $PHPR_TAB_PRE."prenota".$anno;
esegui_query("create table $tableprenotazioni (idprenota integer primary key, idclienti integer, idappartamenti varchar(100), iddatainizio integer, iddatafine integer, assegnazioneapp varchar(4), app_assegnabili text, num_persone integer, idprenota_compagna text, tariffa text, tariffesettimanali text, costiassociati varchar(1), sconto float8, tariffa_tot float8, caparra float8, pagato float8, metodo_pagamento text, codice varchar(10), commento text, conferma varchar(4), checkin $DATETIME, checkout $DATETIME, datainserimento $DATETIME, hostinserimento varchar(50), data_modifica $DATETIME, utente_inserimento integer )");

# Creo la tabella con i costi aggiuntivi delle prenotazioni
$tablecostiprenota = $PHPR_TAB_PRE."costiprenota".$anno;
esegui_query("create table $tablecostiprenota (idcostiprenota integer primary key, idprenota integer, tipo varchar(2), nome varchar(40), valore float8, arrotonda float4, associasett varchar(1), settimane text, moltiplica text, letto varchar(1), numlimite integer, idntariffe integer, variazione varchar(10), varmoltiplica varchar(1), varnumsett varchar(20), varperiodipermessi text, vartariffeassociate varchar(10), vartariffeincomp text, datainserimento $DATETIME, hostinserimento varchar(50), utente_inserimento integer)");
crea_indice($tablecostiprenota,"idprenota","iidpcostiprenota".$anno);
esegui_query("insert into $tablecostiprenota (idcostiprenota,numlimite) values ('1','1')");

# Creo la tabella per le regole di assegnazione
$tableregole = $PHPR_TAB_PRE."regole".$anno;
esegui_query("create table $tableregole (idregole integer, app_agenzia varchar(100), tariffa_per_app text, tariffa_per_utente text, iddatainizio integer, iddatafine integer, motivazione text)");

# Creo la tabella con i costi di gestione
$tablecosti = $PHPR_TAB_PRE."costi".$anno;
esegui_query("create table $tablecosti (idcosti integer unique,nome_costo text, val_costo float8, persona_costo text, provenienza_costo text, tipo_costo text, datainserimento $DATETIME, hostinserimento varchar(50), utente_inserimento integer)");

# Creo la tabella per la storia entrate-uscite
$tablesoldi = $PHPR_TAB_PRE."soldi".$anno;
esegui_query("create table $tablesoldi (idsoldi integer unique, motivazione text, metodo_pagamento text, saldo_prenota float8, saldo_cassa float8, soldi_prima float8, data_inserimento $DATETIME, utente_inserimento integer)");

$tabelle_lock = array("$tableanni","$tableprenotazioni","$tablecostiprenota","$tablenometariffe","$tableperiodi","$tablecosti","$tableregole","$tablesoldi","$tablepersonalizza","$tableprivilegi","$tabletransazioni");
if ($importa_anno_prec == "SI") {
$anno_prec = $anno - 1;
$tablenometariffe_prec = $PHPR_TAB_PRE."ntariffe".$anno_prec;
$tableprenota_prec = $PHPR_TAB_PRE."prenota".$anno_prec;
$tablecostiprenota_prec = $PHPR_TAB_PRE."costiprenota".$anno_prec;
$tableperiodi_prec = $PHPR_TAB_PRE."periodi".$anno_prec;
$tableregole_prec = $PHPR_TAB_PRE."regole".$anno_prec;
$tabelle_lock = array("$tableanni","$tableprenota_prec","$tableprenotazioni","$tablecostiprenota_prec","$tablecostiprenota","$tablenometariffe","$tableperiodi","$tablecosti","$tableregole","$tablesoldi","$tablepersonalizza","$tableprivilegi","$tabletransazioni");
$altre_tab_lock = array("$tablenometariffe_prec","$tableperiodi_prec","$tableregole_prec");
$max_data_ini_prec = esegui_query("select max(datainizio) from $tableperiodi_prec");
if (numlin_query($max_data_ini_prec) != 0) {
$max_data_ini_prec = risul_query($max_data_ini_prec,0,0);
$max_mese_prec = 0;
if (substr($max_data_ini_prec,0,4) >= $anno) $max_mese_prec = substr($max_data_ini_prec,5,2);
if (substr($max_data_ini_prec,0,4) == ($anno + 1)) $max_mese_prec = $max_mese_prec + 12;
if ($max_mese_prec > $mese_fine) $mese_fine = $max_mese_prec;
} # fine if (numlin_query($max_data_ini_prec) != 0)
else $max_periodo_prec = "";
} # fine if ($importa_anno_prec == "SI")
else unset($altre_tab_lock);
$tabelle_lock = lock_tabelle($tabelle_lock,$altre_tab_lock);

# Elimino tutte le transazioni, potrebbero contenere date dell'anno creato
esegui_query("delete from $tabletransazioni");

# Inserisco l'anno nella tabella anni
esegui_query("insert into $tableanni (idanni,tipo_periodi) values ('$anno','$tipo_periodi')");

esegui_query("insert into $tablecosti (idcosti) values (0)");
esegui_query("insert into $tablesoldi (idsoldi,motivazione,soldi_prima) values ('1','soldi_prenotazioni_cancellate','0')");

// trovo il primo giorno di inizio/fine dell'anno (nel caso di periodi settimanali)
$numgiorno = 1;
$giorno_ini_fine = (string) $giorno_ini_fine;
if ($giorno_ini_fine != "0" and $giorno_ini_fine != "1" and $giorno_ini_fine != "2" and $giorno_ini_fine != "3" and $giorno_ini_fine != "4" and $giorno_ini_fine != "5" and $giorno_ini_fine != "6") $giorno_ini_fine = 6;
do {
$nomegiorno = date("w",mktime(0,0,0,1,$numgiorno,$anno));
$numgiorno = $numgiorno + 1;
} while ($nomegiorno != $giorno_ini_fine);
$numgiorno  = $numgiorno - 1;

if ($tipo_periodi == "g") {
$numgiorno = 1;
$aggiungi_giorni = 1;
} # fine if ($tipo_periodi == "g")
else $aggiungi_giorni = 7;

if ($mese_ini > $mese_fine) {
if ($silenzio != "SI") echo mex("I mesi erano indicati erroneamente, sono stati inseriti i mesi da Gennaio a Dicembre",$pag).".<br>";
$mese_ini = 1;
if ($mese_fine < 12) $mese_fine = 12;
} # fine if ($mese_ini > $mese_fine)

$anno_fine = $anno + 1;

$idperiodi = 1;
$fileaperto = fopen("dati/selectperiodi$anno.1.php","a+");
flock($fileaperto,2);
$date_option = "";
$n_date_menu = 0;

do {
$datainizio = date("Y-m-d" , mktime(0,0,0,1,$numgiorno,$anno));
$annocreato = date("Y" , mktime(0,0,0,1,$numgiorno,$anno));
$mesecreato = date("n" , mktime(0,0,0,1,$numgiorno,$anno));
$nome_giorno = date("D" , mktime(0,0,0,1,$numgiorno,$anno));
$nome_mese = date("M" , mktime(0,0,0,1,$numgiorno,$anno));
$numero_giorno = date("d" , mktime(0,0,0,1,$numgiorno,$anno));
$numero_anno = $annocreato;
$numgiorno = $numgiorno + $aggiungi_giorni;
$datafine = date("Y-m-d" , mktime(0,0,0,1,$numgiorno,$anno));
$annocreato2 = date("Y" , mktime(0,0,0,1,$numgiorno,$anno));
$mesecreato2 = date("n" , mktime(0,0,0,1,$numgiorno,$anno));
if ($annocreato > $anno) {
$diff = $annocreato - $anno;
$mesecreato = ($diff * 12) + $mesecreato;
} # fine if ($annocreato > $anno)
if ($annocreato2 > $anno) {
$diff = $annocreato2 - $anno;
$mesecreato2 = ($diff * 12) + $mesecreato2;
} # fine if ($annocreato2 > $anno)
if ($mesecreato >= $mese_ini and $mesecreato <= $mese_fine) {
esegui_query("insert into $tableperiodi ( idperiodi, datainizio, datafine) values ( $idperiodi, '$datainizio', '$datafine')");
if ($tipo_periodi == "g") {
if ($nome_giorno == "Sun") $nome_giorno = mex(" Do",$pag);
if ($nome_giorno == "Mon") $nome_giorno = mex(" Lu",$pag);
if ($nome_giorno == "Tue") $nome_giorno = mex(" Ma",$pag);
if ($nome_giorno == "Wed") $nome_giorno = mex(" Me",$pag);
if ($nome_giorno == "Thu") $nome_giorno = mex(" Gi",$pag);
if ($nome_giorno == "Fri") $nome_giorno = mex(" Ve",$pag);
if ($nome_giorno == "Sat") $nome_giorno = mex(" Sa",$pag);
} # fine if ($tipo_periodi == "g")
else $nome_giorno = "";
if ($nome_mese == "Jan") $nome_mese = mex("Gen",$pag);
if ($nome_mese == "Feb") $nome_mese = mex("Feb",$pag);
if ($nome_mese == "Mar") $nome_mese = mex("Mar",$pag);
if ($nome_mese == "Apr") $nome_mese = mex("Apr",$pag);
if ($nome_mese == "May") $nome_mese = mex("Mag",$pag);
if ($nome_mese == "Jun") $nome_mese = mex("Giu",$pag);
if ($nome_mese == "Jul") $nome_mese = mex("Lug",$pag);
if ($nome_mese == "Aug") $nome_mese = mex("Ago",$pag);
if ($nome_mese == "Sep") $nome_mese = mex("Set",$pag);
if ($nome_mese == "Oct") $nome_mese = mex("Ott",$pag);
if ($nome_mese == "Nov") $nome_mese = mex("Nov",$pag);
if ($nome_mese == "Dec") $nome_mese = mex("Dic",$pag);
if (!$date_option) {
$a_ini_menu = substr($datainizio,0,4);
$m_ini_menu = (substr($datainizio,5,2) - 1);
$g_ini_menu = substr($datainizio,8,2);
} # fine if (!$date_option)
$n_date_menu++;
$date_option .= "<option value=\\\"$datainizio\\\">$nome_mese $numero_giorno$nome_giorno, $numero_anno</option>
";
$idperiodi = $idperiodi + 1;
$datafine2 = $datafine;
} # fine if ($mesecreato >= $mese_ini and $mesecreato <= $mese_fine)
} while ($annocreato2 <= $anno_fine or $mesecreato2 == 25);

$numero_mese = substr($datafine2,5,2);
if ($numero_mese == "01") $nome_mese = mex("Gen",$pag);
if ($numero_mese == "02") $nome_mese = mex("Feb",$pag);
if ($numero_mese == "03") $nome_mese = mex("Mar",$pag);
if ($numero_mese == "04") $nome_mese = mex("Apr",$pag);
if ($numero_mese == "05") $nome_mese = mex("Mag",$pag);
if ($numero_mese == "06") $nome_mese = mex("Giu",$pag);
if ($numero_mese == "07") $nome_mese = mex("Lug",$pag);
if ($numero_mese == "08") $nome_mese = mex("Ago",$pag);
if ($numero_mese == "09") $nome_mese = mex("Set",$pag);
if ($numero_mese == "10") $nome_mese = mex("Ott",$pag);
if ($numero_mese == "11") $nome_mese = mex("Nov",$pag);
if ($numero_mese == "12") $nome_mese = mex("Dic",$pag);
$numero_giorno = substr($datafine2,8,2);
$numero_anno = substr($datafine2,0,4);
$n_date_menu++;
$date_option .= "<option value=\\\"$datafine2\\\">$nome_mese $numero_giorno, $numero_anno</option>
";
fwrite($fileaperto,"<?php 

\$y_ini_menu[0] = \"$a_ini_menu\";
\$m_ini_menu[0] = \"$m_ini_menu\";
\$d_ini_menu[0] = \"$g_ini_menu\";
\$n_dates_menu[0] = \"$n_date_menu\";
\$d_increment[0] = \"$aggiungi_giorni\";
\$d_names = \"\\\"".mex(" Do",$pag)."\\\",\\\"".mex(" Lu",$pag)."\\\",\\\"".mex(" Ma",$pag)."\\\",\\\"".mex(" Me",$pag)."\\\",\\\"".mex(" Gi",$pag)."\\\",\\\"".mex(" Ve",$pag)."\\\",\\\"".mex(" Sa",$pag)."\\\"\";
\$m_names = \"\\\"".mex("Gen",$pag)."\\\",\\\"".mex("Feb",$pag)."\\\",\\\"".mex("Mar",$pag)."\\\",\\\"".mex("Apr",$pag)."\\\",\\\"".mex("Mag",$pag)."\\\",\\\"".mex("Giu",$pag)."\\\",\\\"".mex("Lug",$pag)."\\\",\\\"".mex("Ago",$pag)."\\\",\\\"".mex("Set",$pag)."\\\",\\\"".mex("Ott",$pag)."\\\",\\\"".mex("Nov",$pag)."\\\",\\\"".mex("Dic",$pag)."\\\"\";

\$dates_options_list = \"

$date_option
\";

?>");
flock($fileaperto,3);
fclose($fileaperto);
copy ("dati/selectperiodi$anno.1.php","dati/selperiodimenu$anno.1.php");

# Importo eventuali prenotazioni, tariffe e regole dell'anno precedente
if ($importa_anno_prec == "SI") {
$tableprenota = $tableprenotazioni;
$data_inizio_periodi = esegui_query("select * from $tableperiodi where idperiodi = 1");
$data_inizio_periodi = risul_query($data_inizio_periodi,0,datainizio);
$ini_periodo_interferenza =  esegui_query("select * from $tableperiodi_prec where datainizio = '$data_inizio_periodi'");
$num_periodo_interferenza = numlin_query($ini_periodo_interferenza);
$tipo_periodi_prec = esegui_query("select * from $tableanni where idanni = $anno_prec");
$tipo_periodi_prec = risul_query($tipo_periodi_prec,0,tipo_periodi);
if ($tipo_periodi_prec != $tipo_periodi) $num_periodo_interferenza = 0;
if ($num_periodo_interferenza == 0) {
if ($silenzio != "SI") echo mex("Non ci sono periodi che riguardano il ",$pag).$anno.mex(" nel ",$pag).$anno_prec.mex(", o il giorno di inizio/fine locazione era differente, sono stati importati solo i dati riguardanti costi aggiuntivi, caparra, nome delle tariffe, privilegi degli utenti e regole di assegnazione 2 e 3",$pag).".<br>";
} # fine if ($num_periodo_interferenza == 0)
else {
$id_data_fine_periodi = esegui_query("select max(idperiodi) from $tableperiodi");
$id_data_fine_periodi = risul_query($id_data_fine_periodi,0,0);
$id_data_ini_periodi_prec = risul_query($ini_periodo_interferenza,0,idperiodi);
$id_data_fine_periodi_prec = esegui_query("select max(idperiodi) from $tableperiodi_prec");
$id_data_fine_periodi_prec = risul_query($id_data_fine_periodi_prec,0,0);
$num_periodi_prec = $id_data_fine_periodi_prec - $id_data_ini_periodi_prec + 1;
if ($num_periodi_prec > $id_data_fine_periodi) {
$id_data_fine_periodi_prec = $id_data_ini_periodi_prec + $id_data_fine_periodi - 1;
$prenota_non_importabili = esegui_query("select * from $tableprenota_prec where iddatafine > $id_data_fine_periodi_prec ");
$num_prenota_non_importabili = numlin_query($prenota_non_importabili);
if ($num_prenota_non_importabili != 0) echo "<br>ERROR<br>";
} # fine if ($num_periodi_prec > $id_data_fine_periodi)
$idprenota_corr = 0;
$max_idprenota_prec = esegui_query("select max(idprenota) from $tableprenota_prec");
$max_idprenota_prec = risul_query($max_idprenota_prec,0,0) + 1;
$max_idcostiprenota_prec = esegui_query("select max(idcostiprenota) from $tablecostiprenota_prec");
$max_idcostiprenota_prec = risul_query($max_idcostiprenota_prec,0,0) + 1;
$prenota_gia_iniziate = esegui_query("select * from $tableprenota_prec where iddatainizio < $id_data_ini_periodi_prec and iddatafine >= $id_data_ini_periodi_prec and iddatafine <= $id_data_fine_periodi_prec ");
$num_prenota_gia_iniziate = numlin_query($prenota_gia_iniziate);
for ($num1 = 0 ; $num1 < $num_prenota_gia_iniziate ; $num1 = $num1 + 1) {
$idprenota = risul_query($prenota_gia_iniziate,$num1,idprenota);
$idclienti = risul_query($prenota_gia_iniziate,$num1,idclienti);
$idappartamenti = risul_query($prenota_gia_iniziate,$num1,idappartamenti);
$iddatafine = risul_query($prenota_gia_iniziate,$num1,iddatafine);
$iddatafine = $iddatafine - $id_data_ini_periodi_prec + 1;
$datainserimento = risul_query($prenota_gia_iniziate,$num1,datainserimento);
$hostinserimento = risul_query($prenota_gia_iniziate,$num1,hostinserimento);
$data_modifica = risul_query($prenota_gia_iniziate,$num1,data_modifica);
$utente_inserimento = risul_query($prenota_gia_iniziate,$num1,utente_inserimento);
$checkin = risul_query($prenota_gia_iniziate,$num1,checkin);
$checkout = risul_query($prenota_gia_iniziate,$num1,checkout);
$idprenota_corr++;
esegui_query("insert into $tableprenota (idprenota,idclienti,idappartamenti,iddatainizio,iddatafine,assegnazioneapp,commento,checkin,checkout,datainserimento,hostinserimento,utente_inserimento) values ('$idprenota_corr','$idclienti','$idappartamenti','0',$iddatafine,'k','$idprenota','$checkin','$checkout','$datainserimento','$hostinserimento','$utente_inserimento') ");
esegui_query("update $tablecostiprenota_prec set idprenota = '$max_idprenota_prec' where idprenota = '$idprenota'");
esegui_query("insert into $tablecostiprenota select * from $tablecostiprenota_prec where idprenota = '$max_idprenota_prec' ");
esegui_query("update $tablecostiprenota set idprenota = '$idprenota_corr' where idprenota = '$max_idprenota_prec'");
esegui_query("update $tablecostiprenota_prec set idprenota = '$idprenota' where idprenota = '$max_idprenota_prec'");
} # fine for $num1
$prenota_importate = esegui_query("select * from $tableprenota_prec where iddatainizio >= '$id_data_ini_periodi_prec' and iddatafine <= '$id_data_fine_periodi_prec' order by idprenota ");
$num_prenota_importate = numlin_query($prenota_importate);
for ($num1 = 0 ; $num1 < $num_prenota_importate ; $num1 = $num1 + 1) {
$idprenota = risul_query($prenota_importate,$num1,idprenota);
$iddatainizio = risul_query($prenota_importate,$num1,iddatainizio);
$iddatainizio = $iddatainizio - $id_data_ini_periodi_prec + 1;
$iddatafine = risul_query($prenota_importate,$num1,iddatafine);
$iddatafine = $iddatafine - $id_data_ini_periodi_prec + 1;
$idprenota_corr++;
esegui_query("update $tableprenota_prec set idprenota = '$max_idprenota_prec' where idprenota = '$idprenota'");
esegui_query("insert into $tableprenota select * from $tableprenota_prec where idprenota = '$max_idprenota_prec' ");
esegui_query("update $tableprenota set iddatainizio = '$iddatainizio' where idprenota = '$max_idprenota_prec'");
esegui_query("update $tableprenota set iddatafine = '$iddatafine' where idprenota = '$max_idprenota_prec'");
esegui_query("update $tableprenota set idprenota = '$idprenota_corr' where idprenota = '$max_idprenota_prec'");
esegui_query("delete from $tableprenota_prec where idprenota = '$max_idprenota_prec'");
esegui_query("update $tablecostiprenota_prec set idprenota = '$max_idprenota_prec' where idprenota = '$idprenota'");
esegui_query("insert into $tablecostiprenota select * from $tablecostiprenota_prec where idprenota = '$max_idprenota_prec' ");
esegui_query("update $tablecostiprenota set idprenota = '$idprenota_corr' where idprenota = '$max_idprenota_prec'");
esegui_query("delete from $tablecostiprenota_prec where idprenota = '$max_idprenota_prec'");
} # fine for $num1
esegui_query("update $tablecostiprenota set numlimite = '".($idprenota_corr + 1)."' where idcostiprenota = '1'");
$id_costi_agg_importati = esegui_query("select idcostiprenota from $tablecostiprenota where idcostiprenota != '1' order by idcostiprenota");
$num_id_costi_agg_importati = numlin_query($id_costi_agg_importati);
for ($num1 = 0 ; $num1 < $num_costi_agg_importati ; $num1++) {
$idcostiprenota = risul_query($id_costi_agg_importati,$num1,idcostiprenota);
$max_idcostiprenota_prec++;
esegui_query("update $tablecostiprenota set idcostiprenota = '$max_idcostiprenota_prec' where idcostiprenota = '$idcostiprenota'");
} # fine for $num1
$costi_agg_importati = esegui_query("select * from $tablecostiprenota where idcostiprenota != '1' order by idcostiprenota");
$num_costi_agg_importati = numlin_query($costi_agg_importati);
for ($num1 = 0 ; $num1 < $num_costi_agg_importati ; $num1++) {
$idcostiprenota = risul_query($costi_agg_importati,$num1,idcostiprenota);
$settimane = risul_query($costi_agg_importati,$num1,settimane);
if (str_replace(",","",$settimane) != $settimane) {
$settimane = explode(",",$settimane);
$settimane_nuove = ",";
for ($num2 = 1 ; $num2 < (count($settimane) - 1) ; $num2++) $settimane_nuove .= ($settimane[$num2] - $id_data_ini_periodi_prec + 1).",";
esegui_query("update $tablecostiprenota set settimane = '$settimane_nuove' where idcostiprenota = '$idcostiprenota'");
} # fine if (str_replace(",","",$settimane) != $settimane)
$varperiodipermessi = risul_query($costi_agg_importati,$num1,varperiodipermessi);
if ($varperiodipermessi) {
$vpp_nuovi = substr($varperiodipermessi,0,1);
$varperiodipermessi = explode(",",substr($varperiodipermessi,1));
for ($num2 = 0 ; $num2 < count($varperiodipermessi) ; $num2++) {
$id_data_fine_vpp = explode("-",$varperiodipermessi[$num2]);
$id_data_inizio_vpp = $id_data_fine_vpp[0];
$id_data_fine_vpp = $id_data_fine_vpp[1];
if ($id_data_fine_vpp >= $id_data_ini_periodi_prec and $id_data_inizio_vpp <= $id_data_fine_periodi_prec) {
if ($id_data_inizio_vpp < $id_data_ini_periodi_prec) $id_data_inizio_vpp = $id_data_ini_periodi_prec;
if ($id_data_fine_vpp > $id_data_fine_periodi_prec) $id_data_fine_vpp = $id_data_fine_periodi_prec;
$id_data_inizio_vpp = $id_data_inizio_vpp - $id_data_ini_periodi_prec + 1;
$id_data_fine_vpp = $id_data_fine_vpp - $id_data_ini_periodi_prec + 1;
$vpp_nuovi .= $id_data_inizio_vpp."-".$id_data_fine_vpp.",";
} # fine if ($id_data_fine_vpp >= $id_data_ini_periodi_prec and...
} # fine for $num2
if (strlen($vpp_nuovi) > 1) $vpp_nuovi = substr($vpp_nuovi,0,-1);
esegui_query("update $tablecostiprenota set varperiodipermessi = '$vpp_nuovi' where idcostiprenota = '$idcostiprenota'");
} # fine if ($varperiodipermessi)
esegui_query("update $tablecostiprenota set idcostiprenota = '".($num1 + 2)."' where idcostiprenota = '$idcostiprenota'");
} # fine for $num1
$tariffe_importate = esegui_query("select * from $tableperiodi_prec where idperiodi >= '$id_data_ini_periodi_prec' and idperiodi <= '$id_data_fine_periodi_prec' ");
$num_tariffe_iportate = numlin_query($tariffe_importate);
for ($num1 = 0 ; $num1 < $num_tariffe_iportate ; $num1 = $num1 + 1) {
$idperiodi = risul_query($tariffe_importate,$num1,idperiodi);
$idperiodi = $idperiodi - $id_data_ini_periodi_prec + 1;
for ($num2 = 1 ; $num2 <= $num_tariffe_tab ; $num2++) {
$tariffa = (string) risul_query($tariffe_importate,$num1,"tariffa".$num2);
if ($tariffa != "") esegui_query("update $tableperiodi set tariffa$num2 = '$tariffa' where idperiodi = $idperiodi ");
} # fine for $num2
} # fine for $num1
$regole_prec = esegui_query("select * from $tableregole_prec where iddatafine >= '$id_data_ini_periodi_prec' ");
$num_regole_prec = numlin_query($regole_prec);
for ($num1 = 0 ; $num1 < $num_regole_prec ; $num1 = $num1 + 1) {
$idregole = risul_query($regole_prec,$num1,idregole);
$app_agenzia = risul_query($regole_prec,$num1,app_agenzia);
$iddatainizio = risul_query($regole_prec,$num1,iddatainizio);
if ($iddatainizio < $id_data_ini_periodi_prec) { $iddatainizio = $id_data_ini_periodi_prec; }
$iddatainizio = $iddatainizio - $id_data_ini_periodi_prec + 1;
$iddatafine = risul_query($regole_prec,$num1,iddatafine);
if ($iddatafine > $id_data_fine_periodi_prec) { $iddatafine = $id_data_fine_periodi_prec; }
$iddatafine = $iddatafine - $id_data_ini_periodi_prec + 1;
esegui_query("insert into $tableregole (idregole,app_agenzia,iddatainizio,iddatafine) values ('$idregole','$app_agenzia','$iddatainizio','$iddatafine') ");
} # fine for $num1
} # fine else if ($num_periodo_interferenza == 0)

$colonne = "idntariffe,nomecostoagg,tipo_ca,valore_ca,arrotonda_ca,associasett_ca,numsett_ca,moltiplica_ca,periodipermessi_ca,variazione_ca,mostra_ca,letto_ca,numlimite_ca";
for ($num1 = 1 ; $num1 <= $num_tariffe_tab ; $num1++) {
$nome_nuova_tariffa = "tariffa" . $num1;
$colonne .= ",$nome_nuova_tariffa";
} # fine for $num1
esegui_query("insert into $tablenometariffe ($colonne) select $colonne from $tablenometariffe_prec");
$costi_agg_importati = esegui_query("select * from $tablenometariffe where idntariffe > 4 ");
$num_costi_agg_importati = numlin_query($costi_agg_importati);
for ($num1 = 0 ; $num1 < $num_costi_agg_importati ; $num1++) {
$idntariffe = risul_query($costi_agg_importati,$num1,idntariffe);
$periodipermessi = risul_query($costi_agg_importati,$num1,periodipermessi_ca);
if ($periodipermessi) {
$pp_nuovi = substr($periodipermessi,0,1);
$periodipermessi = explode(",",substr($periodipermessi,1));
for ($num2 = 0 ; $num2 < count($periodipermessi) ; $num2++) {
$id_data_fine_pp = explode("-",$periodipermessi[$num2]);
$id_data_inizio_pp = $id_data_fine_pp[0];
$id_data_fine_pp = $id_data_fine_pp[1];
if ($id_data_fine_pp >= $id_data_ini_periodi_prec and $id_data_inizio_pp <= $id_data_fine_periodi_prec) {
if ($id_data_inizio_pp < $id_data_ini_periodi_prec) $id_data_inizio_pp = $id_data_ini_periodi_prec;
if ($id_data_fine_pp > $id_data_fine_periodi_prec) $id_data_fine_pp = $id_data_fine_periodi_prec;
$id_data_inizio_pp = $id_data_inizio_pp - $id_data_ini_periodi_prec + 1;
$id_data_fine_pp = $id_data_fine_pp - $id_data_ini_periodi_prec + 1;
$pp_nuovi .= $id_data_inizio_pp."-".$id_data_fine_pp.",";
} # fine if ($id_data_fine_pp >= $id_data_ini_periodi_prec and...
} # fine for $num2
if (strlen($pp_nuovi) > 1) $pp_nuovi = substr($pp_nuovi,0,-1);
esegui_query("update $tablenometariffe set periodipermessi_ca = '$pp_nuovi' where idntariffe = '$idntariffe'");
} # fine if ($periodipermessi)
} # fine for $num1
esegui_query("insert into $tableregole select * from $tableregole_prec where tariffa_per_app != ''");
esegui_query("insert into $tableregole select * from $tableregole_prec where tariffa_per_utente != ''");
include ("./includes/funzioni_menu.php");
include("./dati/lingua.php");
$privilegi_prec = esegui_query("select * from $tableprivilegi where anno = '$anno_prec'");
for ($num1 = 0 ; $num1 < numlin_query($privilegi_prec) ; $num1++) {
$idutente_p = risul_query($privilegi_prec,$num1,idutente);
$regole1_consentite_p = risul_query($privilegi_prec,$num1,regole1_consentite);
$tariffe_consentite_p = risul_query($privilegi_prec,$num1,tariffe_consentite);
$costi_agg_consentiti_p = risul_query($privilegi_prec,$num1,costi_agg_consentiti);
$contratti_consentiti_p = risul_query($privilegi_prec,$num1,contratti_consentiti);
$priv_ins_prenota_p = risul_query($privilegi_prec,$num1,priv_ins_prenota);
$priv_mod_prenota_p = risul_query($privilegi_prec,$num1,priv_mod_prenota);
$priv_mod_pers_p = risul_query($privilegi_prec,$num1,priv_mod_pers);
$priv_ins_clienti_p = risul_query($privilegi_prec,$num1,priv_ins_clienti);
$prefisso_clienti_p = risul_query($privilegi_prec,$num1,prefisso_clienti);
$priv_ins_costi_p = risul_query($privilegi_prec,$num1,priv_ins_costi);
$priv_vedi_tab_p = risul_query($privilegi_prec,$num1,priv_vedi_tab);
$priv_ins_tariffe_p = risul_query($privilegi_prec,$num1,priv_ins_tariffe);
$priv_ins_regole_p = risul_query($privilegi_prec,$num1,priv_ins_regole);
esegui_query("insert into $tableprivilegi (idutente,anno,regole1_consentite,tariffe_consentite,costi_agg_consentiti,contratti_consentiti,priv_ins_prenota,priv_mod_prenota,priv_mod_pers,priv_ins_clienti,prefisso_clienti,priv_ins_costi,priv_vedi_tab,priv_ins_tariffe,priv_ins_regole) values ('$idutente_p','$anno','$regole1_consentite_p','$tariffe_consentite_p','$costi_agg_consentiti_p','$contratti_consentiti_p','$priv_ins_prenota_p','$priv_mod_prenota_p','$priv_mod_pers_p','$priv_ins_clienti_p','$prefisso_clienti_p','$priv_ins_costi_p','$priv_vedi_tab_p','$priv_ins_tariffe_p','$priv_ins_regole_p')");
$lingua_mex = $lingua[$idutente_p];
crea_menu_date("./dati/selectperiodi$anno.1.php","./dati/selectperiodi$anno.$idutente_p.php",$tipo_periodi);
crea_menu_date("./dati/selperiodimenu$anno.1.php","./dati/selperiodimenu$anno.$idutente_p.php",$tipo_periodi);
$lingua_mex = $lingua[$id_utente];
$giorno_vedi_ini_sett = esegui_query("select valpersonalizza_num from $tablepersonalizza where idpersonalizza = 'giorno_vedi_ini_sett$anno_prec' and idutente = '$idutente_p'");
if (numlin_query($giorno_vedi_ini_sett) == 1 and $tipo_periodi == "g") esegui_query("insert into $tablepersonalizza (idpersonalizza,valpersonalizza_num,idutente) values ('giorno_vedi_ini_sett$anno','".risul_query($giorno_vedi_ini_sett,0,"valpersonalizza_num")."','$idutente_p')");
} # fine for $num1
$giorno_vedi_ini_sett = esegui_query("select valpersonalizza_num from $tablepersonalizza where idpersonalizza = 'giorno_vedi_ini_sett$anno_prec' and idutente = '1'");
if (numlin_query($giorno_vedi_ini_sett) == 1 and $tipo_periodi == "g") esegui_query("insert into $tablepersonalizza (idpersonalizza,valpersonalizza_num,idutente) values ('giorno_vedi_ini_sett$anno','".risul_query($giorno_vedi_ini_sett,0,"valpersonalizza_num")."','1')");
$inserisci_in_ntariffe = "NO";
} # fine if ($importa_anno_prec == "SI")

if ($inserisci_in_ntariffe != "NO") {
# rigo 1: nomi tariffe; 2-3: caparra (% e arrotondo).
for ($numtariffe = 1 ; $numtariffe <= 3 ; $numtariffe = $numtariffe + 1) {
esegui_query("insert into $tablenometariffe (idntariffe) values ($numtariffe)");
} # fine for $numtariffe
esegui_query("update $tablenometariffe set nomecostoagg = 8 where idntariffe = 1");
esegui_query("update $tablenometariffe set numlimite_ca = 5 where idntariffe = 1");
} # fine if ($inserisci_in_ntariffe != "NO")

unlock_tabelle($tabelle_lock);


if ($silenzio != "SI") echo "<br> ".mex("Anno ",$pag).$anno.mex(" creato",$pag)."! <br><br>";


if ($importa_anno_prec == "SI") {
if ($silenzio != "SI") $silenzio_mod = "SI";
else $silenzio_mod = "totale";
global $anno_modello_presente,$num_periodi_date,$modello_esistente,$cambia_frasi,$lingua_modello,$percorso_cartella_modello,$nome_file;
$pag_orig = $pag;
$pag = "crea_modelli.php";
include("./includes/templates/funzioni_modelli.php");
$modello_esistente = "SI";
$cambia_frasi = "NO";
$anno_modello = $anno;
include("./includes/templates/frasi_mod_disp.php");
include("./includes/templates/funzioni_mod_disp.php");
if (@is_file("$percorso_cartella_modello/modello_disponibilita.php")) {
$lingua_modello = "ita";
$nome_file = mex2("modello_disponibilita",$pag,$lingua_modello).".php";
$num_periodi_date = "";
recupera_var_modello_disponibilita($nome_file,$percorso_cartella_modello,$pag,$fr_frase,$num_frasi,$var_mod,$num_var_mod,$tipo_periodi,"SI",$anno_modello,$PHPR_TAB_PRE);
if ($anno_modello_presente == $anno_prec) {
aggiorna_var_anno_modello_disponibilita($id_data_ini_periodi_prec,$tableperiodi_prec,$tableperiodi,$tabletransazioniweb,$tablemessaggi,$tipo_periodi);
crea_modello_disponibilita($percorso_cartella_modello,$anno_modello,$PHPR_TAB_PRE,$pag,$lingua_modello,$silenzio_mod,$fr_frase,$frase,$num_frasi,$tipo_periodi);
} # fine if ($anno_modello_presente == $anno_prec)
} # fine if (@is_file("$percorso_cartella_modello/modello_disponibilita.php"))
$lang_dir = opendir("./includes/lang/");
include("./dati/lingua.php");
while ($ini_lingua = readdir($lang_dir)) {
if ($ini_lingua != "." && $ini_lingua != "..") {
$nome_file = mex2("modello_disponibilita",$pag,$ini_lingua).".php";
if (@is_file("$percorso_cartella_modello/$nome_file")) {
$lingua_modello = $ini_lingua;
$num_periodi_date = "";
recupera_var_modello_disponibilita($nome_file,$percorso_cartella_modello,$pag,$fr_frase,$num_frasi,$var_mod,$num_var_mod,$tipo_periodi,"SI",$anno_modello,$PHPR_TAB_PRE);
if ($anno_modello_presente == $anno_prec) {
aggiorna_var_anno_modello_disponibilita($id_data_ini_periodi_prec,$tableperiodi_prec,$tableperiodi,$tabletransazioniweb,$tablemessaggi,$tipo_periodi);
crea_modello_disponibilita($percorso_cartella_modello,$anno_modello,$PHPR_TAB_PRE,$pag,$lingua_modello,$silenzio_mod,$fr_frase,$frase,$num_frasi,$tipo_periodi);
} # fine if ($anno_modello_presente == $anno_prec)
} # fine if (@is_file("$percorso_cartella_modello/$nome_file"))
} # fine if ($file != "." && $file != "..")
} # fine while ($file = readdir($lang_dig))
closedir($lang_dir);
$templates_dir = opendir("./includes/templates/");
while ($modello_ext = readdir($templates_dir)) {
if ($modello_ext != "." and $modello_ext != ".." and @is_dir("./includes/templates/$modello_ext")) {
include("./includes/templates/$modello_ext/name.php");
include("./includes/templates/$modello_ext/phrases.php");
include("./includes/templates/$modello_ext/functions.php");
$funz_recupera_var_modello = "recupera_var_modello_".$modello_ext;
$funz_crea_modello = "crea_modello_".$modello_ext;
$funz_aggiorna_var_anno_modello = "aggiorna_var_anno_modello_".$modello_ext;
if ($template_file_name["ita"]) $nome_file = $template_file_name["ita"];
else $nome_file = "ita_".$template_file_name["en"];
if (@is_file("$percorso_cartella_modello/$nome_file")) {
$lingua_modello = "ita";
$num_periodi_date = "";
$funz_recupera_var_modello($nome_file,$percorso_cartella_modello,$pag,$fr_frase,$num_frasi,$var_mod,$num_var_mod,$tipo_periodi,"SI",$anno_modello,$PHPR_TAB_PRE);
if ($anno_modello_presente == $anno_prec) {
$funz_aggiorna_var_anno_modello($id_data_ini_periodi_prec,$tableperiodi_prec,$tableperiodi,$tabletransazioniweb,$tablemessaggi,$tipo_periodi);
$funz_crea_modello($percorso_cartella_modello,$anno_modello,$PHPR_TAB_PRE,$pag,$lingua_modello,$silenzio_mod,$fr_frase,$frase,$num_frasi,$tipo_periodi);
} # fine if ($anno_modello_presente == $anno_prec)
} # fine if (@is_file("$percorso_cartella_modello/$nome_file"))
$lang_dir = opendir("./includes/lang/");
while ($ini_lingua = readdir($lang_dir)) {
if ($ini_lingua != "." && $ini_lingua != "..") {
if ($template_file_name[$ini_lingua]) $nome_file = $template_file_name[$ini_lingua];
else $nome_file = $ini_lingua."_".$template_file_name["en"];
if (@is_file("$percorso_cartella_modello/$nome_file")) {
$lingua_modello = $ini_lingua;
$num_periodi_date = "";
$funz_recupera_var_modello($nome_file,$percorso_cartella_modello,$pag,$fr_frase,$num_frasi,$var_mod,$num_var_mod,$tipo_periodi,"SI",$anno_modello,$PHPR_TAB_PRE);
if ($anno_modello_presente == $anno_prec) {
$funz_aggiorna_var_anno_modello($id_data_ini_periodi_prec,$tableperiodi_prec,$tableperiodi,$tabletransazioniweb,$tablemessaggi,$tipo_periodi);
$funz_crea_modello($percorso_cartella_modello,$anno_modello,$PHPR_TAB_PRE,$pag,$lingua_modello,$silenzio_mod,$fr_frase,$frase,$num_frasi,$tipo_periodi);
} # fine if ($anno_modello_presente == $anno_prec)
} # fine if (@is_file("$percorso_cartella_modello/$nome_file"))
} # fine if ($file != "." && $file != "..")
} # fine while ($file = readdir($lang_dir))
closedir($lang_dir);
} # fine if ($modello_ext != "." and $modello_ext != ".." and...
} # fine while ($file = readdir($lang_dig))
closedir($templates_dir);
$pag = $pag_orig;
if ($silenzio != "SI") echo "<br>";
} # fine if ($importa_anno_prec == "SI")


} # fine if (numlin_query($anno_esistente) == 0)
else if ($silenzio != "SI") echo mex("Anno già creato",$pag).".<br>";

flock($filelock,3);
fclose($filelock);
unlink("./dati/anni.lock");


} # fine function crea_nuovo_anno



?>