<?php

##################################################################################
#    PHP-RESIDENCE
#    Copyright (C) 2001-2006 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################

#Funzioni per effettuare il backup


function connetti_db_per_backup ($PHPR_DB_TYPE,$PHPR_DB_NAME,$PHPR_DB_HOST,$PHPR_DB_PORT,$PHPR_DB_USER,$PHPR_DB_PASS,$PHPR_LOAD_EXT,$PHPR_TAB_PRE,&$ext_pgsql_caricata,&$ext_mysql_caricata) {

if ($PHPR_DB_TYPE == "postgresql") {
if ($PHPR_LOAD_EXT == "SI") {
dl("pgsql.so");
$ext_pgsql_caricata = "SI";
} # fine if ($PHPR_LOAD_EXT == "SI")
$numconnessione = pg_connect("dbname=$PHPR_DB_NAME host=$PHPR_DB_HOST port=$PHPR_DB_PORT user=$PHPR_DB_USER password=$PHPR_DB_PASS ");
pg_exec("set datestyle to 'iso'");
} # fine if ($PHPR_DB_TYPE == "postgresql")
if ($PHPR_DB_TYPE == "mysql") {
if ($PHPR_LOAD_EXT == "SI") {
dl("mysql.so");
$ext_mysql_caricata = "SI";
} # fine if ($PHPR_LOAD_EXT == "SI")
$numconnessione = mysql_connect ("$PHPR_DB_HOST:$PHPR_DB_PORT", "$PHPR_DB_USER", "$PHPR_DB_PASS");
mysql_select_db($PHPR_DB_NAME);
} # fine if ($PHPR_DB_TYPE == "mysql")

return $numconnessione;

} # fine function connetti_db_per_backup


# Function per passare una tabella nel backup
function dump_tabella ($tabella,&$file) {

global $PHPR_TAB_PRE,$id_utente;
fwrite($file,"<tabella>
<nometabella>$tabella</nometabella>
<colonnetabella>
");
if ($tabella == "transazioni") $contenuto_tab = esegui_query("select * from $PHPR_TAB_PRE$tabella where tipo_transazione != 'err_l'");
else {
if ($tabella == "contratti") $contenuto_tab = esegui_query("select * from $PHPR_TAB_PRE$tabella order by tipo desc");
else $contenuto_tab = esegui_query("select * from $PHPR_TAB_PRE$tabella");
} # fine else if ($tabella == "transazioni")
$num_colonne = numcampi_query($contenuto_tab);
$num_righe = numlin_query($contenuto_tab);
for ($num1 = 0 ; $num1 < $num_colonne ; $num1++) {
$nome_colonna = nomecampo_query($contenuto_tab,$num1);
$tipo_colonna = tipocampo_query($contenuto_tab,$num1);
$dim_colonna = dimcampo_query($contenuto_tab,$num1);
fwrite($file,"<nomecolonna>$nome_colonna</nomecolonna>
<tipocolonna>$tipo_colonna</tipocolonna>
");
#fwrite($file,"<nomecolonna>$nome_colonna</nomecolonna>
#<tipocolonna>$tipo_colonna</tipocolonna>
#<dimcolonna>$dim_colonna</dimcolonna>
#");
} # fine for $num1
fwrite($file,"</colonnetabella>
<righetabella>
");
for ($num1 = 0 ; $num1 < $num_righe ; $num1++) {
fwrite($file,"<riga>");
$riga = arraylin_query($contenuto_tab,$num1);
for ($num2 = 0 ; $num2 < $num_colonne ; $num2++) {
$riga[$num2] = str_replace("@%&@","@%&@@%&@",$riga[$num2]);
$riga[$num2] = str_replace("</cmp>","</cmp@%&@>",$riga[$num2]);
if ($id_utente == "b" and $tabella == "utenti") {
if ($num2 == 1) $riga[$num2] = "u".$riga[0];
if ($num2 == 2 and $riga[3] != "n") $riga[$num2] = "u".$riga[0];
if ($num2 == 3 and $riga[3] != "n") $riga[$num2] = "t";
} # fine if ($id_utente == "b" and $tabella == "utenti")
fwrite($file,"<cmp>".$riga[$num2]."</cmp>");
} # fine for $num2
fwrite($file,"</riga>
");
} # fine for $num1
fwrite($file,"</righetabella>
</tabella>
");

} # fine function dump_tabella


# Function per passare un file nel backup
function dump_testo ($file_dump,&$file) {

fwrite($file,"<file>
<nomefile>$file_dump</nomefile>
<contenuto>
");
$linee_file = file("$file_dump");
$num_linee_file = count($linee_file);
for ($num1 = 0 ; $num1 < $num_linee_file ; $num1++) {
fwrite($file,$linee_file[$num1]);
} # fine for $num1
fwrite($file,"</contenuto>
</file>
");

} # fine function dump_testo


function esegui_query2($query,$tipo_db,$silenzio = "") {
if ($tipo_db == "postgresql") $risultato = pg_exec($query);
if ($tipo_db == "mysql") $risultato = mysql_query($query);
if (!$risultato and !$silenzio) echo "<br>ERROR IN: $query <br>".mysql_errno().": ".mysql_error()."<br>";
return $risultato;
} # fine function esegui_query2

function crea_indice2($tabella,$colonne,$nome,$tipo_db) {
if ($tipo_db == "postgresql") pg_exec("create index $nome on $tabella ($colonne)");
if ($tipo_db == "mysql") mysql_query("alter table $tabella add index $nome ($colonne)");
} # fine function crea_indice2



function ripristina_backup ($linee_backup,$silenzio,$pag,$numconnessione,$database_esistente,$tempdatabase,$PHPR_DB_TYPE,$PHPR_DB_NAME,$PHPR_DB_HOST,$PHPR_DB_PORT,$PHPR_DB_USER,$PHPR_DB_PASS,$PHPR_LOAD_EXT,$PHPR_TAB_PRE,$N_PHPR_DB_TYPE,$N_PHPR_DB_NAME,$N_PHPR_DB_HOST,$N_PHPR_DB_PORT,$N_PHPR_DB_USER,$N_PHPR_DB_PASS,$N_PHPR_LOAD_EXT,$N_PHPR_TAB_PRE,$ext_pgsql_caricata,$ext_mysql_caricata) {
$tableanni = $PHPR_TAB_PRE."anni";
$tableutenti = $PHPR_TAB_PRE."utenti";
global $MEDIUMTEXT;
$fatto = "NO";

if (C_CREA_NUOVI_APP == "NO") {
$num_appartamenti_prec = esegui_query("select idappartamenti from ".$PHPR_TAB_PRE."appartamenti");
$num_appartamenti_prec = numlin_query($num_appartamenti_prec);
} # fine if (C_CREA_NUOVI_APP == "NO")

if (C_CAMBIA_TIPO_PERIODI == "NO") {
unset($tipo_periodi_prec);
$anni = esegui_query("select * from $tableanni order by idanni");
for ($num1 = 0 ; $num1 < numlin_query($anni) ; $num1++) {
$ultimo_anno_prec = risul_query($anni,$num1,idanni);
$tipo_periodi_prec[$ultimo_anno_prec] = risul_query($anni,$num1,tipo_periodi);
} # fine for $num1
} # fine if (C_CAMBIA_TIPO_PERIODI == "NO")


# Prima lettura di controllo del file
$file_coerente = "SI";
$num_linee_backup = count($linee_backup);
for ($num1 = 0 ; $num1 < $num_linee_backup ; $num1++) {
$linea = togli_acapo($linee_backup[$num1]);
if ($linea == "</backup>") $leggendo_backup = "NO";
if ($leggendo_backup == "SI") {
if ($linea == "</database>") $leggendo_database = "NO";
if ($leggendo_database == "SI") {
if ($linea == "</tabella>") $leggendo_tabella = "NO";
if ($leggendo_tabella == "SI") {
if (substr($linea,0,13) == "<nometabella>") {
$nome_tabella = substr($linea,13);
$nome_tabella = substr($nome_tabella,0,-14);
} # fine if (substr($linea,0,13) == "<nometabella>")

if ($linea == "</colonnetabella>") {
$leggendo_colonne == "NO";
$anno_ins = "";
if ($nome_tabella == "clienti") $tab_presente["clienti"] = "SI";
if ($nome_tabella == "anni") $tab_presente["anni"] = "SI";
if ($nome_tabella == "versioni") $tab_presente["versioni"] = "SI";
if ($nome_tabella == "personalizza") $tab_presente["personalizza"] = "SI";
if ($nome_tabella == "appartamenti") $tab_presente["appartamenti"] = "SI";
if ($nome_tabella == "utenti") $tab_presente["utenti"] = "SI";
if ($nome_tabella == "privilegi") $tab_presente["privilegi"] = "SI";
if ($nome_tabella == "sessioni") $tab_presente["sessioni"] = "SI";
if ($nome_tabella == "transazioni") $tab_presente["transazioni"] = "SI";
if ($nome_tabella == "transazioniweb") $tab_presente["transazioniweb"] = "SI";
if ($nome_tabella == "contratti") $tab_presente["contratti"] = "SI";
if ($nome_tabella == "messaggi") $tab_presente["messaggi"] = "SI";
if (substr($nome_tabella,0,7) == "prenota") { $anno_ins = substr($nome_tabella,7); $tab_presente[$anno_ins]["prenota"] = "SI"; }
if (substr($nome_tabella,0,12) == "costiprenota") { $anno_ins = substr($nome_tabella,12); $tab_presente[$anno_ins]["costiprenota"] = "SI"; }
else if (substr($nome_tabella,0,5) == "costi") { $anno_ins = substr($nome_tabella,5); $tab_presente[$anno_ins]["costi"] = "SI"; }
if (substr($nome_tabella,0,6) == "regole") { $anno_ins = substr($nome_tabella,6); $tab_presente[$anno_ins]["regole"] = "SI"; }
if (substr($nome_tabella,0,5) == "soldi") { $anno_ins = substr($nome_tabella,5); $tab_presente[$anno_ins]["soldi"] = "SI"; }
if (substr($nome_tabella,0,7) == "periodi") { $anno_ins = substr($nome_tabella,7); $tab_presente[$anno_ins]["periodi"] = "SI"; }
if (substr($nome_tabella,0,8) == "ntariffe") { $anno_ins = substr($nome_tabella,8); $tab_presente[$anno_ins]["ntariffe"] = "SI"; }
if ($anno_ins and controlla_anno($anno_ins) == "NO") $file_coerente = "NO";
if ($anno_ins and $tab_anno_esistente[$anno_ins] != "SI") $tab_anno_esistente[$anno_ins] = "SI";
} # fine if ($linea == "</colonnetabella>")
if ($leggendo_colonne == "SI") {
if (substr($linea,0,13) == "<nomecolonna>") {
$num_colonne++;
$nome_colonna[$num_colonne] = substr($linea,13);
$nome_colonna[$num_colonne] = substr($nome_colonna[$num_colonne],0,-14);
if (substr($nome_tabella,0,7) == "periodi" and substr($nome_colonna[$num_colonne],0,7) == "tariffa") $lista_tariffe++;
if (substr($nome_tabella,0,8) == "ntariffe" and substr($nome_colonna[$num_colonne],0,7) == "tariffa") $lista_tariffe++;
if (defined("C_MASSIMO_NUM_TARIFFE") and C_MASSIMO_NUM_TARIFFE != 0 and $lista_tariffe > max(C_MASSIMO_NUM_TARIFFE,10)) $file_coerente = "NO";
} # fine if (substr($linea,0,13) == "<nomecolonna>")
if (substr($linea,0,13) == "<tipocolonna>") {
$tipo_colonna[$num_colonne] = substr($linea,13);
$tipo_colonna[$num_colonne] = substr($tipo_colonna[$num_colonne],0,-14);
} # fine if (substr($linea,0,13) == "<tipocolonna>")
} # fine if ($leggendo_colonne == "SI")
if ($linea == "<colonnetabella>") {
$leggendo_colonne = "SI";
$num_colonne = 0;
$lista_tariffe = 0;
} # fine if ($linea == "<colonnetabella>")

if ($linea == "</righetabella>") $leggendo_righe = "NO";
if ($leggendo_righe == "SI") {
if (substr($linea,0,6) == "<riga>") $riga = substr($linea,11);
else {
$riga .= "
".$linea;
} # fine else if (substr($linea,0,6) == "<riga>")
if (substr($linea,-7) == "</riga>") {
$riga = substr($riga,0,-13);
$riga = explode("</cmp><cmp>",$riga);
$lista_valori = "";
$lista_colonne = "";
unset($valore_colonna);
for ($num2 = 0 ; $num2 < count($riga) ; $num2++) {
$valore = addslashes($riga[$num2]);
if ($valore != "") {
$valore = str_replace("</cmp@%&@>","</cmp>",$valore);
$valore = str_replace("@%&@@%&@","@%&@",$valore);
$valore_colonna[$nome_colonna[($num2+1)]] = $valore;
} # fine if ($valore != "")
} # fine for $num2
if (C_CREA_NUOVI_APP == "NO" and $nome_tabella == "appartamenti" and $linee_inserite_in_tabella[$nome_tabella] >= $num_appartamenti_prec) $file_coerente = "NO";
if ($nome_tabella == "anni") $campo_anno_esistente[$valore_colonna["idanni"]] = $valore_colonna["tipo_periodi"];
if (C_CREA_ANNO_NON_ATTUALE == "NO" and $nome_tabella == "anni" and $valore_colonna["idanni"] < C_PRIMO_ANNO_CREATO) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_UTENTI") and C_MASSIMO_NUM_UTENTI != 0 and $nome_tabella == "utenti" and $linee_inserite_in_tabella[$nome_tabella] >= C_MASSIMO_NUM_UTENTI) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_UTENTI") and C_MASSIMO_NUM_UTENTI != 0 and ($nome_tabella == "sessioni" or $nome_tabella == "transazioni") and $linee_inserite_in_tabella[$nome_tabella] >= (C_MASSIMO_NUM_UTENTI * 25)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_UTENTI") and C_MASSIMO_NUM_UTENTI != 0 and $nome_tabella == "privilegi" and $linee_inserite_in_tabella[$nome_tabella] > (C_MASSIMO_NUM_UTENTI * 2)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_UTENTI") and C_MASSIMO_NUM_UTENTI != 0 and $nome_tabella == "personalizza" and $linee_inserite_in_tabella[$nome_tabella] >= (C_MASSIMO_NUM_UTENTI * 16)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_CLIENTI") and C_MASSIMO_NUM_CLIENTI != 0 and $nome_tabella == "clienti" and $linee_inserite_in_tabella[$nome_tabella] >= C_MASSIMO_NUM_CLIENTI) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_CLIENTI") and C_MASSIMO_NUM_CLIENTI != 0 and $nome_tabella == "transazioniweb" and $linee_inserite_in_tabella[$nome_tabella] >= C_MASSIMO_NUM_CLIENTI) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_COSTI_AGG") and C_MASSIMO_NUM_COSTI_AGG != 0 and substr($nome_tabella,0,8) == "ntariffe" and $linee_inserite_in_tabella[$nome_tabella] >= (C_MASSIMO_NUM_COSTI_AGG + 4)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_CONTRATTI") and C_MASSIMO_NUM_CONTRATTI != 0 and $nome_tabella == "contratti" and $linee_inserite_in_tabella[$nome_tabella] >= ((C_MASSIMO_NUM_CONTRATTI * 10) + 40)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_CLIENTI") and C_MASSIMO_NUM_CLIENTI != 0 and $nome_tabella == "messaggi" and $linee_inserite_in_tabella[$nome_tabella] >= C_MASSIMO_NUM_CLIENTI) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_STORIA_SOLDI") and C_MASSIMO_NUM_STORIA_SOLDI != 0 and substr($nome_tabella,0,5) == "soldi" and $linee_inserite_in_tabella[$nome_tabella] >= (C_MASSIMO_NUM_STORIA_SOLDI + 1)) $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_COSTI") and C_MASSIMO_NUM_COSTI != 0 and substr($nome_tabella,0,5) == "costi" and $linee_inserite_in_tabella[$nome_tabella] >= C_MASSIMO_NUM_COSTI) $file_coerente = "NO";
if (substr($nome_tabella,0,8) == "ntariffe" and $valore_colonna["idntariffe"] == 1) $numero_tariffe[substr($nome_tabella,8)] = $valore_colonna["nomecostoagg"];
if ($nome_tabella == "versioni" and $linee_inserite_in_tabella[$nome_tabella] >= 2) $file_coerente = "NO";
$linee_inserite_in_tabella[$nome_tabella]++;
} # fine if (substr($linea,-7) == "</riga>")
} # fine if ($leggendo_righe == "SI")
if ($linea == "<righetabella>") {
$leggendo_righe = "SI";
$linee_inserite_in_tabella[$nome_tabella] = 0;
} # fine if ($linea == "<righetabella>")
} # fine if ($leggendo_tabella == "SI")
if ($linea == "<tabella>") $leggendo_tabella = "SI";
} # fine if ($leggendo_database == "SI")

else {
if ($linea == "</file>") $leggendo_file = "NO";
if ($leggendo_file == "SI") {
if ($nome_file) {
if ($leggendo_contenuto == "SI") {
if (substr($linea,-12) == "</contenuto>") {
$leggendo_contenuto = "NO";
$leggendo_cont_file_sel = "NO";
$linea = substr($linea,0,-12);
} # fine if (substr($linea,-12) == "</contenuto>")
$linea = trim($linea);
if ($nome_file == "./dati/versione.php") {
if ($linea != "" and $linea != "<?php" and $linea != "define(C_VERSIONE_ATTUALE,".C_PHPR_VERSIONE_NUM.");" and ereg_replace("define\(C_DIFF_ORE,[0-9]{1,2}\);","",$linea) != "" and $linea != "?>") $file_coerente = "NO";
} # fine if ($nome_file == "./dati/versione.php")
if ($nome_file == "./dati/selectappartamenti.php") {
if ($linea == "\";") $leggendo_cont_file_sel = "NO";
if ($leggendo_cont_file_sel != "SI" and $linea != "" and $linea != "<?php" and $linea != "?>" and $linea != "\";" and $linea != "echo \"") $file_coerente = "NO";
if ($leggendo_cont_file_sel == "SI") {
if (str_replace("\\\\","",$linea) != $linea) $file_coerente = "NO";
$linea = str_replace("\\\"","",$linea);
if (str_replace("\"","",$linea) != $linea) $file_coerente = "NO";
} # fine if ($leggendo_cont_file_sel == "SI")
if ($linea == "echo \"") $leggendo_cont_file_sel = "SI";
} # fine if ($nome_file == "./dati/selectappartamenti.php")

if (substr($nome_file,0,20) == "./dati/selectperiodi" or substr($nome_file,0,21) == "./dati/selperiodimenu") {
if ($linea == "\";") $leggendo_cont_file_sel = "NO";
if ($leggendo_cont_file_sel != "SI") {
$linea_trovata = "NO";
if ($linea == "") $linea_trovata = "SI";
if ($linea == "<?php") $linea_trovata = "SI";
if ($linea == "?>") $linea_trovata = "SI";
if ($linea == "\";") $linea_trovata = "SI";
if ($linea == "\$dates_options_list = \"") $linea_trovata = "SI";
if (ereg_replace("\\\$y_ini_menu\\[[0-9]{1,2}\\] = \"[0-9]{1,4}\";","",$linea) == "") $linea_trovata = "SI";
if (ereg_replace("\\\$m_ini_menu\\[[0-9]{1,2}\\] = \"[0-9]{1,2}\";","",$linea) == "") $linea_trovata = "SI";
if (ereg_replace("\\\$d_ini_menu\\[[0-9]{1,2}\\] = \"[0-9]{1,2}\";","",$linea) == "") $linea_trovata = "SI";
if (ereg_replace("\\\$n_dates_menu\\[[0-9]{1,2}\\] = \"[0-9]{1,4}\";","",$linea) == "") $linea_trovata = "SI";
if (ereg_replace("\\\$d_increment\\[[0-9]{1,2}\\] = \"[0-9]{1,2}\";","",$linea) == "") $linea_trovata = "SI";
if ($linea == "\$partial_dates = 1;") $linea_trovata = "SI";
if (ereg_replace("\\\$d_names = \"\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\"\";","",$linea) == "") $linea_trovata = "SI";
if (ereg_replace("\\\$m_names = \"\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\",\\\\\"[^\"]{1,16}\\\\\"\";","",$linea) == "") $linea_trovata = "SI";
if ($linea_trovata != "SI") $file_coerente = "NO";
} # fine if ($leggendo_cont_file_sel != "SI")
if ($leggendo_cont_file_sel == "SI") {
if (str_replace("\\\\","",$linea) != $linea) $file_coerente = "NO";
$linea = str_replace("\\\"","",$linea);
if (str_replace("\"","",$linea) != $linea) $file_coerente = "NO";
} # fine if ($leggendo_cont_file_sel == "SI")
if ($linea == "\$dates_options_list = \"") $leggendo_cont_file_sel = "SI";
} # fine if (substr($nome_file,0,20) == "./dati/selectperiodi" or...

if ($nome_file == "./dati/abilita_login" and $linea != "") $file_coerente = "NO";
if ($nome_file == "./dati/lingua.php" and $linea != "" and $linea != "<?php" and $linea != "?>" and ereg_replace("\\\$lingua\\[[0-9]{1,8}\\] = \"[a-z]{1,3}\";","",$linea) != "") $file_coerente = "NO";
if ($nome_file == "./dati/tema.php" and $linea != "" and $linea != "<?php" and $linea != "?>" and ereg_replace("\\\$tema\\[[0-9]{1,8}\\] = \"[a-z]{1,4}\";","",$linea) != "" and ereg_replace("\\\$parole_sost = [01];","",$linea) != "") $file_coerente = "NO";
if ($nome_file == "./dati/parole_sost.php" and $linea != "" and $linea != "<?php" and $linea != "?>" and ereg_replace("\\\$messaggio = str_replace\\(\"[^\"]*\",\"[^\"]*\",\\\$messaggio\\);","",$linea) != "") $file_coerente = "NO";
if ($leggendo_contenuto == "NO") $nome_file = "";
} # fine if ($leggendo_contenuto == "SI")
if ($linea == "<contenuto>") $leggendo_contenuto = "SI";
} # fine if ($nome_file)
if (substr($linea,0,10) == "<nomefile>") {
$nome_file = substr($linea,10);
$nome_file = substr($nome_file,0,-11);
if (C_CREA_SUBORDINAZIONI == "NO" and str_replace("dati_subordinazione","",$nome_file) != $nome_file) $file_coerente = "NO";
if (substr($nome_file,0,7) != "./dati/") $file_coerente = "NO";
$nome_file_vett = explode("/",$nome_file);
if (count($nome_file_vett) > 3) $file_coerente = "NO";
$nome_file_trovato = "NO";
if ($nome_file == "./dati/selectappartamenti.php") $nome_file_trovato = "SI";
if ($nome_file == "./dati/abilita_login") $nome_file_trovato = "SI";
if ($nome_file == "./dati/lingua.php") $nome_file_trovato = "SI";
if ($nome_file == "./dati/tema.php") $nome_file_trovato = "SI";
if ($nome_file == "./dati/parole_sost.php") $nome_file_trovato = "SI";
if ($nome_file == "./dati/versione.php") $nome_file_trovato = "SI";
if (substr($nome_file,0,20) == "./dati/selectperiodi") $nome_file_trovato = "SI";
if (substr($nome_file,0,21) == "./dati/selperiodimenu") $nome_file_trovato = "SI";
if ($nome_file_trovato == "NO") $file_coerente = "NO";
} # fine if (substr($linea,0,9) == "<nomefile>")
} # fine if ($leggendo_file == "SI")
if ($linea == "<file>") $leggendo_file = "SI";

} # fine else if ($leggendo_database == "SI")
if ($linea == "<database>") $leggendo_database = "SI";
} # fine if ($leggendo_backup == "SI")
if ($linea == "<backup>") $leggendo_backup = "SI";
} # fine for $num1

if (!@is_array($tab_anno_esistente)) $file_coerente = "NO";
if (count($campo_anno_esistente) != count($tab_anno_esistente)) $file_coerente = "NO";
while (list($key, $val) = each($campo_anno_esistente)) {
if ($tab_anno_esistente[$key] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["prenota"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["costiprenota"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["costi"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["regole"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["soldi"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["periodi"] != "SI") $file_coerente = "NO";
if ($tab_presente[$key]["ntariffe"] != "SI") $file_coerente = "NO";
if (defined("C_PRIMO_ANNO_CREATO") and C_CREA_ANNO_NON_ATTUALE == "NO" and $key < C_PRIMO_ANNO_CREATO) $file_coerente = "NO";
if (C_CREA_ANNO_NON_ATTUALE == "NO" and $key > date("Y",(time() + (C_DIFF_ORE * 3600)))) $file_coerente = "NO";
if (!$anno_max or $key > $anno_max) {
$anno_max = $key;
$ultimo_tipo_periodi = $val;
} # fine if (!$anno_max or $key > $anno_max)
if (!$numero_tariffe[$key] or controlla_num_pos($numero_tariffe[$key]) == "NO") $file_coerente = "NO";
if (defined("C_MASSIMO_NUM_TARIFFE") and C_MASSIMO_NUM_TARIFFE != 0 and $numero_tariffe[$key] > C_MASSIMO_NUM_TARIFFE) $file_coerente = "NO";
if ($val != "g" and $val != "s") $file_coerente = "NO";
if (($val == "g" and $linee_inserite_in_tabella["periodi".$key] > 765) or ($val == "s" and $linee_inserite_in_tabella["periodi".$key] > 115)) $file_coerente = "NO";
$prenotazioni_max = ($linee_inserite_in_tabella["periodi".$key] * ($linee_inserite_in_tabella["appartamenti"] + 2));
if (defined("C_MASSIMO_NUM_COSTI_AGG_IN_PRENOTA") and C_MASSIMO_NUM_COSTI_AGG_IN_PRENOTA != 0 and $linee_inserite_in_tabella["costiprenota".$key] > (C_MASSIMO_NUM_COSTI_AGG_IN_PRENOTA * $prenotazioni_max)) $file_coerente = "NO";
if ($linee_inserite_in_tabella["prenota".$key] > $prenotazioni_max) $file_coerente = "NO";
if ($linee_inserite_in_tabella["regole".$key] > ($prenotazioni_max + ($numero_tariffe[$key] * 2))) $file_coerente = "NO";
} # fine while (list($key, $val) = each($campo_anno_esistente))
if (C_CAMBIA_TIPO_PERIODI == "NO" and $tipo_periodi_prec[$ultimo_anno_prec] != $ultimo_tipo_periodi) $file_coerente = "NO";
if ($tab_presente["clienti"] != "SI") $file_coerente = "NO";
if ($tab_presente["anni"] != "SI") $file_coerente = "NO";
if ($tab_presente["versioni"] != "SI") $file_coerente = "NO";
if ($tab_presente["personalizza"] != "SI") $file_coerente = "NO";
if ($tab_presente["appartamenti"] != "SI") $file_coerente = "NO";
if ($tab_presente["utenti"] != "SI") $file_coerente = "NO";
if ($tab_presente["privilegi"] != "SI") $file_coerente = "NO";
if ($tab_presente["sessioni"] != "SI") $file_coerente = "NO";
if ($tab_presente["transazioni"] != "SI") $file_coerente = "NO";
if ($tab_presente["transazioniweb"] != "SI") $file_coerente = "NO";
if ($tab_presente["contratti"] != "SI") $file_coerente = "NO";
if ($tab_presente["messaggi"] != "SI") $file_coerente = "NO";


if ($file_coerente == "NO") {
if ($silenzio != "SI") echo mex("Il formato del file è errato",$pag).".<br>";
} # fine if ($file_coerente == "NO")
else {



$tabelle_lock = array("$tableanni","$tableutenti");
$tabelle_lock = lock_tabelle($tabelle_lock);
$anni = esegui_query("select * from $tableanni order by idanni");
$num_anni = numlin_query($anni);
$utenti= esegui_query("select idutenti from $tableutenti order by idutenti");
for ($num1 = 0 ; $num1 < $num_anni ; $num1 = $num1 + 1) {
$anno_cancella = risul_query($anni,$num1,idanni);
esegui_query("drop table ".$PHPR_TAB_PRE."prenota$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."costiprenota$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."periodi$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."ntariffe$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."regole$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."soldi$anno_cancella");
esegui_query("drop table ".$PHPR_TAB_PRE."costi$anno_cancella");
for ($num2 = 0 ; $num2 < numlin_query($utenti) ; $num2++) {
$idutente_canc = risul_query($utenti,$num2,idutenti);
if (@is_file("./dati/selectperiodi$anno_cancella.$idutente_canc.php")) unlink("./dati/selectperiodi$anno_cancella.$idutente_canc.php");
if (@is_file("./dati/selperiodimenu$anno_cancella.$idutente_canc.php")) unlink("./dati/selperiodimenu$anno_cancella.$idutente_canc.php");
} # fine for $num2
} # fine for $num1
esegui_query("drop table ".$PHPR_TAB_PRE."appartamenti");
esegui_query("drop table ".$PHPR_TAB_PRE."clienti");
esegui_query("drop table ".$PHPR_TAB_PRE."personalizza");
esegui_query("drop table ".$PHPR_TAB_PRE."versioni");
esegui_query("drop table ".$PHPR_TAB_PRE."privilegi");
esegui_query("drop table ".$PHPR_TAB_PRE."sessioni");
esegui_query("drop table ".$PHPR_TAB_PRE."transazioni");
esegui_query("drop table ".$PHPR_TAB_PRE."transazioniweb");
esegui_query("drop table ".$PHPR_TAB_PRE."contratti");
esegui_query("drop table ".$PHPR_TAB_PRE."messaggi");
unlink("./dati/dati_connessione.php");
unlink("./dati/selectappartamenti.php");
unlink("./dati/versione.php");
unlink("./dati/tema.php");
if (@is_file("./dati/parole_sost.php")) unlink("./dati/parole_sost.php");
if (@is_file("./dati/abilita_login")) unlink("./dati/abilita_login");
unlock_tabelle($tabelle_lock);
esegui_query("drop table ".$PHPR_TAB_PRE."anni");
esegui_query("drop table ".$PHPR_TAB_PRE."utenti");

if ($N_PHPR_DB_NAME != $PHPR_DB_NAME or $N_PHPR_DB_HOST != $PHPR_DB_HOST or $N_PHPR_DB_PORT != $PHPR_DB_PORT or $N_PHPR_DB_TYPE != $PHPR_DB_TYPE) $nuovo_db = "SI";
if ($nuovo_db == "SI") {
if ($silenzio != "SI") echo "<br>".mex("Vecchio database svuotato, per rimuoverlo del tutto procedere manualmente",$pag).".<br><br>";
if ($database_esistente != "SI") {
disconnetti_db($numconnessione);
if ($N_PHPR_DB_TYPE == "postgresql") {
if ($N_PHPR_LOAD_EXT == "SI" and $ext_pgsql_caricata != "SI") {
dl("pgsql.so");
$ext_pgsql_caricata = "SI";
} # fine if ($N_PHPR_LOAD_EXT == "SI" and $ext_pgsql_caricata != "SI")
$numconnessione = pg_connect("dbname=$tempdatabase host=$N_PHPR_DB_HOST port=$N_PHPR_DB_PORT user=$N_PHPR_DB_USER password=$N_PHPR_DB_PASS ");
$encoding = " with encoding = 'SQL_ASCII'";
pg_exec("set datestyle to 'iso'");
} # fine if ($N_PHPR_DB_TYPE == "postgresql")
if ($N_PHPR_DB_TYPE == "mysql") {
if ($N_PHPR_LOAD_EXT == "SI" and $ext_mysql_caricata != "SI") {
dl("mysql.so");
$ext_mysql_caricata = "SI";
} # fine if ($PHPR_LOAD_EXT == "SI" and $ext_mysql_caricata != "SI")
$numconnessione = mysql_connect ("$N_PHPR_DB_HOST:$N_PHPR_DB_PORT", "$N_PHPR_DB_USER", "$N_PHPR_DB_PASS");
$encoding = "";
} # fine if ($N_PHPR_DB_TYPE == "mysql")
$query = esegui_query2("create database $N_PHPR_DB_NAME $encoding",$N_PHPR_DB_TYPE);
if ($N_PHPR_DB_TYPE == "postgresql") pg_close($numconnessione);
if ($N_PHPR_DB_TYPE == "mysql") mysql_close($numconnessione);
} # fine if ($database_esistente != "SI")
else $query = 1;
} # fine if ($nuovo_db == "SI")
else {
$query = 1;
disconnetti_db($numconnessione);
} # fine else if ($nuovo_db == "SI")
unlink("./dati/lingua.php");

if ($query) {
$character_set_db = "";
$collation_db = "";
if ($N_PHPR_DB_TYPE == "postgresql") {
$DATETIME = "timestamp";
if ($N_PHPR_LOAD_EXT == "SI" and $ext_pgsql_caricata != "SI") {
dl("pgsql.so");
$ext_pgsql_caricata = "SI";
} # fine if ($N_PHPR_LOAD_EXT == "SI" and $ext_pgsql_caricata != "SI")
$numconnessione = pg_connect("dbname=$N_PHPR_DB_NAME host=$N_PHPR_DB_HOST port=$N_PHPR_DB_PORT user=$N_PHPR_DB_USER password=$N_PHPR_DB_PASS ");
pg_exec("set datestyle to 'iso'");
} # fine if ($N_PHPR_DB_TYPE == "postgresql")
if ($N_PHPR_DB_TYPE == "mysql") {
$DATETIME = "datetime";
if ($N_PHPR_LOAD_EXT == "SI" and $ext_mysql_caricata != "SI") {
dl("mysql.so");
$ext_mysql_caricata = "SI";
} # fine if ($N_PHPR_LOAD_EXT == "SI" and $ext_mysql_caricata != "SI")
$numconnessione = mysql_connect ("$N_PHPR_DB_HOST:$N_PHPR_DB_PORT", "$N_PHPR_DB_USER", "$N_PHPR_DB_PASS");
$select_db = mysql_select_db($N_PHPR_DB_NAME);
if (!$select_db) $numconnessione = "";
else {
$character_set = mysql_query("SHOW VARIABLES LIKE 'character_set_database'");
$collation = mysql_query("SHOW VARIABLES LIKE 'collation_database'");
if (mysql_num_rows($character_set) == 1 and mysql_num_rows($collation) == 1) {
$character_set_db = mysql_result($character_set,0,"Value");
$collation_db = mysql_result($collation,0,"Value");
if ($character_set_db != "utf8" or $collation_db != "utf8_general_ci") mysql_query("alter database $N_PHPR_DB_NAME default character set 'utf8' collate 'utf8_general_ci'");
} # fine if (mysql_num_rows($character_set) == 1 and mysql_num_rows($collation) == 1)
} # fine else if (!$select_db)
} # fine if ($N_PHPR_DB_TYPE == "mysql")

if ($numconnessione) {

$fileaperto = fopen("./dati/dati_connessione.php","w+");
$N_PHPR_DB_NAME = aggiungi_slash($N_PHPR_DB_NAME);
$N_PHPR_DB_HOST = aggiungi_slash($N_PHPR_DB_HOST);
$N_PHPR_DB_USER = aggiungi_slash($N_PHPR_DB_USER);
$N_PHPR_DB_PASS = aggiungi_slash($N_PHPR_DB_PASS);
fwrite($fileaperto,"<?php
\$PHPR_DB_TYPE = \"$N_PHPR_DB_TYPE\";
\$PHPR_DB_NAME = \"$N_PHPR_DB_NAME\";
\$PHPR_DB_HOST = \"$N_PHPR_DB_HOST\";
\$PHPR_DB_PORT = \"$N_PHPR_DB_PORT\";
\$PHPR_DB_USER = \"$N_PHPR_DB_USER\";
\$PHPR_DB_PASS = \"$N_PHPR_DB_PASS\";
\$PHPR_LOAD_EXT = \"$N_PHPR_LOAD_EXT\";
\$PHPR_TAB_PRE = \"$N_PHPR_TAB_PRE\";
?>");
fclose($fileaperto);
@chmod("./dati/dati_connessione.php", 0640);

$leggendo_backup = "NO";
$leggendo_database = "NO";
$leggendo_tabella = "NO";
$leggendo_colonne = "NO";
$leggendo_righe = "NO";
$leggendo_file = "NO";
$leggendo_contenuto = "NO";
$nome_file = "";
unset($linee_inserite_in_tabella);
for ($num1 = 0 ; $num1 < $num_linee_backup ; $num1++) {
$linea = togli_acapo($linee_backup[$num1]);

if ($linea == "</backup>") $leggendo_backup = "NO";

if ($leggendo_backup == "SI") {

if ($linea == "</database>") $leggendo_database = "NO";

# restore del database
if ($leggendo_database == "SI") {

if ($linea == "</tabella>") $leggendo_tabella = "NO";

if ($leggendo_tabella == "SI") {

if (substr($linea,0,13) == "<nometabella>") {
$nome_tabella = substr($linea,13);
$nome_tabella = substr($nome_tabella,0,-14);
} # fine if (substr($linea,0,13) == "<nometabella>")

if ($linea == "</colonnetabella>") {
$leggendo_colonne == "NO";
if ($nome_tabella == "clienti") esegui_query2("create table ".$N_PHPR_TAB_PRE."clienti (idclienti integer primary key, cognome varchar(70) not null, nome varchar(70), sesso char, cognome2 varchar(70), nome2 varchar(70), sesso2 char, datanascita date, datanascita2 date, cittanascita varchar(70), cittanascita2 varchar(70), documento varchar(70), documento2 varchar(70), scadenzadoc date, scadenzadoc2 date, nazione varchar(70), regione varchar(70), citta varchar(70), via varchar(70), numcivico varchar(30), cap varchar(30), telefono varchar(50), telefono2 varchar(50), telefono3 varchar(50), fax varchar(50), email text, commento text, datainserimento $DATETIME, hostinserimento varchar(50), utente_inserimento integer )",$N_PHPR_DB_TYPE);
if ($nome_tabella == "anni") esegui_query2("create table ".$N_PHPR_TAB_PRE."anni (idanni integer primary key, tipo_periodi text)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "versioni") esegui_query2("create table ".$N_PHPR_TAB_PRE."versioni (idversioni integer primary key, num_versione float4)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "personalizza") esegui_query2("create table ".$N_PHPR_TAB_PRE."personalizza (idpersonalizza varchar(50) not null, idutente integer, valpersonalizza text, valpersonalizza_num integer)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "appartamenti")esegui_query2("create table ".$N_PHPR_TAB_PRE."appartamenti (idappartamenti varchar(100) primary key, numpiano text, maxoccupanti integer, numcasa text, app_vicini text, priorita integer, commento text )",$N_PHPR_DB_TYPE);
if ($nome_tabella == "utenti") esegui_query2("create table ".$N_PHPR_TAB_PRE."utenti (idutenti integer primary key, nome_utente text, password text, tipo_pass varchar(1) )",$N_PHPR_DB_TYPE);
if ($nome_tabella == "privilegi") esegui_query2("create table ".$N_PHPR_TAB_PRE."privilegi (idutente integer, anno integer, regole1_consentite text, tariffe_consentite text, costi_agg_consentiti text, contratti_consentiti text, priv_ins_prenota varchar(20), priv_mod_prenota varchar(35), priv_mod_pers varchar(15), priv_ins_clienti varchar(5), prefisso_clienti text, priv_ins_costi varchar(10), priv_vedi_tab varchar(30), priv_ins_tariffe varchar(10), priv_ins_regole varchar(10), priv_messaggi varchar(10) )",$N_PHPR_DB_TYPE);
if ($nome_tabella == "sessioni") esegui_query2("create table ".$N_PHPR_TAB_PRE."sessioni (idsessioni varchar(30) primary key, idutente integer, indirizzo_ip text, user_agent text, ultimo_accesso $DATETIME)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "transazioni")esegui_query2("create table ".$N_PHPR_TAB_PRE."transazioni (idtransazioni varchar(30) primary key, idsessione varchar(30), tipo_transazione varchar(5), anno integer, spostamenti text, dati_transazione1 text, dati_transazione2 text, dati_transazione3 text, dati_transazione4 text, dati_transazione5 text, dati_transazione6 text, dati_transazione7 text, dati_transazione8 text, dati_transazione9 text, dati_transazione10 text, dati_transazione11 text, dati_transazione12 text, dati_transazione13 text, dati_transazione14 text, dati_transazione15 text, dati_transazione16 text, dati_transazione17 text, dati_transazione18 text, dati_transazione19 text, dati_transazione20 text, ultimo_accesso $DATETIME)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "transazioniweb")esegui_query2("create table ".$N_PHPR_TAB_PRE."transazioniweb (idtransazioni varchar(30) primary key, idsessione varchar(30), tipo_transazione varchar(5), anno integer, spostamenti text, dati_transazione1 text, dati_transazione2 text, dati_transazione3 text, dati_transazione4 text, dati_transazione5 text, dati_transazione6 text, dati_transazione7 text, dati_transazione8 text, dati_transazione9 text, dati_transazione10 text, dati_transazione11 text, dati_transazione12 text, dati_transazione13 text, dati_transazione14 text, dati_transazione15 text, dati_transazione16 text, dati_transazione17 text, dati_transazione18 text, dati_transazione19 text, dati_transazione20 text, ultimo_accesso $DATETIME)",$N_PHPR_DB_TYPE);
if ($nome_tabella == "contratti") esegui_query2("create table ".$N_PHPR_TAB_PRE."contratti (numero integer, tipo varchar(8), testo $MEDIUMTEXT )",$N_PHPR_DB_TYPE);
if ($nome_tabella == "messaggi") esegui_query2("create table ".$N_PHPR_TAB_PRE."messaggi (idmessaggi integer primary key, tipo_messaggio varchar(8), idutenti text, idutenti_visto text, datavisione $DATETIME, mittente text, testo text, dati_messaggio1 text, dati_messaggio2 text, dati_messaggio3 text, dati_messaggio4 text, dati_messaggio5 text, dati_messaggio6 text, dati_messaggio7 text, dati_messaggio8 text, dati_messaggio9 text, dati_messaggio10 text, dati_messaggio11 text, dati_messaggio12 text, dati_messaggio13 text, dati_messaggio14 text, dati_messaggio15 text, dati_messaggio16 text, dati_messaggio17 text, dati_messaggio18 text, dati_messaggio19 text, dati_messaggio20 text, datainserimento $DATETIME)",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,7) == "prenota") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idprenota integer primary key, idclienti integer, idappartamenti  varchar(100), iddatainizio integer, iddatafine integer, assegnazioneapp varchar(4), app_assegnabili text, num_persone integer, idprenota_compagna text, tariffa text, tariffesettimanali text, costiassociati varchar(1), sconto float8, tariffa_tot float8, caparra float8, pagato float8, metodo_pagamento text, codice varchar(10), commento text, conferma varchar(4), checkin $DATETIME, checkout $DATETIME, datainserimento $DATETIME, hostinserimento varchar(50), data_modifica $DATETIME, utente_inserimento integer )",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,12) == "costiprenota") {
esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idcostiprenota integer primary key, idprenota integer, tipo varchar(2), nome varchar(40), valore float8, arrotonda float4, associasett varchar(1), settimane text, moltiplica text, letto varchar(1), numlimite integer, idntariffe integer, variazione varchar(10), varmoltiplica varchar(1), varnumsett varchar(20), varperiodipermessi text, vartariffeassociate varchar(10), vartariffeincomp text, datainserimento $DATETIME, hostinserimento varchar(50), utente_inserimento integer)",$N_PHPR_DB_TYPE);
crea_indice2($N_PHPR_TAB_PRE.$nome_tabella,"idprenota","iidp".$nome_tabella,$N_PHPR_DB_TYPE);
} # fine if (substr($nome_tabella,0,12) == "costiprenota")
else if (substr($nome_tabella,0,5) == "costi") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idcosti integer unique,nome_costo text, val_costo float8, persona_costo text, provenienza_costo text, tipo_costo text, datainserimento $DATETIME, hostinserimento varchar(50), utente_inserimento integer)",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,6) == "regole") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idregole integer, app_agenzia varchar(100), tariffa_per_app text, tariffa_per_utente text, iddatainizio integer, iddatafine integer, motivazione text)",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,5) == "soldi") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idsoldi integer unique, motivazione text, metodo_pagamento text, saldo_prenota float8, saldo_cassa float8, soldi_prima float8, data_inserimento $DATETIME, utente_inserimento integer)",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,7) == "periodi") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idperiodi integer primary key, datainizio date not null, datafine date$lista_tariffe)",$N_PHPR_DB_TYPE);
if (substr($nome_tabella,0,8) == "ntariffe") esegui_query2("create table ".$N_PHPR_TAB_PRE."$nome_tabella (idntariffe integer, nomecostoagg varchar(40), tipo_ca varchar(2), valore_ca float8, arrotonda_ca float4, associasett_ca varchar(1), numsett_ca varchar(20), moltiplica_ca varchar(1), periodipermessi_ca text, variazione_ca varchar(10), mostra_ca varchar(1), letto_ca varchar(1), numlimite_ca integer$lista_tariffe)",$N_PHPR_DB_TYPE);
} # fine if ($linea == "</colonnetabella>")
if ($leggendo_colonne == "SI") {
if (substr($linea,0,13) == "<nomecolonna>") {
$num_colonne++;
$nome_colonna[$num_colonne] = substr($linea,13);
$nome_colonna[$num_colonne] = substr($nome_colonna[$num_colonne],0,-14);
if (substr($nome_tabella,0,7) == "periodi" and substr($nome_colonna[$num_colonne],0,7) == "tariffa") $lista_tariffe .= ", ".$nome_colonna[$num_colonne]." float8";
if (substr($nome_tabella,0,8) == "ntariffe" and substr($nome_colonna[$num_colonne],0,7) == "tariffa") $lista_tariffe .= ", ".$nome_colonna[$num_colonne]." varchar(40)";
} # fine if (substr($linea,0,13) == "<nomecolonna>")
if (substr($linea,0,13) == "<tipocolonna>") {
$tipo_colonna[$num_colonne] = substr($linea,13);
$tipo_colonna[$num_colonne] = substr($tipo_colonna[$num_colonne],0,-14);
} # fine if (substr($linea,0,13) == "<tipocolonna>")
} # fine if ($leggendo_colonne == "SI")
if ($linea == "<colonnetabella>") {
$leggendo_colonne = "SI";
$num_colonne = 0;
$lista_tariffe = "";
} # fine if ($linea == "<colonnetabella>")

if ($linea == "</righetabella>") $leggendo_righe = "NO";
if ($leggendo_righe == "SI") {
if (substr($linea,0,6) == "<riga>") $riga = substr($linea,11);
else {
$riga .= "
".$linea;
} # fine else if (substr($linea,0,6) == "<riga>")
if (substr($linea,-7) == "</riga>") {
$riga = substr($riga,0,-13);
$riga = explode("</cmp><cmp>",$riga);
$lista_valori = "";
$lista_colonne = "";
unset($valore_colonna);
for ($num2 = 0 ; $num2 < count($riga) ; $num2++) {
$valore = addslashes($riga[$num2]);
if ($valore != "") {
$valore = str_replace("</cmp@%&@>","</cmp>",$valore);
$valore = str_replace("@%&@@%&@","@%&@",$valore);
$lista_valori .= ",'".$valore."'";
$lista_colonne .= ",".$nome_colonna[($num2+1)];
} # fine if ($valore != "")
} # fine for $num2
$lista_valori = substr($lista_valori,1);
$lista_colonne = substr($lista_colonne,1);
#echo "insert into $nome_tabella ($lista_colonne) values ($lista_valori)<br>";
esegui_query2("insert into ".$N_PHPR_TAB_PRE."$nome_tabella ($lista_colonne) values ($lista_valori)",$N_PHPR_DB_TYPE);
} # fine if (substr($linea,-7) == "</riga>")
} # fine if ($leggendo_righe == "SI")
if ($linea == "<righetabella>") {
$leggendo_righe = "SI";
$linee_inserite_in_tabella[$nome_tabella] = 0;
} # fine if ($linea == "<righetabella>")

} # fine if ($leggendo_tabella == "SI")

if ($linea == "<tabella>") $leggendo_tabella = "SI";

} # fine if ($leggendo_database == "SI")
else {

# restore dei files
if ($linea == "</file>") $leggendo_file = "NO";

if ($leggendo_file == "SI") {

if ($nome_file) {
if ($leggendo_contenuto == "SI") {
if (substr($linea,-12) == "</contenuto>") {
$nome_file = "";
$leggendo_contenuto = "NO";
$linea = substr($linea,0,-12);
fwrite($fileaperto,$linea);
fclose($fileaperto);
} # fine if (substr($linea,-12) == "</contenuto>")
else {
fwrite($fileaperto,$linea."
");
} # fine else if (substr($linea,-12) == "</contenuto>")
} # fine if ($leggendo_contenuto == "SI")

if ($linea == "<contenuto>") $leggendo_contenuto = "SI";
} # fine if ($nome_file)

if (substr($linea,0,10) == "<nomefile>") {
$nome_file = substr($linea,10);
$nome_file = substr($nome_file,0,-11);
if ($nome_file) $fileaperto = fopen("$nome_file","w+");
} # fine if (substr($linea,0,9) == "<nomefile>")

} # fine if ($leggendo_file == "SI")

if ($linea == "<file>") $leggendo_file = "SI";

} # fine else if ($leggendo_database == "SI")

if ($linea == "<database>") $leggendo_database = "SI";

} # fine if ($leggendo_backup == "SI")

if ($linea == "<backup>") $leggendo_backup = "SI";

} # fine for $num1

if ($silenzio != "SI") echo mex("Database creato",$pag)."<br>";
$fatto = "SI";
if (($nuovo_db != "SI" or $database_esistente == "SI") and $character_set_db and ($character_set_db != "utf8" or $collation_db != "utf8_general_ci")) esegui_query2("alter database $N_PHPR_DB_NAME default character set '$character_set_db' collate '$collation_db'",$N_PHPR_DB_TYPE);
} # fine if ($numconnessione)
else if ($silenzio != "SI") echo mex("Non è stato possibile connettersi al nuovo database, controllare i dati per la connessione, i privilegi dell' utente o il nome del database",$pag).".<br>";
} # fine if ($query)
else if ($silenzio != "SI") echo mex("Non è stato possibile creare il nuovo database, controllare i dati per la connessione, i privilegi dell' utente, il nome del database o se esiste già un database chiamato",$pag)." $N_PHPR_DB_NAME.<br>";


} # fine else if ($file_coerente == "NO")

return $fatto;

} # fine function ripristina_backup




?>