<?php

##################################################################################
#    PHP-RESIDENCE
#    Copyright (C) 2001-2004 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################################

#Funzioni per usare il database POSTGRESQL

ignore_user_abort(1);

# variabili per le differenze nella sintassi delle query
#global $ILIKE,$LIKE;
$ILIKE = "ILIKE";
$LIKE = "LIKE";
$DATETIME = "timestamp";
$MEDIUMTEXT = "text";


function connetti_db($database,$host,$port,$user,$password,$estensione) {

if ($estensione == "SI") dl("pgsql.so");
$numconnessione = pg_connect("dbname=$database host=$host port=$port user=$user password=$password ");
pg_exec("set datestyle to 'iso'");

return $numconnessione;

} # fine function connetti_db


function disconnetti_db($numconnessione) {

$risultato = pg_close($numconnessione);
return $risultato;

} # fine function disconnetti_db


function esegui_query($query,$silenzio = "") {

$risultato = pg_exec($query);
if (!$risultato and !$silenzio) {
global $PHPR_TAB_PRE;
echo "<br>ERROR in: ".str_replace(" ".$PHPR_TAB_PRE," ",$query)."<br>";
} # fine (!$risultato and !$silenzio)
return $risultato;

} # fine function esegui_query


function risul_query($query,$riga,$colonna) {

$risultato = pg_result($query,$riga,$colonna);
return $risultato;

} # fine function risul_query


function numlin_query($query) {

$risultato = pg_numrows($query);
return $risultato;

} # fine function numlin_query


function arraylin_query($query,$num) {

$risultato = pg_fetch_row($query,$num);
return $risultato;

} # fine function arraylin_query


function numcampi_query($query) {

$risultato = pg_numfields($query);
return $risultato;

} # fine function numcampi_query


function nomecampo_query($query,$num) {

$risultato = pg_fieldname($query,$num);
return $risultato;

} # fine function nomecampo_query


function tipocampo_query($query,$num) {

$risultato = pg_fieldtype($query,$num);
return $risultato;

} # fine function tipocampo_query


function dimcampo_query($query,$num) {

$risultato = pg_fieldsize($query,$num);
return $risultato;

} # fine function dimcampo_query


function lock_tabelle($tabelle,$altre_tab_usate = "") {

if (@is_array($tabelle)) {
pg_exec("begin");
$num_tabelle = count($tabelle);
for ($num1 = 0 ; $num1 < $num_tabelle; $num1++) {
$tabella = $tabelle[$num1];
pg_exec("lock table $tabella");
} # fine for $num1
$risul = "commit";
} # fine if (@is_array($tabelle))
else $risul = "nocommit";

return $risul;

} # fine function lock_tabelle


function unlock_tabelle($tabelle_lock,$azione = "") {

if ($tabelle_lock != "nocommit") {
if ($azione == "rollback") pg_exec("rollback");
else pg_exec("commit");
} # fine if ($tabelle_lock != "nocommit")

} # fine function unlock_tabelle


/*
function ini_controllo_db($tabella_controllata) {

return $tabella_controllata;

} # fine function ini_controllo_db


function fine_controllo_db($azione,$tabella_controllata,$tabella_controllata_prova,$cambia,$id_cambiato,$val_cambiato,$tabelle_lock) {

if ($azione == "rollback") pg_exec("rollback");

} # fine function fine_controllo_db
*/


function crea_indice($tabella,$colonne,$nome) {

pg_exec("create index $nome on $tabella ($colonne)");

} # fine function crea_indice



?>