<?php

#################################################################################
#    PHP-RESIDENCE
#    Copyright (C) 2001-2006 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#################################################################################

$pag = "prenota.php";
$titolo = "Prenota";


include("./dati/dati_connessione.php");
include("./includes/funzioni_$PHPR_DB_TYPE.php");
$numconnessione = connetti_db($PHPR_DB_NAME,$PHPR_DB_HOST,$PHPR_DB_PORT,$PHPR_DB_USER,$PHPR_DB_PASS,$PHPR_LOAD_EXT);
include("./includes/funzioni.php");
include("./includes/sett_gio.php");
$tablenometariffe = $PHPR_TAB_PRE."ntariffe".$anno;
$tableprenota = $PHPR_TAB_PRE."prenota".$anno;
$tableperiodi = $PHPR_TAB_PRE."periodi".$anno;
$tableregole = $PHPR_TAB_PRE."regole".$anno;
$tableclienti = $PHPR_TAB_PRE."clienti";
$tableappartamenti = $PHPR_TAB_PRE."appartamenti";
$tabletransazioni = $PHPR_TAB_PRE."transazioni";
$tablepersonalizza = $PHPR_TAB_PRE."personalizza";
$tableprivilegi = $PHPR_TAB_PRE."privilegi";
$tablecostiprenota = $PHPR_TAB_PRE."costiprenota".$anno;
$tablemessaggi = $PHPR_TAB_PRE."messaggi";


$id_utente = controlla_login($numconnessione,$PHPR_TAB_PRE,$id_sessione,$nome_utente_phpr,$password_phpr,$anno);
if ($id_utente) {

if ($id_utente != 1) {
$privilegi_annuali_utente = esegui_query("select * from $tableprivilegi where idutente = '$id_utente' and anno = '$anno'");
if (numlin_query($privilegi_annuali_utente) == 0) $anno_utente_attivato = "NO";
else {
$anno_utente_attivato = "SI";
$privilegi_globali_utente = esegui_query("select * from $tableprivilegi where idutente = '$id_utente' and anno = '1'");
$priv_mod_pers = risul_query($privilegi_globali_utente,0,priv_mod_pers);
if (substr($priv_mod_pers,0,1) != "s") $modifica_pers = "NO";
$priv_ins_clienti = risul_query($privilegi_globali_utente,0,priv_ins_clienti);
if (substr($priv_ins_clienti,0,1) == "s") $inserimento_nuovi_clienti = "SI";
else $inserimento_nuovi_clienti = "NO";
if (substr($priv_ins_clienti,2,1) == "s") $vedi_clienti = "SI";
if (substr($priv_ins_clienti,2,1) == "p") $vedi_clienti = "PROPRI";
if (substr($priv_ins_clienti,2,1) != "s" and substr($priv_ins_clienti,2,1) != "p") $vedi_clienti = "NO";
$prefisso_clienti = risul_query($privilegi_globali_utente,0,prefisso_clienti);
$attiva_prefisso_clienti = substr($prefisso_clienti,0,1);
if ($attiva_prefisso_clienti != "n") {
$prefisso_clienti = explode(",",$prefisso_clienti);
$prefisso_clienti = $prefisso_clienti[1];
} # fine if ($prefisso_clienti != "n")
$regole1_consentite = risul_query($privilegi_annuali_utente,0,regole1_consentite);
$attiva_regole1_consentite = substr($regole1_consentite,0,1);
if ($attiva_regole1_consentite != "n") $regole1_consentite = explode("#@^",substr($regole1_consentite,3));
$tariffe_consentite = risul_query($privilegi_annuali_utente,0,tariffe_consentite);
$attiva_tariffe_consentite = substr($tariffe_consentite,0,1);
if ($attiva_tariffe_consentite == "s") {
$tariffe_consentite = explode(",",substr($tariffe_consentite,2));
unset($tariffe_consentite_vett);
for ($num1 = 0 ; $num1 < count($tariffe_consentite) ; $num1++) if ($tariffe_consentite[$num1]) $tariffe_consentite_vett[$tariffe_consentite[$num1]] = "SI";
} # fine if ($attiva_tariffe_consentite == "s")
$costi_agg_consentiti = risul_query($privilegi_annuali_utente,0,costi_agg_consentiti);
$attiva_costi_agg_consentiti = substr($costi_agg_consentiti,0,1);
if ($attiva_costi_agg_consentiti == "s") {
$costi_agg_consentiti = explode(",",substr($costi_agg_consentiti,2));
unset($costi_agg_consentiti_vett);
for ($num1 = 0 ; $num1 < count($costi_agg_consentiti) ; $num1++) if ($costi_agg_consentiti[$num1]) $costi_agg_consentiti_vett[$costi_agg_consentiti[$num1]] = "SI";
} # fine if ($attiva_costi_agg_consentiti == "s")
$priv_ins_prenota = risul_query($privilegi_annuali_utente,0,priv_ins_prenota);
$priv_ins_nuove_prenota = substr($priv_ins_prenota,0,1);
$priv_ins_assegnazione_app = substr($priv_ins_prenota,1,1);
$priv_ins_conferma = substr($priv_ins_prenota,2,1);
$priv_ins_sconto = substr($priv_ins_prenota,3,1);
$priv_ins_caparra = substr($priv_ins_prenota,4,1);
$priv_ins_costi_agg = substr($priv_ins_prenota,5,1);
$priv_ins_commento = substr($priv_ins_prenota,6,1);
$priv_ins_num_persone = substr($priv_ins_prenota,7,1);
$priv_ins_periodi_passati = substr($priv_ins_prenota,8,1);
$priv_ins_multiple = substr($priv_ins_prenota,9,1);
$priv_ins_checkin = substr($priv_ins_prenota,10,1);
} # fine else if (numlin_query($privilegi_annuali_utente) == 0)
} # fine if ($id_utente != 1)
else {
$anno_utente_attivato = "SI";
$modifica_pers = "SI";
$inserimento_nuovi_clienti = "SI";
$vedi_clienti = "SI";
$attiva_prefisso_clienti = "n";
$attiva_regole1_consentite = "n";
$attiva_tariffe_consentite = "n";
$attiva_costi_agg_consentiti = "n";
$priv_ins_nuove_prenota = "s";
$priv_ins_assegnazione_app = "s";
$priv_ins_conferma = "s";
$priv_ins_sconto = "s";
$priv_ins_caparra = "s";
$priv_ins_costi_agg = "s";
$priv_ins_commento = "s";
$priv_ins_num_persone = "s";
$priv_ins_periodi_passati = "s";
$priv_ins_multiple = "s";
$priv_ins_checkin = "s";
} # fine else if ($id_utente != 1)

if (defined("C_MASSIMO_NUM_CLIENTI") and C_MASSIMO_NUM_CLIENTI != 0) {
$num_clienti_esistenti = esegui_query("select idclienti from $tableclienti");
$num_clienti_esistenti = numlin_query($num_clienti_esistenti);
if ($num_clienti_esistenti >= C_MASSIMO_NUM_CLIENTI) $inserimento_nuovi_clienti = "NO";
} # fine if (defined("C_MASSIMO_NUM_CLIENTI") and C_MASSIMO_NUM_CLIENTI != 0)

if ($anno_utente_attivato == "SI" and $priv_ins_nuove_prenota == "s") {


if ($tema[$id_utente] and $tema[$id_utente] != "base" and @is_dir("./includes/themes/".$tema[$id_utente])) include("./includes/themes/".$tema[$id_utente]."/head.php");
else include("./includes/head.php");


if ($id_utente != 1 or controlla_num_pos($id_utente_ins) == "NO" or $id_utente_ins == "") $id_utente_ins = $id_utente;
$inserito_nuovo_cliente = "NO";



/*
STRUTTURA TABELLA COSTI AGGIUNTIVI DELLE PRENOTAZIONI

tipo(varchar2)			u-s				1 unico - settimanale
				f-p-q				2 fisso - percentuale su tariffa - percentuale su totale
nome(varchar40)
valore(float8)
valore_orig(float8)
arrotonda(float4)
associasett(varchar1)		s-n				1 associa a specifiche settimane della prenotazione: si-no
settimane(text)		X;,idperiodi,idperiodi,...	1 numero di settimane se associasett=n, lista periodi se associasett=s
moltiplica(integer)		X;X,X,X...			1 moltiplica per X se no sett. o no associa sett. ; altrimenti moltiplica ogni sett. attivata per X corrispondente
letto(varchar1)		s-n				1 considera come letto aggiuntivo: si-no
#numlimite(integer)		X				NULL o vuoto se non ci sono limiti al numero di costi nello stesso periodo
idntariffe(integer)		idntariffa			id del costo aggiuntivo
#variazione(varchar10)	s-n				1 modifica con costo della prenotazione il costo percentuale: si-no
#				s-n				2 modifica numero settimane con prenotazione: si-no
#				s-n				3 modifica numero con cui moltiplicare con prenotazione: si-no
#				s-n				4 modifica in periodi permessi con prenotazione: si-no
varmoltiplica(varchar1)	1-c-p-t				1 moltiplica per: 1 - chiedere - persone - persnone totali
varnumsett(varchar20)		t-m-c-n-s-g,			1 tutte - tutte meno una - chiedere - x settimane si e y no - x settimane si e y no - solo giorni della settimana selezionati
varperiodipermessi(text)	t-u-p				NULL o vuoto se periodi tutti permessi, altrimenti: tutta la prenotazione dentro i periodi - anche un solo periodo - solo periodi permessi
				idperiodo-idperiodo,...	
vartariffeassociate(varchar10)	s-p			1 associare a tariffa: sempre - se possibile
					s-<x->x-=x		2- NULL o vuoto se costo non associato alla tariffa, altrimenti: per qualsiasi numero di settimane - meno di x - più di x - per x settimane
vartariffeincomp(text)	X,X,...				NULL o vuoto se costo compatibile con tutte le tariffe, antrimenti lista coi numeri delle tariffe incompatibili

*/



$Euro = nome_valuta();
$stile_soldi = stile_soldi();
$stile_data = stile_data();

if (@get_magic_quotes_gpc()) {
$cognome = stripslashes($cognome);
$cognome2 = stripslashes($cognome2);
} # fine if (@get_magic_quotes_gpc())

if (!$num_tipologie or controlla_num_pos($num_tipologie) == "NO" or $num_tipologie == 0 or $num_tipologie > 999) $num_tipologie = 1;
if ($num_tipologie_da_aggiungere and controlla_num_pos($num_tipologie_da_aggiungere) == "SI" and ($num_tipologie + $num_tipologie_da_aggiungere) <= 999) {
for ($n_t = ($num_tipologie + 1) ; $n_t <= ($num_tipologie + $num_tipologie_da_aggiungere) ; $n_t++) {
${"inizioperiodo".$n_t} = ${"inizioperiodo".$num_tipologie};
${"fineperiodo".$n_t} = ${"fineperiodo".$num_tipologie};
${"appartamento".$n_t} = ${"appartamento".$num_tipologie};
${"nometipotariffa".$n_t} = ${"nometipotariffa".$num_tipologie};
${"num_app_richiesti".$n_t} = ${"num_app_richiesti".$num_tipologie};
${"numpersone".$n_t} = ${"numpersone".$num_tipologie};
${"assegnazioneapp".$n_t} = ${"assegnazioneapp".$num_tipologie};
${"sconto".$n_t} = ${"sconto".$num_tipologie};
${"conferma_prenota".$n_t} = ${"conferma_prenota".$num_tipologie};
${"commento".$n_t} = ${"commento".$num_tipologie};
${"lista_app".$n_t} = ${"lista_app".$num_tipologie};
${"caparra".$n_t} = ${"caparra".$num_tipologie};
${"giorno_stima_checkin".$n_t} = ${"giorno_stima_checkin".$num_tipologie};
${"ora_stima_checkin".$n_t} = ${"ora_stima_checkin".$num_tipologie};
${"min_stima_checkin".$n_t} = ${"min_stima_checkin".$num_tipologie};
${"met_paga_caparra".$n_t} = ${"met_paga_caparra".$num_tipologie};
${"num_piano".$n_t} = ${"num_piano".$num_tipologie};
${"num_casa".$n_t} = ${"num_casa".$num_tipologie};
${"num_persone_casa".$n_t} = ${"num_persone_casa".$num_tipologie};
for ($numca = 1 ; $numca <= $numcostiagg ; $numca++) {
${"costoagg".$numca."_".$n_t} = ${"costoagg".$numca."_".$num_tipologie};
${"numsettimane".$numca."_".$n_t} = ${"numsettimane".$numca."_".$num_tipologie};
${"nummoltiplica_ca".$numca."_".$n_t} = ${"nummoltiplica_ca".$numca."_".$num_tipologie};
} # fine for $numca
} # fine for $n_t
$num_tipologie = $num_tipologie + $num_tipologie_da_aggiungere;
} # fine if ($num_tipologie_da_aggiungere and...



# Se si viene da clienti.php e si devono ancora inserire i dati del cliente
if ($inserire_dati_cliente == "SI") {
if ($cognome == "") {
echo mex("É necessario inserire il cognome del cliente",$pag).".<br>";
$inserire = "NO";
} # fine if ($cognome == "")
if ($inserimento_nuovi_clienti == "NO") $inserire = "NO";

if ($inserire == "NO") {
echo "<form accept-charset=\"utf-8\" method=\"post\" action=\"$origine\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<br><input class=\"sbutton\" type=\"submit\" name=\"torna\" value=\"".mex("Torna indietro",$pag)."\">
</form>";
$mostra_form_inserisci_prenota = "NO";
} # fine if ($inserire == "NO")
else {
if ($inserire) {

if (@get_magic_quotes_gpc()) {
$nome = stripslashes($nome);
$nome2 = stripslashes($nome2);
$documento = stripslashes($documento);
$documento2 = stripslashes($documento2);
$tipo_documento = stripslashes($tipo_documento);
$tipo_documento2 = stripslashes($tipo_documento2);
$nazione = stripslashes($nazione);
$regione = stripslashes($regione);
$citta = stripslashes($citta);
$nomevia = stripslashes($nomevia);
$numcivico = stripslashes($numcivico);
$cap = stripslashes($cap);
$telefono = stripslashes($telefono);
$telefono2 = stripslashes($telefono2);
$telefono3 = stripslashes($telefono3);
$fax = stripslashes($fax);
$email = stripslashes($email);
} # fine if (@get_magic_quotes_gpc())
$cognome = htmlspecialchars($cognome);
$cognome2 = htmlspecialchars($cognome2);
$nome = htmlspecialchars($nome);
$nome2 = htmlspecialchars($nome2);
$documento = htmlspecialchars($documento);
$documento2 = htmlspecialchars($documento2);
$tipo_documento = htmlspecialchars($tipo_documento);
$tipo_documento2 = htmlspecialchars($tipo_documento2);
if ($sesso and $sesso != "f") $sesso = "m";
if ($sesso2 and $sesso2 != "f") $sesso2 = "m";
$nazione = htmlspecialchars($nazione);
$regione = htmlspecialchars($regione);
$citta = htmlspecialchars($citta);
$nomevia = htmlspecialchars($nomevia);
$numcivico = htmlspecialchars($numcivico);
$cap = htmlspecialchars($cap);
$telefono = htmlspecialchars($telefono);
$telefono2 = htmlspecialchars($telefono2);
$telefono3 = htmlspecialchars($telefono3);
$fax = htmlspecialchars($fax);
$email = htmlspecialchars($email);

$tabelle_lock = array("$tableclienti");
$altre_tab_lock = array("$tableprivilegi");
$tabelle_lock = lock_tabelle($tabelle_lock,$altre_tab_lock);

$cognome = addslashes($cognome);
if ($idclienti == "") {
$inserito_nuovo_cliente = "SI";
$datainserimento = date("Y-m-d H:i:s",(time() + (C_DIFF_ORE * 3600)));
$idclienti = esegui_query("select idclienti from $tableclienti where idclienti = '1'");
if (numlin_query($idclienti) == 0) $idclienti = 1;
else {
$idclienti = esegui_query("select max(idclienti) from $tableclienti");
$idclienti = risul_query($idclienti,0,0) + 1;
} # fine else if (numlin_query($idclienti) == 0)
$cognome_maius = ucwords($cognome);
if ($id_utente == 1 and $id_utente_ins != 1) {
$privilegi_globali_utente = esegui_query("select * from $tableprivilegi where idutente = '$id_utente_ins' and anno = '1'");
$prefisso_clienti = risul_query($privilegi_globali_utente,0,prefisso_clienti);
$attiva_prefisso_clienti = substr($prefisso_clienti,0,1);
if ($attiva_prefisso_clienti != "n") {
$prefisso_clienti = explode(",",$prefisso_clienti);
$prefisso_clienti = $prefisso_clienti[1];
} # fine if ($prefisso_clienti != "n")
} # fine if ($id_utente == 1 and $id_utente_ins != 1)
if ($attiva_prefisso_clienti == "p") $cognome_maius = $prefisso_clienti.$cognome_maius;
if ($attiva_prefisso_clienti == "s") $cognome_maius = $cognome_maius.$prefisso_clienti;
esegui_query("insert into $tableclienti ( idclienti, cognome, datainserimento,hostinserimento,utente_inserimento) values ( '$idclienti', '$cognome_maius', '$datainserimento', '$HOSTNAME','$id_utente_ins')");
$cognome = stripslashes($cognome);
if ($nome) {
$nome_maius = ucwords($nome);
$nome_maius = addslashes($nome_maius);
esegui_query("update $tableclienti set nome = '$nome_maius' where idclienti = '$idclienti' ");
} # fine if ($nome)
if ($sesso) {
$sesso = addslashes($sesso);
esegui_query("update $tableclienti set sesso = '$sesso' where idclienti = '$idclienti' ");
} # fine if ($sesso)
if ($cognome2) {
$cognome2 = addslashes($cognome2);
$cognome2_maius = ucwords($cognome2);
esegui_query("update $tableclienti set cognome2 = '$cognome2_maius' where idclienti = '$idclienti' ");
$cognome2 = stripslashes($cognome2);
} # fine if ($cognome2)
if ($nome2) {
$nome2_maius = ucwords($nome2);
$nome2_maius = addslashes($nome2_maius);
esegui_query("update $tableclienti set nome2 = '$nome2_maius' where idclienti = '$idclienti' ");
} # fine if ($nome2)
if ($sesso2) {
$sesso2 = addslashes($sesso2);
esegui_query("update $tableclienti set sesso2 = '$sesso2' where idclienti = '$idclienti' ");
} # fine if ($sesso2)
if ($mesenascita and $giornonascita and strlen($annonascita) == 4) {
#$datanascita = date("M d, Y" , mktime(0,0,0,$mesenascita,$giornonascita,$annonascita));
$datanascita = $annonascita."-".$mesenascita."-".$giornonascita;
$datanascita = addslashes($datanascita);
esegui_query("update $tableclienti set datanascita = '$datanascita' where idclienti = '$idclienti' ");
} # fine if ($mesenascita and ...
if ($mesenascita2 and $giornonascita2 and strlen($annonascita2) == 4) {
#$datanascita2 = date("M d, Y" , mktime(0,0,0,$mesenascita2,$giornonascita2,$annonascita2));
$datanascita2 = $annonascita2."-".$mesenascita2."-".$giornonascita2;
$datanascita2 = addslashes($datanascita2);
esegui_query("update $tableclienti set datanascita2 = '$datanascita2' where idclienti = '$idclienti' ");
} # fine if ($mesenascita2 and ...
if ($documento) {
if ($tipo_documento) $documento = $tipo_documento." ".$documento;
$documento = addslashes($documento);
esegui_query("update $tableclienti set documento = '$documento' where idclienti = '$idclienti' ");
} # fine if ($documento)
if ($documento2) {
if ($tipo_documento2) $documento2 = $tipo_documento2." ".$documento2;
$documento2 = addslashes($documento2);
esegui_query("update $tableclienti set documento2 = '$documento2' where idclienti = '$idclienti' ");
} # fine if ($documento2)
if ($mesescaddoc and $giornoscaddoc and $annoscaddoc) {
$datascaddoc = $annoscaddoc."-".$mesescaddoc."-".$giornoscaddoc;
$datascaddoc = addslashes($datascaddoc);
esegui_query("update $tableclienti set scadenzadoc = '$datascaddoc' where idclienti = '$idclienti' ");
} # fine if ($mesescaddoc and ...
if ($mesescaddoc2 and $giornoscaddoc2 and $annoscaddoc2) {
$datascaddoc2 = $annoscaddoc2."-".$mesescaddoc2."-".$giornoscaddoc2;
$datascaddoc2 = addslashes($datascaddoc2);
esegui_query("update $tableclienti set scadenzadoc2 = '$datascaddoc2' where idclienti = '$idclienti' ");
} # fine if ($mesescaddoc2 and ...
if ($nazione) {
$nazione_maius = ucwords($nazione);
$nazione_maius = addslashes($nazione_maius);
esegui_query("update $tableclienti set nazione = '$nazione_maius' where idclienti = '$idclienti' ");
} # fine if ($nazione)
if ($citta) {
$citta_maius = ucwords($citta);
$citta_maius = addslashes($citta_maius);
esegui_query("update $tableclienti set citta = '$citta_maius' where idclienti = '$idclienti' ");
} # fine if ($citta)
if ($regione) {
$regione_maius = ucwords($regione);
$regione_maius = addslashes($regione_maius);
esegui_query("update $tableclienti set regione = '$regione_maius' where idclienti = '$idclienti' ");
} # fine if ($regione)
if ($nomevia) {
if ($lingua_mex != "ita") include("./includes/lang/$lingua_mex/ordine_frasi.php");
if ($ordine_strada == 2) $via = $nomevia . " " . $via;
else $via = $via . " " . $nomevia;
$via_maius = ucwords($via);
$via_maius = addslashes($via_maius);
esegui_query("update $tableclienti set via = '$via_maius' where idclienti = '$idclienti' ");
} # fine if ($nomevia)
$numcivico = addslashes($numcivico);
if ($numcivico) esegui_query("update $tableclienti set numcivico = '$numcivico' where idclienti = '$idclienti' ");
$cap = addslashes($cap);
if ($cap) esegui_query("update $tableclienti set cap = '$cap' where idclienti = '$idclienti' ");
$telefono = addslashes($telefono);
if ($telefono) esegui_query("update $tableclienti set telefono = '$telefono' where idclienti = '$idclienti' ");
$telefono2 = addslashes($telefono2);
if ($telefono2) esegui_query("update $tableclienti set telefono2 = '$telefono2' where idclienti = '$idclienti' ");
$telefono3 = addslashes($telefono3);
if ($telefono3) esegui_query("update $tableclienti set telefono3 = '$telefono3' where idclienti = '$idclienti' ");
$fax = addslashes($fax);
if ($fax) esegui_query("update $tableclienti set fax = '$fax' where idclienti = '$idclienti' ");
$email = addslashes($email);
if ($email) esegui_query("update $tableclienti set email = '$email' where idclienti = '$idclienti' ");
} # fine if ($idclienti == "")
else unset($idclienti);
unlock_tabelle($tabelle_lock);
} # fine if ($inserire)
} # fine else if ($inserire == "NO")

$inserire = "";
} # fine if ($inserire_dati_cliente == "SI")


# Se vi è $idclienti siamo già nella fase di inserimento.
if ($idclienti) {


$dati_transazione = recupera_dati_transazione($id_transazione,$id_sessione,$anno,"SI",$tipo_transazione);
if ($tipo_transazione != "ins_p") {
$torna_invece_di_ok = "SI";
$num_tipologie = 0;
echo "<font color=\"red\">".mex("Transazione scaduta",$pag)."</font>.<br>";
} # fine if ($tipo_transazione != "ins_p")
else {
$num_tipologie = risul_query($dati_transazione,0,dati_transazione1);
$inizioperiodo = explode(";",risul_query($dati_transazione,0,dati_transazione2));
$fineperiodo = explode(";",risul_query($dati_transazione,0,dati_transazione3));
$appartamento = explode(", ,",risul_query($dati_transazione,0,dati_transazione4));
$nometipotariffa = explode(",",risul_query($dati_transazione,0,dati_transazione5));
$numpersone = explode(",",risul_query($dati_transazione,0,dati_transazione6));
$assegnazioneapp = explode(",",risul_query($dati_transazione,0,dati_transazione7));
$num_app_richiesti = explode(",",risul_query($dati_transazione,0,dati_transazione8));
$lista_app = explode(", ,",risul_query($dati_transazione,0,dati_transazione9));
$spezzetta = explode(",",risul_query($dati_transazione,0,dati_transazione10));
for ($n_t = 1 ; $n_t <= $num_tipologie ; $n_t++) {
${"inizioperiodo".$n_t} = $inizioperiodo[($n_t - 1)];
${"fineperiodo".$n_t} = $fineperiodo[($n_t - 1)];
${"appartamento".$n_t} = $appartamento[($n_t - 1)];
${"nometipotariffa".$n_t} = $nometipotariffa[($n_t - 1)];
${"numpersone".$n_t} = $numpersone[($n_t - 1)];
${"assegnazioneapp".$n_t} = $assegnazioneapp[($n_t - 1)];
${"num_app_richiesti".$n_t} = $num_app_richiesti[($n_t - 1)];
${"lista_app".$n_t} = $lista_app[($n_t - 1)];
${"spezzetta".$n_t} = $spezzetta[($n_t - 1)];
} # fine for $n_t
if ($occ_app_agenzia == "SI") $spezzetta1 = "occ_app_agenzia";
else {
$dati_transazione12 = explode(", ,",risul_query($dati_transazione,0,dati_transazione12));
$n_tronchi1 = $dati_transazione12[0];
$vet_appartamenti_u = $dati_transazione12[1];
$vett_idinizio_u = $dati_transazione12[2];
$vett_idfine_u = $dati_transazione12[3];
} # fine else if ($occ_app_agenzia == "SI")
unset($inizioperiodo);
unset($fineperiodo);
unset($appartamento);
unset($nometipotariffa);
unset($numpersone);
unset($assegnazioneapp);
unset($num_app_richiesti);
unset($lista_app);
unset($spezzetta);
} # fine else if ($tipo_transazione != "ins_p")


if ($priv_ins_multiple != "s") {
$num_tipologie = 1;
$num_app_richiesti1 = 1;
} # fine if ($priv_ins_multiple != "s")


for ($n_t = 1 ; $n_t <= $num_tipologie ; $n_t++) {
$inizioperiodo = ${"inizioperiodo".$n_t};
$fineperiodo = ${"fineperiodo".$n_t};
$appartamento = ${"appartamento".$n_t};
$num_app_richiesti = ${"num_app_richiesti".$n_t};
$spezzetta = ${"spezzetta".$n_t};

if ($spezzetta) {

# Se si inseriscono più prenotazioni dello stesso tipo
if ($num_app_richiesti > 1 or $num_tipologie > 1) {
${"n_tronchi".$n_t} = $num_app_richiesti;
$vet_appartamenti_u = ",".$appartamento;
$vett_idinizio_u = ",".$inizioperiodo;
$vett_idfine_u = ",".$fineperiodo;
} # fine if ($num_app_richiesti > 1 or $num_tipologie > 1)

# Se esiste $n_tronchi si è deciso di andare avanti
if (${"n_tronchi".$n_t}) {
$vet_appartamenti[$n_t] = explode(",",$vet_appartamenti_u);
$vett_idinizio[$n_t] = explode(",",$vett_idinizio_u);
$vett_idfine[$n_t] = explode(",",$vett_idfine_u);
} # fine if (${"n_tronchi".$n_t})

else {
# Tento di spezzare la prenotazione solo se ne è stata richiesta una sola

${"assegnazioneapp".$n_t} = "v";
${"lista_app".$n_t} = "";
include("./includes/liberasettimane.php");
include("./includes/spezzaprenota.php");

$tabelle_lock = array("$tableprenota","$tabletransazioni");
$altre_tab_lock = array("$tableappartamenti","$tableperiodi","$tableregole","$tablepersonalizza");
$tabelle_lock = lock_tabelle($tabelle_lock,$altre_tab_lock);

# Se ci sono regole per $app_agenzia inserisco prenotazioni fisse in $app_prenota_id
# e controllo la situazione con spezzaprenota
$app_agenzia = esegui_query("select * from $tableregole where app_agenzia != ''");
$num_app_agenzia = numlin_query($app_agenzia);
if ($num_app_agenzia != 0 and $spezzetta != "occ_app_agenzia") {
unset($limiti_var);
unset($app_prenota_id);
unset($app_orig_prenota_id);
unset($inizio_prenota_id);
unset($fine_prenota_id);
unset($app_assegnabili_id);
unset($prenota_in_app_sett);
unset($dati_app);
unset($profondita);
$limiti_var[n_ini] = $inizioperiodo;
$limiti_var[n_fine] = $fineperiodo;
$profondita[iniziale] = "";
$profondita[attuale] = 1;
$max_prenota = esegui_query("select max(idprenota) from $tableprenota");
if (numlin_query($max_prenota) != 0) $tot_prenota = risul_query($max_prenota,0,0);
else $tot_prenota = 0;
$profondita[tot_prenota_ini] = $tot_prenota;
$profondita[tot_prenota_attuale] = $tot_prenota;
tab_a_var ($limiti_var,$app_prenota_id,$app_orig_prenota_id,$inizio_prenota_id,$fine_prenota_id,$app_assegnabili_id,$prenota_in_app_sett,$anno,$dati_app,$profondita,$PHPR_TAB_PRE."prenota");
$info_periodi[numero] = $num_app_agenzia;
for ($num1 = 0 ; $num1 < $num_app_agenzia ; $num1++) {
$info_periodi[app][$num1] = risul_query($app_agenzia,$num1,app_agenzia);
$info_periodi[ini][$num1] = risul_query($app_agenzia,$num1,iddatainizio);
$info_periodi[fine][$num1] = risul_query($app_agenzia,$num1,iddatafine);
} # fine for $num1
inserisci_prenota_fittizie ($info_periodi,$profondita,$app_prenota_id,$inizio_prenota_id,$fine_prenota_id,$prenota_in_app_sett,$app_assegnabili_id);

spezzaprenota ($inizioperiodo,$fineperiodo,$anno,$limiti_var,$profondita,$n_tronchi,$vet_appartamenti,$vett_idinizio,$vett_idfine,$num_persone,$app_prenota_id,$app_orig_prenota_id,$inizio_prenota_id,$fine_prenota_id,$app_assegnabili_id,$prenota_in_app_sett,$dati_app,$PHPR_TAB_PRE."prenota");

if ($n_tronchi != -1) {
aggiorna_tableprenota ($app_prenota_id,$app_orig_prenota_id,$tableprenota);
} # fine if ($n_tronchi != -1)

if ($n_tronchi != 1) {
$torna_invece_di_ok = "SI";
echo mex("Non si può inserire la prenozione senza utilizzare gli appartamenti della regola di assegnazione 1",$pag);
if ($n_tronchi > 1) {echo mex(" o spezzarla",$pag);}
echo ".<br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"prenota.php\">
<input type=\"hidden\" name=\"idclienti\" value=\"$idclienti\">
<input type=\"hidden\" name=\"origine\" value=\"$origine\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"occ_app_agenzia\" value=\"SI\">";
$manda_dati_assegnazione = "NO";
include ("./includes/dati_form_prenotazione.php");
echo "
<input class=\"sbutton\" type=\"submit\" name=\"utilizza\" value=\"".mex("Utilizza anche gli appartamenti della regola 1",$pag)."\"><br>
</form>";
if ($n_tronchi > 1) {
unset($vet_appartamenti_u);
unset($vett_idinizio_u);
unset($vett_idfine_u);
for ($num1 = 1 ; $num1 <= $n_tronchi ; $num1 = $num1 + 1) {
$vet_appartamenti_u = $vet_appartamenti_u . "," . $vet_appartamenti[$num1];
$vett_idinizio_u = $vett_idinizio_u . "," . $vett_idinizio[$num1];
$vett_idfine_u = $vett_idfine_u . "," . $vett_idfine[$num1];
} # fine for $num1
echo "<form accept-charset=\"utf-8\" method=\"post\" action=\"prenota.php\">
<input type=\"hidden\" name=\"idclienti\" value=\"$idclienti\">
<input type=\"hidden\" name=\"origine\" value=\"$origine\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">";
esegui_query("update $tabletransazioni set dati_transazione12 = '$n_tronchi, ,$vet_appartamenti_u, ,$vett_idinizio_u, ,$vett_idfine_u' where idtransazioni = '$id_transazione' and idsessione = '$id_sessione'");
$manda_dati_assegnazione = "NO";
include ("./includes/dati_form_prenotazione.php");
echo "
<input class=\"sbutton\" type=\"submit\" name=\"spezza_senza_app_agenzia\" value=\"".mex("Spezza la prenotazione in",$pag)." $n_tronchi ".mex("parti",$pag)."\">
(".mex("senza utilizzare gli appartamenti della regola 1",$pag).").<br>
</form>";
} # fine if ($n_tronchi > 1)
} # fine if ($n_tronchi != 1)
} # fine if ($num_app_agenzia != 0 and $spezzetta != "occ_app_agenzia")

# Se non vi sono regole per $app_agenzia o si è deciso di ignorarle.
if ($spezzetta == "occ_app_agenzia" or $num_app_agenzia == 0) {
unset($limiti_var);
unset($app_prenota_id);
unset($app_orig_prenota_id);
unset($inizio_prenota_id);
unset($fine_prenota_id);
unset($app_assegnabili_id);
unset($prenota_in_app_sett);
unset($dati_app);
unset($profondita);
$limiti_var[n_ini] = $inizioperiodo;
$limiti_var[n_fine] = $fineperiodo;
$profondita[iniziale] = "";
$profondita[attuale] = 1;
$max_prenota = esegui_query("select max(idprenota) from $tableprenota");
if (numlin_query($max_prenota) != 0) $tot_prenota = risul_query($max_prenota,0,0);
else $tot_prenota = 0;
$profondita[tot_prenota_ini] = $tot_prenota;
$profondita[tot_prenota_attuale] = $tot_prenota;
tab_a_var ($limiti_var,$app_prenota_id,$app_orig_prenota_id,$inizio_prenota_id,$fine_prenota_id,$app_assegnabili_id,$prenota_in_app_sett,$anno,$dati_app,$profondita,$PHPR_TAB_PRE."prenota");

spezzaprenota ($inizioperiodo,$fineperiodo,$anno,$limiti_var,$profondita,$n_tronchi,$vet_appartamenti,$vett_idinizio,$vett_idfine,$num_persone,$app_prenota_id,$app_orig_prenota_id,$inizio_prenota_id,$fine_prenota_id,$app_assegnabili_id,$prenota_in_app_sett,$dati_app,$PHPR_TAB_PRE."prenota");

if ($n_tronchi != -1) {
aggiorna_tableprenota ($app_prenota_id,$app_orig_prenota_id,$tableprenota);
} # fine if ($n_tronchi != -1)
else {
echo mex("Non é stato possibile dividere la prenotazione a causa del numero di persone",$pag).".<br>";
} # fine else if ($n_tronchi != -1)

if ($n_tronchi == 1) {
${"n_tronchi".$n_t} = 1;
$appartamento = $vet_appartamenti[1];
unset($vet_appartamenti);
unset($vett_idinizio);
unset($vett_idfine);
$vet_appartamenti[$n_t][1] = $appartamento;
$vett_idinizio[$n_t][1] = $inizioperiodo;
$vett_idfine[$n_t][1] = $fineperiodo;
} # fine if ($n_tronchi == 1)

if ($n_tronchi > 1) {
$torna_invece_di_ok = "SI";
for ($num1 = 1 ; $num1 <= $n_tronchi ; $num1 = $num1 + 1) {
$vet_appartamenti_u = $vet_appartamenti_u . "," . $vet_appartamenti[$num1];
$vett_idinizio_u = $vett_idinizio_u . "," . $vett_idinizio[$num1];
$vett_idfine_u = $vett_idfine_u . "," . $vett_idfine[$num1];
} # fine for $num1
echo mex("Non è possibile inserire la prenotazione senza",$pag)." <font color=\"red\">".mex("dividerla",$pag)."</font> ".mex("in",$pag)." <b>$n_tronchi</b> ".mex("parti",$pag).".<br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"prenota.php\">
<input type=\"hidden\" name=\"idclienti\" value=\"$idclienti\">
<input type=\"hidden\" name=\"origine\" value=\"$origine\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">";
esegui_query("update $tabletransazioni set dati_transazione12 = '$n_tronchi, ,$vet_appartamenti_u, ,$vett_idinizio_u, ,$vett_idfine_u' where idtransazioni = '$id_transazione' and idsessione = '$id_sessione'");
$manda_dati_assegnazione = "NO";
include ("./includes/dati_form_prenotazione.php");
echo "
<input class=\"sbutton\" type=\"submit\" name=\"spezza_senza_app_agenzia\" value=\"".mex("Spezza la prenotazione in",$pag)." $n_tronchi ".mex("parti",$pag)."\"><br>
</form>";
} # fine if ($n_tronchi > 1)
} # fine if ($spezzetta == "occ_app_agenzia" or $num_app_agenzia == 0)

unlock_tabelle($tabelle_lock);

} # fine else if (${"n_tronchi".$n_t})
} # fine if ($spezzetta)


else {
${"n_tronchi".$n_t} = 1;
$vet_appartamenti[$n_t][1] = $appartamento;
$vett_idinizio[$n_t][1] = $inizioperiodo;
$vett_idfine[$n_t][1] = $fineperiodo;
} # fine else if ($spezzetta)

} # fine for $n_t



if (!$torna_invece_di_ok) {


if ($idmessaggi) $tabelle_lock = array("$tableprenota","$tablecostiprenota","$tablemessaggi");
else $tabelle_lock = array("$tableprenota","$tablecostiprenota");
$altre_tab_lock = array("$tablenometariffe","$tableperiodi","$tableappartamenti","$tableclienti","$tableregole","$tablepersonalizza");
$tabelle_lock = lock_tabelle($tabelle_lock,$altre_tab_lock);
$continuare = "SI";

$idclienti = htmlentities($idclienti);
$idclienti = str_replace(htmlentities(mex("Utilizza il cliente","clienti.php"))." ","",$idclienti);
$idclienti = str_replace(mex("Utilizza il cliente","clienti.php")." ","",$idclienti);
$idclienti = str_replace(" ".htmlentities(mex("per la prenotazione","clienti.php")),"",$idclienti);
$idclienti = str_replace(" ".mex("per la prenotazione","clienti.php"),"",$idclienti);
$datainserimento = date("Y-m-d H:i:s",(time() + (C_DIFF_ORE * 3600)));
$idclienti = addslashes($idclienti);
$dati_cliente = esegui_query("select * from $tableclienti where idclienti = '$idclienti'");
if (numlin_query($dati_cliente) == 0) $continuare = "NO";
else {
$cognome = risul_query($dati_cliente,0,cognome);
$utente_inserimento_cliente = risul_query($dati_cliente,0,utente_inserimento);
if ($inserito_nuovo_cliente == "NO" and ($vedi_clienti == "NO" or ($vedi_clienti == "PROPRI" and $utente_inserimento_cliente != $id_utente))) $continuare = "NO";
} # fine else if (numlin_query($dati_cliente) == 0)

unset ($num_costi_presenti);
$rigatariffe = esegui_query("select nomecostoagg from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
include("./includes/funzioni_costi_agg.php");
$dati_ca = dati_costi_agg_ntariffe($tablenometariffe,$numero_tariffe);

for ($n_t = 1 ; $n_t <= $num_tipologie ; $n_t++) {
$numpersone = ${"numpersone".$n_t};
unset(${"num_letti_agg".$n_t});
$n_tronchi = ${"n_tronchi".$n_t};
for ($numca = 1 ; $numca <= $numcostiagg ; $numca++) {
${"costoagg".$numca} = addslashes(${"costoagg".$numca."_".$n_t});
${"idcostoagg".$numca} = addslashes(${"idcostoagg".$numca."_".$n_t});
${"numsettimane".$numca} = addslashes(${"numsettimane".$numca."_".$n_t});
${"nummoltiplica_ca".$numca} = addslashes(${"nummoltiplica_ca".$numca."_".$n_t});
${"id_periodi_costo".$numca} = addslashes(${"id_periodi_costo".$numca."_".$n_t});
} # fine for $numca

for ($num1 = 1 ; $num1 <= $n_tronchi ; $num1 = $num1 + 1) {
$appartamento = $vet_appartamenti[$n_t][$num1];
$inizioperiodo = $vett_idinizio[$n_t][$num1];
$idinizioperiodo = $inizioperiodo;
$fineperiodo = $vett_idfine[$n_t][$num1];
$idfineperiodo = $fineperiodo;
$data_inizio = esegui_query("select * from  $tableperiodi where idperiodi = '$inizioperiodo'");
$data_inizio = risul_query($data_inizio,0,datainizio);
$data_inizio_f[$n_t] = formatta_data($data_inizio,$stile_data);
$data_fine = esegui_query("select * from  $tableperiodi where idperiodi = '$fineperiodo'");
$data_fine = risul_query($data_fine,0,datafine);
$data_fine_f[$n_t] = formatta_data($data_fine,$stile_data);
$lunghezza_periodo = $fineperiodo - $inizioperiodo + 1;

$prenota_gia_esistente = esegui_query("select * from $tableprenota where idappartamenti = '$appartamento' and iddatainizio <= $fineperiodo and iddatafine >= $inizioperiodo");
$prenota_gia_esistente = numlin_query($prenota_gia_esistente);
if ($prenota_gia_esistente != 0) {
echo "<br><font color=\"red\"><b>".mex("Non si è potuto inserire la prenotazione a nome di",$pag)." $cognome ".mex("dal",$pag)." ".$data_inizio_f[$n_t]." ".mex("al",$pag)." ".$data_fine_f[$n_t]."
 ".mex("perchè il database è stato modificato nel frattempo",$pag).".</b></font><br><hr width=\"95%\">";
$continuare = "NO";
} # fine if ($prenota_gia_esistente != 0)

if ($priv_ins_periodi_passati != "s") {
$id_periodo_corrente = calcola_id_periodo_corrente($anno);
if ($id_periodo_corrente >= $inizioperiodo) $continuare = "NO";
} # fine if ($priv_ins_periodi_passati != "s")
if ($fineperiodo < $inizioperiodo) $continuare = "NO";

if ($priv_ins_num_persone != "s") unset($numpersone);
if ($numpersone and controlla_num_pos($numpersone) != "SI") $continuare = "NO";
${"numpersone".$n_t} = $numpersone;

$appartamento_esistente = esegui_query("select idappartamenti,maxoccupanti from $tableappartamenti where idappartamenti = '$appartamento'");
if (numlin_query($appartamento_esistente) != 1) {
echo "<br><font color=\"red\"><b>".mex("Non si è potuto inserire la prenotazione a nome di",$pag)." $cognome ".mex("dal",$pag)." ".$data_inizio_f[$n_t]." ".mex("al",$pag)." ".$data_fine_f[$n_t]."
 ".mex("perchè l'appartamento assegnato non esiste più",$pag).".</b></font><br><hr width=\"95%\">";
$continuare = "NO";
} # fine if (numlin_query($appartamento_esistente) != 1)
else {
$maxoccupanti = risul_query($appartamento_esistente,0,maxoccupanti);
if ($maxoccupanti and $numpersone > $maxoccupanti) $continuare = "NO";
} # fine else if (numlin_query($appartamento_esistente) != 1)

if (${"assegnazioneapp".$n_t} == "c" and str_replace(",".$appartamento.",","",",".${"lista_app".$n_t}.",") == ",".${"lista_app".$n_t}.",") $continuare = "NO";

if ($attiva_regole1_consentite == "s") {
if (${"assegnazioneapp".$n_t} != "k" and ${"assegnazioneapp".$n_t} != "c") $continuare = "NO";
if (${"assegnazioneapp".$n_t} == "k") $appartameti_in_lista[0] = $appartamento;
if (${"assegnazioneapp".$n_t} == "c") $appartameti_in_lista = explode(",",${"lista_app".$n_t});
for ($n_lista = 0 ; $n_lista < count($appartameti_in_lista) ; $n_lista++) {
$appartamento_lista = $appartameti_in_lista[$n_lista];
$motivazioni_regola1 = esegui_query("select motivazione,iddatainizio,iddatafine from $tableregole where iddatainizio <= '$fineperiodo' and iddatafine >= '$inizioperiodo' and app_agenzia = '$appartamento_lista' order by iddatainizio");
if (numlin_query($motivazioni_regola1) == 0) $continuare = "NO";
else {
unset($motivazioni_consentite);
for ($num2 = 0 ; $num2 < count($regole1_consentite) ; $num2++) $motivazioni_consentite[$regole1_consentite[$num2]] = "SI";
$iddatainizio_regole_tot = risul_query($motivazioni_regola1,0,iddatainizio);
$iddatafine_regole_tot = risul_query($motivazioni_regola1,0,iddatafine);
$motivazione = risul_query($motivazioni_regola1,0,motivazione);
if (!$motivazione) $motivazione = " ";
if (!$motivazioni_consentite[$motivazione]) $continuare = "NO";
for ($num2 = 1 ; $num2 < numlin_query($motivazioni_regola1) ; $num2++) {
$motivazione = risul_query($motivazioni_regola1,$num2,motivazione);
if (!$motivazione) $motivazione = " ";
if (!$motivazioni_consentite[$motivazione]) $continuare = "NO";
$iddatainizio_regola = risul_query($motivazioni_regola1,$num2,iddatainizio);
if ($iddatainizio_regola == ($iddatafine_regole_tot + 1)) $iddatafine_regole_tot = risul_query($motivazioni_regola1,$num2,iddatafine);
else $continuare = "NO";
} # fine for $num2
if ($iddatainizio_regole_tot > $inizioperiodo or $iddatafine_regole_tot < $fineperiodo) $continuare = "NO";
} # fine else if (numlin_query($motivazioni_regola1) == 0)
} # fine for $n_lista
} # fine if ($attiva_regole1_consentite == "s")

if (($attiva_tariffe_consentite == "s" and $tariffe_consentite_vett[substr(${"nometipotariffa".$n_t},7)] != "SI") or substr(${"nometipotariffa".$n_t},0,7) != "tariffa") $continuare = "NO";
for ($num2 = $inizioperiodo; $num2 <= $fineperiodo; $num2++) {
$rigasettimana = esegui_query("select * from $tableperiodi where idperiodi = '$num2' ");
$esistetariffa = risul_query($rigasettimana,0,${"nometipotariffa".$n_t});
if ($esistetariffa == "") $continuare = "NO";
} # fine for $num2

$costi_aggiuntivi_sbagliati = "NO";
unset($id_costi_presenti);
${"numcostiagg_".$n_t."t".$num1} = $numcostiagg;
for ($num2 = 0 ; $num2 < $dati_ca[num] ; $num2++) {
if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$dati_ca[$num2][id]] == "SI") {
if ($dati_ca[$num2]["tipo_associa_".${"nometipotariffa".$n_t}] == "s") {
if (associa_costo_a_tariffa($dati_ca,$num2,${"nometipotariffa".$n_t},$lunghezza_periodo) != "SI") $costi_aggiuntivi_sbagliati = "SI";
else {
${"numcostiagg_".$n_t."t".$num1}++;
${"costoagg".(${"numcostiagg_".$n_t."t".$num1})} = "SI";
${"idcostoagg".(${"numcostiagg_".$n_t."t".$num1})} = $dati_ca[$num2][id];
} # fine else if (associa_costo_a_tariffa($dati_ca,$num2,${"nometipotariffa".$n_t},$lunghezza_periodo) != "SI")
} # fine if ($dati_ca[$num2]["tipo_associa_".$nometipotariffa] == "s")
} # fine if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$dati_ca[$num2][id]] == "SI")
} # fine for $num2
for ($numca = 1 ; $numca <= ${"numcostiagg_".$n_t."t".$num1} ; $numca++) {
$costoagg = "costoagg".$numca;
$idcostoagg = "idcostoagg".$numca;
if (($priv_ins_costi_agg != "s" and $numca <= $numcostiagg) or ($attiva_costi_agg_consentiti != "n" and $costi_agg_consentiti_vett[$$idcostoagg] != "SI")) $$costoagg = "";
${"costoagg".$numca."_".$n_t."t".$num1} = $$costoagg;
if ($$costoagg == "SI") {
$numsettimane = "numsettimane".$numca;
$nummoltiplica_ca = "nummoltiplica_ca".$numca;
${"idcostoagg".$numca."_".$n_t."t".$num1} = $$idcostoagg;
$id_periodi_costo = "id_periodi_costo".$numca;
$num_costo = $dati_ca[id][$$idcostoagg];
if ($$idcostoagg != $dati_ca[$num_costo][id]) $costi_aggiuntivi_sbagliati = "SI";
if ($id_costi_presenti[$idcostoagg] == "SI" or ($dati_ca[$num_costo][mostra] != "s" and $numca <= $numcostiagg)) $costi_aggiuntivi_sbagliati = "SI";
$id_costi_presenti[$idcostoagg] = "SI";
if ($dati_ca[$num_costo]["incomp_".${"nometipotariffa".$n_t}] == "i") $costi_aggiuntivi_sbagliati = "SI";
if (($$numsettimane and controlla_num_pos($$numsettimane) == "NO") or ($$nummoltiplica_ca and controlla_num_pos($$nummoltiplica_ca) == "NO")) $costi_aggiuntivi_sbagliati = "SI";
else {
if ($$numsettimane) {
$totsettimane = $idfineperiodo - $idinizioperiodo + 1 ;
if ($$numsettimane > $totsettimane) {
if ($num1 == $n_tronchi) $costi_aggiuntivi_sbagliati = "SI";
else $numsettimane_tronco = $totsettimane;
} # fine if ($$numsettimane > $totsettimane)
else $numsettimane_tronco = $$numsettimane;
$$numsettimane = $$numsettimane - $numsettimane_tronco;
} # fine if ($$numsettimane)
} # fine else if (($$numsettimane and controlla_num_pos($$numsettimane) == "NO") or...
#if ($dati_ca[$num_costo][tipo_val] == "q") {
#if ($costo_totale_presente == "SI") $costi_aggiuntivi_sbagliati = "SI";
#$costo_totale_presente = "SI";
#} # fine if ($dati_ca[$num_costo][tipo_val] == "q")
${"settimane_costo".$numca."_".$n_t."t".$num1} = calcola_settimane_costo($tableperiodi,$dati_ca,$num_costo,$idinizioperiodo,$idfineperiodo,$$id_periodi_costo,$numsettimane_tronco);
if (!${"settimane_costo".$numca."_".$n_t."t".$num1} and $dati_ca[$num_costo][tipo] == "s" and $dati_ca[$num_costo][var_numsett] == "n") ${"costoagg".$numca."_".$n_t."t".$num1} = "";
$periodo_costo_trovato = trova_periodo_permesso_costo($dati_ca,$num_costo,$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1});
if ($periodo_costo_trovato == "NO") $costi_aggiuntivi_sbagliati = "SI";
if (($dati_ca[$num_costo][moltiplica] == "p" or $dati_ca[$num_costo][moltiplica] == "t") and !$numpersone) $costi_aggiuntivi_sbagliati = "SI";
aggiorna_letti_agg_in_periodi($dati_ca,$num_costo,${"num_letti_agg".$n_t},$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1},"",$$nummoltiplica_ca,$numpersone);
} # fine if ($$costoagg == "SI")
} # fine for $numca

for ($numca = 1 ; $numca <= ${"numcostiagg_".$n_t."t".$num1} ; $numca++) {
if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI") {
$idcostoagg = "idcostoagg".$numca;
$num_costo = $dati_ca[id][$$idcostoagg];
calcola_moltiplica_costo($dati_ca,$num_costo,${"moltiplica".$numca."_".$n_t."t".$num1},$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1},${"nummoltiplica_ca".$numca},$numpersone,${"num_letti_agg".$n_t});
if (controlla_num_limite_costo($tablecostiprenota,$tableprenota,$dati_ca,$num_costo,$num_costi_presenti,$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1},${"moltiplica".$numca."_".$n_t."t".$num1}) == "NO") $costi_aggiuntivi_sbagliati = "SI";
} # fine if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI")
} # fine for $numca

if ($costi_aggiuntivi_sbagliati == "SI") {
echo "<br><font color=\"red\"><b>".mex("Non si è potuto inserire un costo aggiuntivo della prenotazione a nome di",$pag)." $cognome ".mex("dal",$pag)." ".$data_inizio_f[$n_t]." ".mex("al",$pag)." ".$data_fine_f[$n_t]."
 ".mex("perchè il database è stato modificato nel frattempo",$pag).".</b></font><br><hr width=\"95%\">";
$continuare = "NO";
} # fine if ($costi_aggiuntivi_sbagliati == "SI")

else {
if (!$numpersone) $numpersone_costi_poss = 0;
else $numpersone_costi_poss = $numpersone;
for ($num_costo = 0 ; $num_costo < $dati_ca[num] ; $num_costo++) {
if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$dati_ca[$num_costo][id]] == "SI") {
$associa_costo = associa_costo_a_tariffa($dati_ca,$num_costo,${"nometipotariffa".$n_t},$lunghezza_periodo);
if ($associa_costo == "SI" and $dati_ca[$num_costo]["tipo_associa_".${"nometipotariffa".$n_t}] == "p") {
#if ($dati_ca[$num_costo][tipo_val] == "q" and $costo_totale_presente = "SI") $associa_costo = "NO";
$settimane_costo = calcola_settimane_costo($tableperiodi,$dati_ca,$num_costo,$idinizioperiodo,$idfineperiodo,"","");
$num_letti_agg_copia = ${"num_letti_agg".$n_t};
if ($dati_ca[$num_costo][letto] == "s") {
aggiorna_letti_agg_in_periodi($dati_ca,$num_costo,$num_letti_agg_copia,$idinizioperiodo,$idfineperiodo,$settimane_costo,"","",$numpersone_costi_poss);
unset($moltiplica_copia);
unset($num_costi_presenti_copia);
for ($numca = 1 ; $numca <= ${"numcostiagg_".$n_t."t".$num1} ; $numca++) {
if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI") {
$num_costo2 = $dati_ca[id][${"idcostoagg".$numca}];
if ($dati_ca[$num_costo2][moltiplica] != "t") $moltiplica_copia[$numca] = ${"moltiplica".$numca."_".$n_t."t".$num1};
else calcola_moltiplica_costo($dati_ca,$num_costo2,$moltiplica_copia[$numca],$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1},"",$numpersone,$num_letti_agg_copia);
if (controlla_num_limite_costo($tablecostiprenota,$tableprenota,$dati_ca,$num_costo2,$num_costi_presenti_copia,$idinizioperiodo,$idfineperiodo,${"settimane_costo".$numca."_".$n_t."t".$num1},$moltiplica_copia[$numca]) == "NO") $associa_costo = "NO";
} # fine if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI")
} # fine for $numca
} # fine if ($dati_ca[$num_costo][letto] == "s")
else $num_costi_presenti_copia = $num_costi_presenti;
calcola_moltiplica_costo($dati_ca,$num_costo,$moltiplica,$idinizioperiodo,$idfineperiodo,$settimane_costo,"",$numpersone_costi_poss,$num_letti_agg_copia);
$periodo_costo_trovato = trova_periodo_permesso_costo($dati_ca,$num_costo,$idinizioperiodo,$idfineperiodo,$settimane_costo);
if ($periodo_costo_trovato == "NO") $associa_costo = "NO";
else if (controlla_num_limite_costo($tablecostiprenota,$tableprenota,$dati_ca,$num_costo,$num_costi_presenti_copia,$idinizioperiodo,$idfineperiodo,$settimane_costo,$moltiplica) == "NO") $associa_costo = "NO";
if ($associa_costo == "SI") {
if ($dati_ca[$num_costo][letto] == "s") {
$num_costi_presenti = $num_costi_presenti_copia;
${"num_letti_agg".$n_t} = $num_letti_agg_copia;
for ($numca = 1 ; $numca <= ${"numcostiagg_".$n_t."t".$num1} ; $numca++) ${"moltiplica".$numca."_".$n_t."t".$num1} = $moltiplica_copia[$numca];
} # fine if ($dati_ca[$num_costo][letto] == "s")
${"numcostiagg_".$n_t."t".$num1}++;
$numca = ${"numcostiagg_".$n_t."t".$num1};
${"costoagg".$numca."_".$n_t."t".$num1} = "SI";
${"idcostoagg".$numca."_".$n_t."t".$num1} = $dati_ca[$num_costo][id];
${"settimane_costo".$numca."_".$n_t."t".$num1} = $settimane_costo;
${"moltiplica".$numca."_".$n_t."t".$num1} = $moltiplica;
} # fine if ($associa_costo == "SI")
} # fine if ($associa_costo == "SI" and $dati_ca[$num_costo]["tipo_associa_".${"nometipotariffa".$n_t}] == "p")
} # fine if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$dati_ca[$num_costo][id]] == "SI")
} # fine for $num_costo
} # fine else if ($costi_aggiuntivi_sbagliati == "SI")


} # fine for $num1
} # fine for $n_t


if ($idmessaggi) {
$mess_esistente = esegui_query("select dati_messaggio2 from $tablemessaggi where tipo_messaggio = 'rprenota' and idutenti $LIKE '%,$id_utente,%' and idmessaggi = '".addslashes($idmessaggi)."' and dati_messaggio1 = 'da_inserire' ");
if (numlin_query($mess_esistente) != 1) {
echo "<br><font color=\"red\"><b>".mex("Le prenotazioni richieste nel messaggio sono già state inserite",$pag).".</b></font><br>";
$continuare = "NO";
} # fine if (numlin_query($mess_esistente) != 1)
else {
$dati_mess_calc = risul_query($mess_esistente,0,"dati_messaggio2");
$dati_mess_calc = explode(",",$dati_mess_calc);
} # fine else if (numlin_query($mess_esistente) != 1)
} # fine if ($idmessaggi)

if ($continuare == "NO") {
echo "<br>".mex("Nessuna nuova prenotazione è stata inserita",$pag).".<br><br>";
$torna_invece_di_ok = "SI";
} # fine if ($continuare == "NO")



if ($continuare != "NO") {
$lista_idprenota = "";
$costo_tot_mess = (double) 0;
$caparra_mess = (double) 0;

for ($n_t = 1 ; $n_t <= $num_tipologie ; $n_t++) {
$nometipotariffa = ${"nometipotariffa".$n_t};
$numpersone = ${"numpersone".$n_t};
$assegnazioneapp = ${"assegnazioneapp".$n_t};
$sconto = ${"sconto".$n_t};
$giorno_stima_checkin = ${"giorno_stima_checkin".$n_t};
$ora_stima_checkin = ${"ora_stima_checkin".$n_t};
$min_stima_checkin = ${"min_stima_checkin".$n_t};
$met_paga_caparra = ${"met_paga_caparra".$n_t};
$conferma_prenota = ${"conferma_prenota".$n_t};
$commento = ${"commento".$n_t};
$lista_app = ${"lista_app".$n_t};
$caparra = ${"caparra".$n_t};
$n_tronchi = ${"n_tronchi".$n_t};

if (@get_magic_quotes_gpc()) {
$met_paga_caparra = stripslashes($met_paga_caparra);
$commento = stripslashes($commento);
} # fine if (@get_magic_quotes_gpc())
$met_paga_caparra = htmlspecialchars($met_paga_caparra);
$commento = htmlspecialchars($commento);

for ($num1 = 1 ; $num1 <= $n_tronchi ; $num1 = $num1 + 1) {
$appartamento = $vet_appartamenti[$n_t][$num1];
$inizioperiodo = $vett_idinizio[$n_t][$num1];
$fineperiodo = $vett_idfine[$n_t][$num1];
$lunghezza_periodo = $fineperiodo - $inizioperiodo + 1;

$idprenota = esegui_query("select numlimite from $tablecostiprenota where idcostiprenota = '1'");
$idprenota = risul_query($idprenota,0,numlimite);
esegui_query("update $tablecostiprenota set numlimite = '".($idprenota + 1)."' where idcostiprenota = '1'");

echo mex("Prenotazione",$pag)." $idprenota ".mex("dal",$pag)." <b>".$data_inizio_f[$n_t]."</b> ".mex("al",$pag)." <b>".$data_fine_f[$n_t]."</b> ($lunghezza_periodo ".mex("$parola_settiman",$pag);
if ($lunghezza_periodo == 1) { echo mex("$lettera_a",$pag); }
else { echo mex("$lettera_e",$pag); }
echo ") ".mex("a nome di",$pag)." <b>$cognome</b> ";
if ($numpersone) echo mex("per",$pag)." <b>$numpersone</b> ".mex("persone",$pag)." ";
echo mex("nell'appartamento",$pag)." <b>$appartamento</b>";
if ($assegnazioneapp == "k") { echo " (".mex("fisso",$pag).")"; }
else {
echo " (".mex("mobile",$pag);
if ($lista_app) echo " ".mex("in",$pag)." ".str_replace(",",", ",$lista_app);
echo ")";
} # fine else if ($assegnazioneapp == "K")
echo ":<br><br>";

$costo_tariffa_tot = (double) 0;
unset($lista_tariffe_sett);
unset($tariffe_sett_vett);
for ($num2 = $inizioperiodo ; $num2 <= $fineperiodo ; $num2++) {
$costo_tariffa = esegui_query("select * from  $tableperiodi where idperiodi = $num2");
$costo_tariffa = risul_query($costo_tariffa,0,$nometipotariffa);
$costo_tariffa_tot = (double) $costo_tariffa_tot + (double) $costo_tariffa;
$lista_tariffe_sett .= ",".$costo_tariffa;
} # fine for $num2
$lista_tariffe_sett = substr($lista_tariffe_sett,1);
$costo_tariffa = $costo_tariffa_tot;
$nometariffa = esegui_query("select * from $tablenometariffe where idntariffe = 1");
$nometariffa = risul_query($nometariffa,0,$nometipotariffa);
if ($nometariffa == "") {
$nometariffa = $nometipotariffa;
$nometariffa_vedi = mex("tariffa",$pag).substr($nometipotariffa,7);
} # fine if ($nometariffa == "")
else $nometariffa_vedi = $nometariffa;
$nometariffa = addslashes($nometariffa);
$tariffa = $nometariffa."#@&".$costo_tariffa_tot;
$costo_tariffa_tot_p = punti_in_num($costo_tariffa_tot,$stile_soldi);
echo "$costo_tariffa_tot_p $Euro &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".mex("tariffa",$pag)." \"$nometariffa_vedi\"<br>";
$valori = "abcdefghijkmnpqrstuvwxz";
srand((double)microtime() * 1000000);
unset($cod_prenota);
for ($num2 = 0 ; $num2 < 4 ; $num2++) $cod_prenota .= substr($valori,rand(0,22),1);

esegui_query("insert into $tableprenota (idprenota,idclienti,idappartamenti,iddatainizio,iddatafine,tariffa,tariffesettimanali,codice,conferma,datainserimento,hostinserimento,utente_inserimento) values ('$idprenota','$idclienti','$appartamento','$inizioperiodo','$fineperiodo','$tariffa','$lista_tariffe_sett','$cod_prenota','N','$datainserimento','$HOSTNAME','$id_utente_ins')");

if ($numpersone and $priv_ins_num_persone == "s") {
esegui_query("update $tableprenota set num_persone = '$numpersone' where idprenota = '$idprenota' ");
} # fine if ($numpersone and $priv_ins_num_persone == "s")

$caparra = formatta_soldi($caparra);
if ($priv_ins_caparra != "s" or controlla_soldi($caparra,"pos") == "NO") unset($caparra);
if (!$caparra) {
$righe_caparra = esegui_query("select * from $tablenometariffe where idntariffe = 2 or idntariffe = 3 order by idntariffe");
$caparra_percent = risul_query($righe_caparra,0,$nometipotariffa);
if ($caparra_percent) {
$caparra_arrotond = risul_query($righe_caparra,1,$nometipotariffa);
$caparra = ($costo_tariffa_tot*$caparra_percent)/100;
$caparra = $caparra/$caparra_arrotond;
$caparra = floor($caparra);
$caparra = $caparra*$caparra_arrotond;
} # fine if ($caparra_percent)
} # fine if (!$caparra)

for ($num_costo = 0 ; $num_costo < $dati_ca[num] ; $num_costo++) {
$idcostoagg = $dati_ca[$num_costo][id];
$costo_trovato = "NO";
for ($numca = 1 ; $numca <= ${"numcostiagg_".$n_t."t".$num1} ; $numca++) if ($idcostoagg == ${"idcostoagg".$numca."_".$n_t."t".$num1}) $costo_trovato = $numca;
if ($costo_trovato != "NO") {
$numca = $costo_trovato;
if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI") {
if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$idcostoagg] == "SI") {
$settimane_costo = ${"settimane_costo".$numca."_".$n_t."t".$num1};
$moltiplica = ${"moltiplica".$numca."_".$n_t."t".$num1};
$idcostiprenota = esegui_query("select max(idcostiprenota) from $tablecostiprenota");
$idcostiprenota = risul_query($idcostiprenota,0,0) + 1;
$tipo_ca = $dati_ca[$num_costo][tipo].$dati_ca[$num_costo][tipo_val];
$valore_ca = $dati_ca[$num_costo][valore];
$prezzo_costo_tot = calcola_prezzo_totale_costo($dati_ca,$num_costo,$inizioperiodo,$fineperiodo,$settimane_costo,$moltiplica,$costo_tariffa,$lista_tariffe_sett,$costo_tariffa_tot,$caparra);
$associasett_ca = $dati_ca[$num_costo][associasett];
if ($dati_ca[$num_costo][var_percentuale] != "s" and $dati_ca[$num_costo][tipo_val] != "f") {
$tipo_ca = $dati_ca[$num_costo][tipo]."f";
$moltiplica = 1;
if ($dati_ca[$num_costo][tipo] == "s") {
$settimane_costo = 1;
$associasett_ca = "n";
} # fine if ($dati_ca[$num_costo][tipo] == "s")
$valore_ca = $prezzo_costo_tot;
} # fine if ($dati_ca[$num_costo][var_percentuale] != "s" and...
if ($dati_ca[$num_costo][var_moltiplica] == "s") $varmoltiplica_ca = $dati_ca[$num_costo][moltiplica];
else $varmoltiplica_ca = "c";
if ($dati_ca[$num_costo][var_numsett] == "s") $varnumsett_ca = $dati_ca[$num_costo][numsett_orig];
else $varnumsett_ca = "c";
if ($dati_ca[$num_costo][var_periodip] == "s") $varperiodipermessi_ca = $dati_ca[$num_costo][periodipermessi_orig];
else $varperiodipermessi_ca = "";
if ($dati_ca[$num_costo][var_tariffea] == "s") $vartariffeassociate_ca = $dati_ca[$num_costo]["tipo_associa_".${"nometipotariffa".$n_t}].$dati_ca[$num_costo][${"nometipotariffa".$n_t}];
else $vartariffeassociate_ca = "";
$vartariffeincomp_ca = "";
if ($dati_ca[$num_costo][var_tariffei] == "s") {
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa++) {
if ($dati_ca[$num_costo]["incomp_tariffa".$numtariffa] == "i") $vartariffeincomp_ca .= ",".$numtariffa;
} # fine for $numtariffa
if ($vartariffeincomp_ca) $vartariffeincomp_ca = substr($vartariffeincomp_ca,1);
} # fine if ($dati_ca[$num_costo][var_tariffei] == "s")
esegui_query("insert into $tablecostiprenota (idcostiprenota,idprenota,tipo,nome,valore,associasett,settimane,moltiplica,letto,idntariffe,varmoltiplica,varnumsett,varperiodipermessi,vartariffeassociate,vartariffeincomp,datainserimento,hostinserimento,utente_inserimento) values ('$idcostiprenota','$idprenota','$tipo_ca','".addslashes($dati_ca[$num_costo][nome])."','$valore_ca','$associasett_ca','$settimane_costo','$moltiplica','".$dati_ca[$num_costo][letto]."','$idcostoagg','$varmoltiplica_ca','$varnumsett_ca','$varperiodipermessi_ca','$vartariffeassociate_ca','$vartariffeincomp_ca','$datainserimento','$HOSTNAME','$id_utente_ins')");
if (substr($tipo_ca,1,1) != "f") esegui_query("update $tablecostiprenota set arrotonda = '".$dati_ca[$num_costo][arrotonda]."' where idcostiprenota = '$idcostiprenota'");
$id_costo_inserito[$idcostoagg] = $idcostiprenota;
$prezzo_costo_tot_p = punti_in_num($prezzo_costo_tot,$stile_soldi);
echo "$prezzo_costo_tot_p $Euro &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ";
if ($dati_ca[$num_costo][tipo] == "u") echo mex("Costo unico",$pag);
if ($dati_ca[$num_costo][tipo] == "s") echo mex("Costo $parola_settimanale",$pag);
echo " \"".$dati_ca[$num_costo][nome]."\"";
if ($associasett_ca == "s") {
$moltiplica = explode(",",$moltiplica);
$valnummoltiplica_ca = $moltiplica[1];
for ($num2 = 2 ; $num2 < (count($moltiplica) - 1) ; $num2++) if ($moltiplica[$num2] != $valnummoltiplica_ca) $valnummoltiplica_ca = 1;
} # fine if ($associasett_ca == "s")
else $valnummoltiplica_ca = $moltiplica;
if ($valnummoltiplica_ca != 1) echo " (".mex("moltiplicato per",$pag)." $valnummoltiplica_ca)";
echo "<br>";
$costo_tariffa_tot = (double) $costo_tariffa_tot + (double) $prezzo_costo_tot;
} # fine if ($attiva_costi_agg_consentiti == "n" or...
} # fine if (${"costoagg".$numca."_".$n_t."t".$num1} == "SI")
} # fine if ($costo_trovato != "NO")
} # fine for $num_costo

$sconto = (double) formatta_soldi($sconto);
if ($sconto and $priv_ins_sconto == "s" and controlla_soldi($sconto,"pos") == "SI") {
if ($sconto > $costo_tariffa_tot) $sconto = $costo_tariffa_tot;
esegui_query("update $tableprenota set sconto = '$sconto' where idprenota = '$idprenota' ");
$sconto_p = punti_in_num($sconto,$stile_soldi);
echo "-$sconto_p $Euro &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".mex("Sconto",$pag)."<br>";
$costo_tariffa_tot = (double) $costo_tariffa_tot - (double) $sconto;
} # fine if ($sconto and $priv_ins_sconto == "s" and...

esegui_query("update $tableprenota set tariffa_tot = '$costo_tariffa_tot' where idprenota = '$idprenota' ");
$costo_tariffa_tot_p = punti_in_num($costo_tariffa_tot,$stile_soldi);
echo "<b>$costo_tariffa_tot_p $Euro &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".mex("TOTALE",$pag)."</b><br>";

if ($lista_app) {
esegui_query("update $tableprenota set app_assegnabili = '$lista_app' where idprenota = '$idprenota' ");
} # fine if ($lista_app)

if ($assegnazioneapp) {
esegui_query("update $tableprenota set assegnazioneapp = '$assegnazioneapp' where idprenota = '$idprenota' ");
} # fine if ($assegnazioneapp)

if ($caparra) {
if ($caparra > $costo_tariffa_tot) { $caparra = $costo_tariffa_tot; }
esegui_query("update $tableprenota set caparra = '$caparra' where idprenota = '$idprenota' ");
$da_pagare = $costo_tariffa_tot - $caparra;
$caparra_p = punti_in_num($caparra,$stile_soldi);
$da_pagare_p = punti_in_num($da_pagare,$stile_soldi);
echo "<br>".mex("Caparra",$pag).": <b>$caparra_p</b> $Euro (".mex("resto da pagare",$pag).": $da_pagare_p $Euro).<br>";
} # fine if ($caparra)

if ($met_paga_caparra and $priv_ins_caparra == "s") {
$metodi_pagamento = esegui_query("select valpersonalizza from $tablepersonalizza where idpersonalizza = 'metodi_pagamento' and idutente = '$id_utente'");
$metodi_pagamento = risul_query($metodi_pagamento,0,valpersonalizza);
if ($metodi_pagamento) {
$met_trovato = "NO";
$metodi_pagamento = explode(",",$metodi_pagamento);
for ($num2 = 0 ; $num2 < count($metodi_pagamento) ; $num2++) {
if ($met_paga_caparra == $metodi_pagamento[$num2]) $met_trovato = "SI";
} # fine for $num2
if ($met_trovato == "SI") {
$met_paga_caparra = addslashes($met_paga_caparra);
esegui_query("update $tableprenota set metodo_pagamento = '$met_paga_caparra' where idprenota = '$idprenota' ");
if (!$caparra) echo "<br>";
echo mex("Metodo pagamento caparra",$pag).": <b>".stripslashes($met_paga_caparra)."</b>.<br>";
} # fine if ($met_trovato == "SI")
} # fine if ($metodi_pagamento)
} # fine if ($met_paga_caparra and $priv_ins_caparra == "s")

if ($giorno_stima_checkin and $ora_stima_checkin and $min_stima_checkin and $priv_ins_checkin == "s") {
if ($inizioperiodo == $vett_idinizio[$n_t][1]) {
if ($tipo_periodi == "g") $giorni_periodo = $lunghezza_periodo;
else $giorni_periodo = ($lunghezza_periodo * 7);
if (controlla_num_pos($giorno_stima_checkin) == "SI" and $giorno_stima_checkin >= 1 and $giorno_stima_checkin <= 7 and $giorno_stima_checkin <= ($giorni_periodo + 1)) {
$data_stima_checkin = esegui_query("select datainizio from $tableperiodi where idperiodi = '$inizioperiodo'");
$data_stima_checkin = risul_query($data_stima_checkin,0,datainizio);
$data_ini_prenota_f = formatta_data($data_stima_checkin,$stile_data);
$anno_dts = substr($data_stima_checkin,0,4);
$mese_dts = substr($data_stima_checkin,5,2);
$giorno_dts = substr($data_stima_checkin,8,2);
$data_stima_checkin = date("Y-m-d",mktime(0,0,0,$mese_dts,($giorno_dts + $giorno_stima_checkin - 1),$anno_dts));
$stima_checkin = $data_stima_checkin." ".$ora_stima_checkin.":".$min_stima_checkin.":00";
if (ereg("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:00",$stima_checkin)) {
esegui_query("update $tableprenota set checkout = '$stima_checkin' where idprenota = '$idprenota' ");
echo "<br>".mex("Orario stimato di entrata",$pag).": <b>".substr(str_replace($data_ini_prenota_f,"",formatta_data($stima_checkin,$stile_data)),0,-3)."</b>.<br>";
} # fine if (ereg("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:00",$stima_checkin))
} # fine if (controlla_num_pos($giorno_stima_checkin) == "SI" and...
} # fine if ($inizioperiodo == $vett_idinizio[$n_t][1])
} # fine if ($giorno_stima_checkin and $ora_stima_checkin and $min_stima_checkin and $priv_ins_checkin == "s")

if ($conferma_prenota == "SI" and $priv_ins_conferma == "s") {
echo "<br>".mex("Confermata",$pag).".<br>";
esegui_query("update $tableprenota set conferma = 'S' where idprenota = '$idprenota' ");
} # fine if ($conferma_prenota == "SI" and $priv_ins_conferma == "s")

if ($commento and $priv_ins_commento == "s") {
echo "<br>".mex("Commento",$pag).": $commento<br>";
$commento = addslashes($commento);
esegui_query("update $tableprenota set commento = '$commento' where idprenota = '$idprenota' ");
} # fine if ($commento and $priv_ins_commento == "s")

echo "<br>".mex("Prenotazione",$pag)." $idprenota ".mex("inserita",$pag)."!<center>
<form accept-charset=\"utf-8\" method=\"post\" action=\"modifica_prenota.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"id_prenota\" value=\"$idprenota\">
<input type=\"hidden\" name=\"origine\" value=\"inizio.php\">
<input class=\"sbutton\" type=\"submit\" name=\"vai\" value=\"".mex("Modifica la prenotazione",$pag)." $idprenota\">
</form></center>
<hr width=\"95%\">";

$lista_idprenota .= ",$idprenota";
$costo_tot_mess = (double) $costo_tot_mess + (double) $costo_tariffa_tot;
$caparra_mess = (double) $caparra_mess + (double) $caparra;

} # fine for $num1
} # fine for $n_t

if ($idmessaggi) {
$lista_idprenota = substr($lista_idprenota,1);
esegui_query("update $tablemessaggi set dati_messaggio1 = '$lista_idprenota' where tipo_messaggio = 'rprenota' and idutenti $LIKE '%,$id_utente,%' and idmessaggi = '$idmessaggi' ");
if ($dati_mess_calc[0] != $costo_tot_mess) echo "<br><em><b>".mex("Attenzione",$pag)."</b></em>: ".mex("il prezzo totale delle prenotazioni inserite",$pag)." (<em>$costo_tot_mess</em> $Euro) ".mex("è diverso da quello contenuto nel messaggio di richiesta di prenotazione",$pag)." (<em>".$dati_mess_calc[0]."</em> $Euro).<br><hr width=\"95%\">";
if ($dati_mess_calc[1] != $caparra_mess) echo "<br><em><b>".mex("Attenzione",$pag)."</b></em>: ".mex("il prezzo totale delle caparre inserite",$pag)." (<em>$caparra_mess</em> $Euro) ".mex("è diverso da quello contenuto nel messaggio di richiesta di prenotazione",$pag)." (<em>".$dati_mess_calc[1]."</em> $Euro).<br><hr width=\"95%\">";
} # fine if ($idmessaggi)

} # fine if ($continuare != "NO")

unlock_tabelle($tabelle_lock);

} # fine if (!$torna_invece_di_ok)

echo "
<form accept-charset=\"utf-8\" method=\"post\" action=\"prenota.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">";
if ($torna_invece_di_ok == "SI") {
echo "<input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"".mex("Torna indietro",$pag)."\"><br></form>";
} # fine if ($torna_invece_di_ok == "SI")
else {
echo "<center><input class=\"sbutton\" type=\"submit\" name=\"ok\" value=\"".mex("Inserisci una nuova prenotazione",$pag)."\"></center>
<br></form>
<form accept-charset=\"utf-8\" method=\"post\" action=\"inizio.php\"><center>
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"torna\" value=\"".mex("Torna al menù principale",$pag)."\">
<br></center></form>";
} # fine else if ($torna_invece_di_ok == "SI")

} # fine if ($idclienti)



else {


if ($mostra_form_inserisci_prenota != "NO") {

# Inizio della pagina.
echo "<center><font size=+2>".mex("Inserisci una nuova prenotazione",$pag).".</font></center>";

# Form per nuova prenotazione.
echo "<br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"clienti.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input type=\"hidden\" name=\"origine\" value=\"prenota.php\">
<hr width=\"95%\">
".mex("Nuova prenotazione a nome del signor",$pag)." ";
if ($attiva_prefisso_clienti == "p") echo $prefisso_clienti;
echo "<input type=\"text\" name=\"cognome\" value=\"$cognome\">";
if ($attiva_prefisso_clienti == "s") echo $prefisso_clienti." ";
echo "(".mex("cognome",$pag).")<br>";

$rigatariffe = esegui_query("select * from $tablenometariffe where idntariffe = 1 ");
$numero_tariffe = risul_query($rigatariffe,0,nomecostoagg);
include("./includes/funzioni_costi_agg.php");
$dati_ca = dati_costi_agg_ntariffe($tablenometariffe,"NO","SI");

if ($num_tipologie > 1) echo "<table><tr><td height=\"3\"></td></tr></table><table bgcolor=\"#000000\" border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"100%\">";
$bgcolor_tipologia = "#ffffff";

for ($n_t = 1 ; $n_t <= $num_tipologie ; $n_t++) {
if ($num_tipologie > 1) {
echo "<tr><td bgcolor=\"$bgcolor_tipologia\"><b>".mex("Tipologia",$pag)." $n_t</b>: ";
if ($bgcolor_tipologia == "#ffffff") $bgcolor_tipologia = "#efefef";
else $bgcolor_tipologia = "#ffffff";
} # fine if ($num_tipologie > 1)
echo mex("dal",$pag)." ";
if (${"num_app_richiesti".$n_t} != 1) {
${"inizioperiodo".$n_t} = explode(",",${"inizioperiodo".$n_t});
${"inizioperiodo".$n_t} = ${"inizioperiodo".$n_t}[0];
${"fineperiodo".$n_t} = explode(",",${"fineperiodo".$n_t});
${"fineperiodo".$n_t} = ${"fineperiodo".$n_t}[0];
} # fine if (${"num_app_richiesti".$n_t} != 1)
$oggi = date("Y-m-d",(time() + (C_DIFF_ORE * 3600)));
$date_select = esegui_query("select datainizio,datafine from $tableperiodi where datainizio <= '$oggi' and datafine > '$oggi' ");
if (numlin_query($date_select) != 0) {
$inizio_select = risul_query($date_select,0,datainizio);
$fine_select = risul_query($date_select,0,datafine);
} # fine if (numlin_query($date_select) != 0)
if (${"inizioperiodo".$n_t}) {
$date_selected = esegui_query("select datainizio from $tableperiodi where idperiodi = '".addslashes(${"inizioperiodo".$n_t})."'");
$date_selected = risul_query($date_selected,0,datainizio);
} # fine if (${"inizioperiodo".$n_t})
else $date_selected = $inizio_select;
mostra_menu_date("./dati/selperiodimenu$anno.$id_utente.php","inizioperiodo$n_t",$date_selected,"","",$id_utente,$tema);
echo " ".mex("al",$pag)." ";
if (${"fineperiodo".$n_t}) {
$date_selected = esegui_query("select datafine from $tableperiodi where idperiodi = '".addslashes(${"fineperiodo".$n_t})."'");
$date_selected = risul_query($date_selected,0,datafine);
} # fine if (${"fineperiodo".$n_t})
else $date_selected = $fine_select;
mostra_menu_date("./dati/selperiodimenu$anno.$id_utente.php","fineperiodo$n_t",$date_selected,"","",$id_utente,$tema);
if (!$nometipotariffa) $sel = " selected";
else $sel = "";
echo "<br>
".mex("Tipo di tariffa",$pag)." :
<select name=\"nometipotariffa$n_t\">
<option value=\"\"$sel>----</option>";
for ($numtariffa = 1 ; $numtariffa <= $numero_tariffe ; $numtariffa = $numtariffa + 1) {
if ($attiva_tariffe_consentite == "n" or $tariffe_consentite_vett[$numtariffa] == "SI") {
$tariffa = "tariffa".$numtariffa;
$nometariffa = risul_query($rigatariffe,0,$tariffa);
$nometariffa_vedi = $nometariffa;
if ($nometariffa == "") {
$nometariffa = $tariffa;
$nometariffa_vedi = mex("tariffa",$pag).$numtariffa;
} # fine if ($nometariffa == "")
if (${"nometipotariffa".$n_t} == $tariffa) $sel = " selected";
else $sel = "";
echo "
<option value=\"$tariffa\"$sel>$nometariffa_vedi</option>";
} # fine if ($attiva_tariffe_consentite == "n" or $tariffe_consentite_vett[$numtariffa] == "SI")
} # fine for $numtariffa
echo "</select>;";
if ($priv_ins_sconto == "s") echo " ".mex("sconto",$pag).": <input type=\"text\" name=\"sconto$n_t\" size=\"7\" value =\"".${"sconto".$n_t}."\"> $Euro;";
if ($priv_ins_caparra == "s") echo " ".mex("caparra",$pag).": <input type=\"text\" name=\"caparra$n_t\" size=\"7\" value =\"".${"caparra".$n_t}."\"> $Euro (".mex("se diversa dalla normale",$pag).");";
echo "<br>";
if ($priv_ins_num_persone == "s") {
echo " ".mex("nº di persone",$pag).":
<input type=\"text\" name=\"numpersone$n_t\" size=\"2\" maxlength=\"2\" value =\"".${"numpersone".$n_t}."\">.<br>";
} # fine if ($priv_ins_num_persone == "s")

if ($priv_ins_assegnazione_app == "s") {
echo "<br>".mex("Metodo per l'assegnazione dell'appartamento",$pag).":<br>
·".mex("Nº fisso di appartamento",$pag).": 
<select name=\"appartamento$n_t\">
<option value=\"\">--</option>";
unset($condizioni_regole1_consentite);
if ($attiva_regole1_consentite == "s") {
for ($num1 = 0 ; $num1 < count($regole1_consentite) ; $num1++) {
if ($regole1_consentite[$num1]) {
if ($regole1_consentite[$num1] == " ") $appartamenti_agenzia = esegui_query("select app_agenzia from $tableregole where (motivazione = '' or motivazione is null) and app_agenzia is not null");
else $appartamenti_agenzia = esegui_query("select app_agenzia from $tableregole where motivazione = '".$regole1_consentite[$num1]."' and app_agenzia is not null");
for ($num2 = 0 ; $num2 < numlin_query($appartamenti_agenzia) ; $num2++) {
$app_agenzia = risul_query($appartamenti_agenzia,$num2,app_agenzia);
if (str_replace(" '$app_agenzia' ","",$condizioni_regole1_consentite) == $condizioni_regole1_consentite) $condizioni_regole1_consentite .= "idappartamenti = '$app_agenzia' or ";
} # fine for $num2
} # fine if ($regole1_consentite[$num1])
} # fine for $num1
if ($condizioni_regole1_consentite) $condizioni_regole1_consentite = "where ".substr($condizioni_regole1_consentite,0,-4);
else $condizioni_regole1_consentite = "where idappartamenti is null";
} # fine if ($attiva_regole1_consentite == "s")
$appart = esegui_query("select idappartamenti from $tableappartamenti $condizioni_regole1_consentite order by idappartamenti");
for ($num1 = 0 ; $num1 < numlin_query($appart) ; $num1++) {
$idapp = risul_query($appart,$num1,idappartamenti);
if ((!$assegnazioneapp or $assegnazioneapp == "k") and $idapp == ${"appartamento".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$idapp\"$sel>$idapp</option>";
} # fine for $num1
if (${"lista_app".$n_t} and ${"nometipotariffa".$n_t}) {
$regola2_sel = esegui_query("select * from $tableregole where tariffa_per_app = '".addslashes(${"nometipotariffa".$n_t})."'");
if (numlin_query($regola2_sel) == 1) if (${"lista_app".$n_t} == risul_query($regola2_sel,0,motivazione)) ${"lista_app".$n_t} = "";
} # fine if (${"lista_app".$n_t} and ${"nometipotariffa".$n_t})
echo "</select><br>
·".mex("Lista di appartamenti",$pag).":
<input type=\"text\" name=\"lista_app$n_t\" size=\"30\" value =\"".${"lista_app".$n_t}."\"> (".mex("separati da virgole",$pag).").<br>
·".mex("Nº di piano",$pag).": <select name=\"num_piano$n_t\">";
if (!${"num_piano".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"\"$sel>--</option>";
$appart = esegui_query("select numpiano from $tableappartamenti $condizioni_regole1_consentite order by numpiano");
$num_appart = numlin_query($appart);
for ($num1 = 0 ; $num1 < $num_appart ; $num1 = $num1 + 1) {
$piano = risul_query($appart,$num1,numpiano);
if ($piano != $ultimopiano) {
$ultimopiano = $piano;
if ($piano == ${"num_piano".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$piano\"$sel>$piano</option>";
} # fine if ($piano != $ultimopiano)
} # fine for $num1
if (!${"num_casa".$n_t}) $sel = " selected";
else $sel = "";
echo "</select>
 ".mex("e/o di casa",$pag).": <select name=\"num_casa$n_t\">
<option value=\"\"$sel>--</option>";
$appart = esegui_query("select numcasa from $tableappartamenti $condizioni_regole1_consentite order by numcasa");
for ($num1 = 0 ; $num1 < $num_appart ; $num1 = $num1 + 1) {
$casa = risul_query($appart,$num1,numcasa);
if ($casa != $ultimacasa) {
$ultimacasa = $casa;
if ($casa == ${"num_casa".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$casa\"$sel>$casa</option>";
} # fine if ($piano != $ultimopiano)
} # fine for $num1
if (!${"num_persone_casa".$n_t}) $sel = " selected";
else $sel = "";
echo "</select> ".mex("e/o di persone",$pag).": <select name=\"num_persone_casa$n_t\">
<option value=\"\"$sel>--</option>";
$appart = esegui_query("select maxoccupanti from $tableappartamenti $condizioni_regole1_consentite order by maxoccupanti");
for ($num1 = 0 ; $num1 < $num_appart ; $num1 = $num1 + 1) {
$persone_casa = risul_query($appart,$num1,maxoccupanti);
if ($persone_casa != $ultime_persone_casa) {
$ultime_persone_casa = $persone_casa;
if ($persone_casa == ${"num_persone_casa".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$persone_casa\"$sel>$persone_casa</option>";
} # fine if ($persone_casa != $ultimepersone_casa)
} # fine for $num1
echo "</select><br>";
} # fine if ($priv_ins_assegnazione_app == "s")

echo "<br>";
if ($priv_ins_checkin == "s") {
if (!${"giorno_stima_checkin".$n_t}) ${"giorno_stima_checkin".$n_t} = 1;
${"g_ckn_sel".${"giorno_stima_checkin".$n_t}."_".$n_t} = " selected";
echo mex("Orario stimato di entrata",$pag).": ".mex("giorno",$pag)."
 <select name=\"giorno_stima_checkin$n_t\">
<option value=\"1\"".${"g_ckn_sel1_".$n_t}.">1</option>
<option value=\"2\"".${"g_ckn_sel2_".$n_t}.">2</option>
<option value=\"3\"".${"g_ckn_sel3_".$n_t}.">3</option>
<option value=\"4\"".${"g_ckn_sel4_".$n_t}.">4</option>
<option value=\"5\"".${"g_ckn_sel5_".$n_t}.">5</option>
<option value=\"6\"".${"g_ckn_sel6_".$n_t}.">6</option>
<option value=\"7\"".${"g_ckn_sel7_".$n_t}.">7</option>
</select>&nbsp;&nbsp;&nbsp;&nbsp;";
if (!${"ora_stima_checkin".$n_t}) $sel = " selected";
else $sel = "";
echo "<select name=\"ora_stima_checkin$n_t\">
<option value=\"\"$sel>--</option>";
for ($num1 = 0 ; $num1 < 24 ; $num1++) {
if (strlen($num1) == 1) $num1 = "0".$num1;
if ($num1 == ${"ora_stima_checkin".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$num1\"$sel>$num1</option>";
} # fine for $num1
if (!${"min_stima_checkin".$n_t}) $sel = " selected";
else $sel = "";
echo "</select>:<select name=\"min_stima_checkin$n_t\">
<option value=\"\"$sel>--</option>";
for ($num1 = 0 ; $num1 < 60 ; $num1 = $num1 + 15) {
if (strlen($num1) == 1) $num1 = "0".$num1;
if ($num1 == ${"min_stima_checkin".$n_t}) $sel = " selected";
else $sel = "";
echo "<option value=\"$num1\"$sel>$num1</option>";
} # fine for $num1
echo "</select>.<br>";
} # fine if ($priv_ins_checkin == "s")
if ($priv_ins_caparra == "s") {
$metodi_pagamento = esegui_query("select valpersonalizza from $tablepersonalizza where idpersonalizza = 'metodi_pagamento' and idutente = '$id_utente'");
$metodi_pagamento = risul_query($metodi_pagamento,0,valpersonalizza);
if ($metodi_pagamento) {
if (!${"met_paga_caparra".$n_t}) $sel = " selected";
else $sel = "";
echo mex("Metodo pagamento caparra",$pag).": <select name=\"met_paga_caparra$n_t\">
<option value=\"\"$sel>----</option>";
$metodi_pagamento = explode(",",$metodi_pagamento);
for ($num1 = 0 ; $num1 < count($metodi_pagamento) ; $num1++) {
if (${"met_paga_caparra".$n_t} == $metodi_pagamento[$num1]) $sel = " selected";
else $sel = "";
echo "<option value=\"".$metodi_pagamento[$num1]."\"$sel>".$metodi_pagamento[$num1]."</option>";
} # fine for $num1
echo "</select>.<br>";
} # fine if ($metodi_pagamento)
} # fine if ($priv_ins_caparra == "s")
if ($priv_ins_multiple == "s") {
echo "<table><tr><td>".mex("Nº di prenotazioni di questa tipologia",$pag).":";
if (!${"num_app_richiesti".$n_t}) ${"num_app_richiesti".$n_t} = 1;
echo "<input type=\"text\" name=\"num_app_richiesti$n_t\" size=\"2\" maxlength=\"2\" value =\"".${"num_app_richiesti".$n_t}."\">.";
if ($num_tipologie == $n_t and $num_tipologie < 999) echo "</td><td width=\"80\"></td><td><input class=\"sbutton\" type=\"submit\" name=\"aggiungi_tipologie\" value =\"".mex("Aggiungi altre tipologie",$pag)."\">";
echo "</td></tr></table><br>";
} # fine if ($priv_ins_multiple == "s")
else echo "<input type=\"hidden\" name=\"num_app_richiesti1\" value=\"1\">";
if ($priv_ins_conferma == "s") {
if (${"conferma_prenota".$n_t} == "SI") $checked = " checked";
else $checked = "";
echo "<input type=\"checkbox\" name=\"conferma_prenota$n_t\" value=\"SI\"$checked>
".mex("confermata",$pag).".<br>";
} # fine if ($priv_ins_conferma == "s")

$numcostiagg = 0;
if ($priv_ins_costi_agg == "s") {
for ($num1 = 0 ; $num1 < $dati_ca[num] ; $num1++) {
if ($attiva_costi_agg_consentiti == "n" or $costi_agg_consentiti_vett[$dati_ca[$num1][id]] == "SI") {
$numcostiagg++;
$costoagg = "costoagg".$numcostiagg;
if ($dati_ca[$num1][tipo] == "u") $tipo_ca = "unico";
if ($dati_ca[$num1][tipo] == "s") $tipo_ca = "$parola_settimanale";
if (${$costoagg."_".$n_t} == "SI") $checked = " checked";
else $checked = "";
echo "<input type=\"hidden\" name=\"idcostoagg$numcostiagg"."_$n_t\" value=\"".$dati_ca[$num1][id]."\">
<input type=\"checkbox\" name=\"$costoagg"."_$n_t\" value=\"SI\"$checked>
".mex("costo aggiuntivo $tipo_ca",$pag)." \"".$dati_ca[$num1][nome]."\"";
if ($dati_ca[$num1][numsett] == "c" and $dati_ca[$num1][associasett] == "n") {
$numsettimane = "numsettimane".$numcostiagg;
if (${$numsettimane."_".$n_t}) $valnumsettimane = ${$numsettimane."_".$n_t};
else $valnumsettimane = 0;
echo ", ".mex("nº di $parola_settimane da applicare",$pag).":
<input type=\"text\" name=\"$numsettimane"."_$n_t\" size=\"3\" maxlength=\"3\" value=\"$valnumsettimane\">";
} # fine if ($dati_ca[$num1][numsett] == "c" and...
if ($dati_ca[$num1][moltiplica] == "c") {
$nummoltiplica_ca = "nummoltiplica_ca".$numcostiagg;
if (${$nummoltiplica_ca."_".$n_t}) $valnummoltiplica_ca = ${$nummoltiplica_ca."_".$n_t};
else $valnummoltiplica_ca = 1;
echo ", ".mex("da moltiplicare per",$pag).":
<input type=\"text\" name=\"$nummoltiplica_ca"."_$n_t\" size=\"3\" maxlength=\"3\" value=\"$valnummoltiplica_ca\">";
} # fine if ($dati_ca[$num1][moltiplica] == "c")
echo ".<br>";
} # fine if ($attiva_costi_agg_consentiti == "n" or...
} # fine for $num1
} # fine if ($priv_ins_costi_agg == "s")

if ($priv_ins_commento == "s") {
if (@get_magic_quotes_gpc()) ${"commento".$n_t} = stripslashes(${"commento".$n_t});
${"commento".$n_t} = htmlspecialchars(${"commento".$n_t});
echo "<br>".mex("Commento",$pag).":<br>
 <textarea name=\"commento$n_t\" rows=3 cols=45 wrap=\"virtual\">".${"commento".$n_t}."</textarea><br>";
} # fine if ($priv_ins_commento == "s")
if ($num_tipologie > 1) echo "</td></tr>";
} # fine for $n_t

if ($num_tipologie > 1) echo "</table><br>";
if ($idmessaggi) echo "<input type=\"hidden\" name=\"idmessaggi\" value=\"$idmessaggi\">";
echo "<center><input type=\"hidden\" name=\"numcostiagg\" value=\"$numcostiagg\">
<input type=\"hidden\" name=\"num_tipologie\" value=\"$num_tipologie\">
<input type=\"hidden\" name=\"mos_tut_dat\" value=\"$mos_tut_dat\">
<input type=\"hidden\" name=\"nuovaprenotazione\" value=\"SI\">
<input class=\"sbutton\" type=\"submit\" name=\"ins_nuova_prenota\" value=\"".mex("Inserisci la prenotazione",$pag)."\">
<hr width=\"95%\">
</form><br>
<form accept-charset=\"utf-8\" method=\"post\" action=\"inizio.php\">
<input type=\"hidden\" name=\"anno\" value=\"$anno\">
<input type=\"hidden\" name=\"id_sessione\" value=\"$id_sessione\">
<input class=\"sbutton\" type=\"submit\" name=\"torna\" value=\"".mex("Torna al menù principale",$pag)."\">
<br></center></form>";

} # fine if ($mostra_form_inserisci_prenota != "NO")


} # fine else if ($idclienti)



if ($tema[$id_utente] and $tema[$id_utente] != "base" and @is_dir("./includes/themes/".$tema[$id_utente])) include("./includes/themes/".$tema[$id_utente]."/foot.php");
else include("./includes/foot.php");


} # fine if ($anno_utente_attivato == "SI" and $priv_ins_nuove_prenota == "s")
} # fine if ($id_utente)



?>

