<?php

##################################################################################
#    HOTELDRUID
#    Copyright (C) 2001-2023 by Marco Maria Francesco De Santis (marco@digitaldruid.net)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    any later version accepted by Marco Maria Francesco De Santis, which
#    shall act as a proxy as defined in Section 14 of version 3 of the
#    license.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##################################################################################

#Funzioni per usare il database POSTGRESQL

ignore_user_abort(1);

# variabili per le differenze nella sintassi delle query
#global $ILIKE,$LIKE;
$ILIKE = "ILIKE";
$LIKE = "LIKE";
$DATETIME = "timestamp";
$MEDIUMTEXT = "text";



function connetti_db ($database,$host,$port,$user,$password,$estensione) {

global $link_pgsql;
if ($estensione == "SI") dl("pgsql.so");
$link_pgsql = pg_connect("dbname=$database host=$host port=$port user=$user password=$password ");
pg_exec($link_pgsql,"set datestyle to 'iso'");

return $link_pgsql;

} # fine function connetti_db



function disconnetti_db ($numconnessione) {

$risul = pg_close($numconnessione);
return $risul;

} # fine function disconnetti_db



if (substr($PHPR_LOG,0,2) != "SI") {

function esegui_query ($query,$silenzio = "",$idlog = "") {

global $link_pgsql;
$risul = pg_exec($link_pgsql,$query);
if (!$risul and $silenzio != "totale") {
global $PHPR_TAB_PRE;
if (!$silenzio) echo "<br>ERROR in: ".htmlspecialchars(str_replace(" ".$PHPR_TAB_PRE," ",$query))."<br>";
error_log("IN ".$_SERVER['PHP_SELF']." PGSQL ERROR: ".substr(str_replace(" ".$PHPR_TAB_PRE," ",$query),0,25)."...");
} # fine (!$risul and $silenzio != "totale")
return $risul;

} # fine function esegui_query

} # fine if (substr($PHPR_LOG,0,2) != "SI")


else {
if (!function_exists("inserisci_log")) include("./includes/funzioni_log.php");

function esegui_query ($query,$silenzio = "",$idlog = "") {

global $link_pgsql;
$risul = pg_exec($link_pgsql,$query);
if (!$risul and $silenzio != "totale") {
global $PHPR_TAB_PRE;
if (!$silenzio) echo "<br>ERROR in: ".htmlspecialchars(str_replace(" ".$PHPR_TAB_PRE," ",$query))."<br>";
error_log("IN ".$_SERVER['PHP_SELF']." PGSQL ERROR: ".substr(str_replace(" ".$PHPR_TAB_PRE," ",$query),0,25)."...");
} # fine (!$risul and $silenzio != "totale")

if ($idlog != 1) inserisci_log($query,$idlog);

return $risul;

} # fine function esegui_query

} # fine else if (substr($PHPR_LOG,0,2) != "SI")



if (function_exists('pg_fetch_result')) {

function risul_query ($query,$riga,$colonna,$tab="") {

$risul = pg_fetch_result($query,$riga,$colonna);
return $risul;

} # fine function risul_query



function numlin_query ($query) {

$risul = pg_num_rows($query);
return $risul;

} # fine function numlin_query

} # fine if (function_exists('pg_fetch_result'))


else {

function risul_query ($query,$riga,$colonna,$tab="") {

$risul = pg_result($query,$riga,$colonna);
return $risul;

} # fine function risul_query



function numlin_query ($query) {

$risul = pg_numrows($query);
return $risul;

} # fine function numlin_query

} # fine else if (function_exists('pg_fetch_result'))



function correggi_utf8_reale (&$str) {
# espressione regolare da standard w3: https://www.w3.org/International/questions/qa-forms-utf-8.en
if (!preg_match('%^(?:
   [\x09\x0A\x0D\x20-\x7E]           # ASCII
 | [\xC2-\xDF][\x80-\xBF]            # non-overlong 2-byte
 | \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
 | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2} # straight 3-byte
 | \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
 | \xF0[\x90-\xBF][\x80-\xBF]{2}     # planes 1-3
 | [\xF1-\xF3][\x80-\xBF]{3}         # planes 4-15
 | \xF4[\x80-\x8F][\x80-\xBF]{2}     # plane 16
)*$%xs',$str)) {
if (function_exists('mb_convert_encoding')) $str = mb_convert_encoding($str,'UTF-8','UTF-8');
else {
if (function_exists('iconv')) $str = @iconv('CP1252','UTF-8//IGNORE',$str);
else $str = "?";
} # fine else if (function_exists('mb_convert_encoding'))
} # fine if (!preg_match('%^(?:...
} # fine function correggi_utf8_reale

if (function_exists('version_compare') and version_compare(PHP_VERSION,'7.0.0','>=')) {
function correggi_utf8 (&$str) {
if (isset($str)) correggi_utf8_reale($str);
}
} # fine if (function_exists('version_compare') and version_compare(PHP_VERSION,'7.0.0','>='))
else {
function correggi_utf8 (&$str) {
# bug con preg_match troppo lungo di php5
if (isset($str) and strlen($str) < 7000) correggi_utf8_reale($str);
}
} # fine else if (function_exists('version_compare') and version_compare(PHP_VERSION,'7.0.0','>='))



if (function_exists('pg_escape_string')) {
function aggslashdb ($stringa) {

global $link_pgsql;
correggi_utf8($stringa);
$risul = pg_escape_string($link_pgsql,$stringa);
return $risul;

} # fine function aggslashdb
} # fine if (function_exists('pg_escape_string'))

else {
function aggslashdb ($stringa) {

correggi_utf8($stringa);
$risul = addslashes($stringa);
return $risul;

} # fine function aggslashdb
} # fine else if (function_exists('pg_escape_string'))



function arraylin_query ($query,$num) {

$risul = pg_fetch_row($query,$num);
return $risul;

} # fine function arraylin_query



function numcampi_query ($query) {

$risul = pg_numfields($query);
return $risul;

} # fine function numcampi_query



function nomecampo_query ($query,$num) {

$risul = pg_fieldname($query,$num);
return $risul;

} # fine function nomecampo_query



function tipocampo_query ($query,$num) {

$risul = pg_fieldtype($query,$num);
return $risul;

} # fine function tipocampo_query



function dimcampo_query ($query,$num) {

$risul = pg_fieldsize($query,$num);
return $risul;

} # fine function dimcampo_query



function chiudi_query (&$query) {

pg_free_result($query);
$query = "";

} # fine function chiudi_query



function lock_tabelle ($tabelle,$altre_tab_usate = "") {

if (@is_array($tabelle)) {
global $link_pgsql;
pg_exec($link_pgsql,"begin");
$num_tabelle = count($tabelle);
for ($num1 = 0 ; $num1 < $num_tabelle; $num1++) {
$tabella = $tabelle[$num1];
pg_exec($link_pgsql,"lock table $tabella");
} # fine for $num1
$risul = "commit";
} # fine if (@is_array($tabelle))
else $risul = "nocommit";

return $risul;

} # fine function lock_tabelle



function unlock_tabelle (&$tabelle_lock,$azione = "") {

if ($tabelle_lock != "nocommit") {
global $link_pgsql;
if ($azione == "rollback") pg_exec($link_pgsql,"rollback");
else pg_exec($link_pgsql,"commit");
} # fine if ($tabelle_lock != "nocommit")
$tabelle_lock = null;

} # fine function unlock_tabelle



function crea_indice ($tabella,$colonne,$nome) {

pg_exec("create index $nome on $tabella ($colonne)");

} # fine function crea_indice



?>
